/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.xml.core;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import org.simpleframework.xml.core.MethodName;
import org.simpleframework.xml.core.MethodPart;
import org.simpleframework.xml.core.MethodType;
import org.simpleframework.xml.core.Reflector;
import org.simpleframework.xml.util.Cache;
import org.simpleframework.xml.util.ConcurrentCache;

class GetPart
implements MethodPart {
    private final Cache<Annotation> cache = new ConcurrentCache<Annotation>();
    private final Annotation[] list;
    private final Annotation label;
    private final MethodType type;
    private final Method method;
    private final String name;

    public GetPart(MethodName methodName, Annotation annotation, Annotation[] annotationArray) {
        this.method = methodName.getMethod();
        this.name = methodName.getName();
        this.type = methodName.getType();
        this.label = annotation;
        this.list = annotationArray;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Class getType() {
        return this.method.getReturnType();
    }

    @Override
    public Class getDependent() {
        return Reflector.getReturnDependent(this.method);
    }

    @Override
    public Class[] getDependents() {
        return Reflector.getReturnDependents(this.method);
    }

    @Override
    public Class getDeclaringClass() {
        return this.method.getDeclaringClass();
    }

    @Override
    public Annotation getAnnotation() {
        return this.label;
    }

    @Override
    public <T extends Annotation> T getAnnotation(Class<T> clazz) {
        if (this.cache.isEmpty()) {
            for (Annotation annotation : this.list) {
                Class<? extends Annotation> clazz2 = annotation.annotationType();
                this.cache.cache(clazz2, annotation);
            }
        }
        return (T)this.cache.fetch(clazz);
    }

    @Override
    public MethodType getMethodType() {
        return this.type;
    }

    @Override
    public Method getMethod() {
        if (!this.method.isAccessible()) {
            this.method.setAccessible(true);
        }
        return this.method;
    }

    @Override
    public String toString() {
        return this.method.toGenericString();
    }
}

