/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.xml.core;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.List;
import org.simpleframework.xml.Attribute;
import org.simpleframework.xml.DefaultType;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.ElementArray;
import org.simpleframework.xml.ElementList;
import org.simpleframework.xml.ElementListUnion;
import org.simpleframework.xml.ElementMap;
import org.simpleframework.xml.ElementMapUnion;
import org.simpleframework.xml.ElementUnion;
import org.simpleframework.xml.Text;
import org.simpleframework.xml.Transient;
import org.simpleframework.xml.Version;
import org.simpleframework.xml.core.AnnotationFactory;
import org.simpleframework.xml.core.Contact;
import org.simpleframework.xml.core.ContactList;
import org.simpleframework.xml.core.ContactMap;
import org.simpleframework.xml.core.Detail;
import org.simpleframework.xml.core.FieldContact;
import org.simpleframework.xml.core.FieldDetail;
import org.simpleframework.xml.core.Reflector;
import org.simpleframework.xml.core.Support;

class FieldScanner
extends ContactList {
    private final AnnotationFactory factory;
    private final ContactMap done;
    private final Support support;

    public FieldScanner(Detail detail, Support support) throws Exception {
        this.factory = new AnnotationFactory(detail, support);
        this.done = new ContactMap();
        this.support = support;
        this.scan(detail);
    }

    private void scan(Detail detail) throws Exception {
        DefaultType defaultType = detail.getOverride();
        DefaultType defaultType2 = detail.getAccess();
        Class clazz = detail.getSuper();
        if (clazz != null) {
            this.extend(clazz, defaultType);
        }
        this.extract(detail, defaultType2);
        this.extract(detail);
        this.build();
    }

    private void extend(Class clazz, DefaultType defaultType) throws Exception {
        ContactList contactList = this.support.getFields(clazz, defaultType);
        if (contactList != null) {
            this.addAll(contactList);
        }
    }

    private void extract(Detail detail) {
        List<FieldDetail> list = detail.getFields();
        for (FieldDetail fieldDetail : list) {
            Annotation[] annotationArray = fieldDetail.getAnnotations();
            Field field = fieldDetail.getField();
            for (Annotation annotation : annotationArray) {
                this.scan(field, annotation, annotationArray);
            }
        }
    }

    private void extract(Detail detail, DefaultType defaultType) throws Exception {
        List<FieldDetail> list = detail.getFields();
        if (defaultType == DefaultType.FIELD) {
            for (FieldDetail fieldDetail : list) {
                Annotation[] annotationArray = fieldDetail.getAnnotations();
                Field field = fieldDetail.getField();
                Class<?> clazz = field.getType();
                if (this.isStatic(field) || this.isTransient(field)) continue;
                this.process(field, clazz, annotationArray);
            }
        }
    }

    private void scan(Field field, Annotation annotation, Annotation[] annotationArray) {
        if (annotation instanceof Attribute) {
            this.process(field, annotation, annotationArray);
        }
        if (annotation instanceof ElementUnion) {
            this.process(field, annotation, annotationArray);
        }
        if (annotation instanceof ElementListUnion) {
            this.process(field, annotation, annotationArray);
        }
        if (annotation instanceof ElementMapUnion) {
            this.process(field, annotation, annotationArray);
        }
        if (annotation instanceof ElementList) {
            this.process(field, annotation, annotationArray);
        }
        if (annotation instanceof ElementArray) {
            this.process(field, annotation, annotationArray);
        }
        if (annotation instanceof ElementMap) {
            this.process(field, annotation, annotationArray);
        }
        if (annotation instanceof Element) {
            this.process(field, annotation, annotationArray);
        }
        if (annotation instanceof Version) {
            this.process(field, annotation, annotationArray);
        }
        if (annotation instanceof Text) {
            this.process(field, annotation, annotationArray);
        }
        if (annotation instanceof Transient) {
            this.remove(field, annotation);
        }
    }

    private void process(Field field, Class clazz, Annotation[] annotationArray) throws Exception {
        Class[] classArray = Reflector.getDependents(field);
        Annotation annotation = this.factory.getInstance(clazz, classArray);
        if (annotation != null) {
            this.process(field, annotation, annotationArray);
        }
    }

    private void process(Field field, Annotation annotation, Annotation[] annotationArray) {
        FieldContact fieldContact = new FieldContact(field, annotation, annotationArray);
        FieldKey fieldKey = new FieldKey(field);
        if (!field.isAccessible()) {
            field.setAccessible(true);
        }
        this.insert(fieldKey, fieldContact);
    }

    private void insert(Object object, Contact contact) {
        Contact contact2 = (Contact)this.done.remove(object);
        if (contact2 != null && this.isText(contact)) {
            contact = contact2;
        }
        this.done.put(object, contact);
    }

    private boolean isText(Contact contact) {
        Annotation annotation = contact.getAnnotation();
        return annotation instanceof Text;
    }

    private void remove(Field field, Annotation annotation) {
        this.done.remove(new FieldKey(field));
    }

    private void build() {
        for (Contact contact : this.done) {
            this.add(contact);
        }
    }

    private boolean isStatic(Field field) {
        int n = field.getModifiers();
        return Modifier.isStatic(n);
    }

    private boolean isTransient(Field field) {
        int n = field.getModifiers();
        return Modifier.isTransient(n);
    }

    private static class FieldKey {
        private final Class type;
        private final String name;

        public FieldKey(Field field) {
            this.type = field.getDeclaringClass();
            this.name = field.getName();
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public boolean equals(Object object) {
            if (object instanceof FieldKey) {
                return this.equals((FieldKey)object);
            }
            return false;
        }

        private boolean equals(FieldKey fieldKey) {
            if (fieldKey.type != this.type) {
                return false;
            }
            return fieldKey.name.equals(this.name);
        }
    }
}

