/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.xml.core;

import org.simpleframework.xml.DefaultType;
import org.simpleframework.xml.core.ContactList;
import org.simpleframework.xml.core.Detail;
import org.simpleframework.xml.core.DetailScanner;
import org.simpleframework.xml.core.FieldScanner;
import org.simpleframework.xml.core.MethodScanner;
import org.simpleframework.xml.core.Support;
import org.simpleframework.xml.util.Cache;
import org.simpleframework.xml.util.ConcurrentCache;

class DetailExtractor {
    private final Cache<ContactList> methods = new ConcurrentCache<ContactList>();
    private final Cache<ContactList> fields = new ConcurrentCache<ContactList>();
    private final Cache<Detail> details = new ConcurrentCache<Detail>();
    private final DefaultType override;
    private final Support support;

    public DetailExtractor(Support support) {
        this(support, null);
    }

    public DetailExtractor(Support support, DefaultType defaultType) {
        this.override = defaultType;
        this.support = support;
    }

    public Detail getDetail(Class clazz) {
        Detail detail = this.details.fetch(clazz);
        if (detail == null) {
            detail = new DetailScanner(clazz, this.override);
            this.details.cache(clazz, detail);
        }
        return detail;
    }

    public ContactList getFields(Class clazz) throws Exception {
        Detail detail;
        ContactList contactList = this.fields.fetch(clazz);
        if (contactList == null && (detail = this.getDetail(clazz)) != null) {
            contactList = this.getFields(clazz, detail);
        }
        return contactList;
    }

    private ContactList getFields(Class clazz, Detail detail) throws Exception {
        FieldScanner fieldScanner = new FieldScanner(detail, this.support);
        if (detail != null) {
            this.fields.cache(clazz, fieldScanner);
        }
        return fieldScanner;
    }

    public ContactList getMethods(Class clazz) throws Exception {
        Detail detail;
        ContactList contactList = this.methods.fetch(clazz);
        if (contactList == null && (detail = this.getDetail(clazz)) != null) {
            contactList = this.getMethods(clazz, detail);
        }
        return contactList;
    }

    private ContactList getMethods(Class clazz, Detail detail) throws Exception {
        MethodScanner methodScanner = new MethodScanner(detail, this.support);
        if (detail != null) {
            this.methods.cache(clazz, methodScanner);
        }
        return methodScanner;
    }
}

