/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.xml.core;

import org.simpleframework.xml.core.Context;
import org.simpleframework.xml.core.Converter;
import org.simpleframework.xml.core.Entry;
import org.simpleframework.xml.core.PersistenceException;
import org.simpleframework.xml.core.Traverser;
import org.simpleframework.xml.strategy.Type;
import org.simpleframework.xml.stream.InputNode;
import org.simpleframework.xml.stream.OutputNode;
import org.simpleframework.xml.stream.Style;

class CompositeValue
implements Converter {
    private final Context context;
    private final Traverser root;
    private final Style style;
    private final Entry entry;
    private final Type type;

    public CompositeValue(Context context, Entry entry, Type type) throws Exception {
        this.root = new Traverser(context);
        this.style = context.getStyle();
        this.context = context;
        this.entry = entry;
        this.type = type;
    }

    @Override
    public Object read(InputNode inputNode) throws Exception {
        InputNode inputNode2 = inputNode.getNext();
        Class clazz = this.type.getType();
        if (inputNode2 == null) {
            return null;
        }
        if (inputNode2.isEmpty()) {
            return null;
        }
        return this.root.read(inputNode2, clazz);
    }

    @Override
    public Object read(InputNode inputNode, Object object) throws Exception {
        Class clazz = this.type.getType();
        if (object != null) {
            throw new PersistenceException("Can not read value of %s for %s", clazz, this.entry);
        }
        return this.read(inputNode);
    }

    @Override
    public boolean validate(InputNode inputNode) throws Exception {
        Class clazz = this.type.getType();
        String string = this.entry.getValue();
        if (string == null) {
            string = this.context.getName(clazz);
        }
        return this.validate(inputNode, string);
    }

    private boolean validate(InputNode inputNode, String string) throws Exception {
        String string2 = this.style.getElement(string);
        InputNode inputNode2 = inputNode.getNext(string2);
        Class clazz = this.type.getType();
        if (inputNode2 == null) {
            return true;
        }
        if (inputNode2.isEmpty()) {
            return true;
        }
        return this.root.validate(inputNode2, clazz);
    }

    @Override
    public void write(OutputNode outputNode, Object object) throws Exception {
        Class clazz = this.type.getType();
        String string = this.entry.getValue();
        if (string == null) {
            string = this.context.getName(clazz);
        }
        String string2 = this.style.getElement(string);
        this.root.write(outputNode, object, clazz, string2);
    }
}

