/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.xml.core;

import java.util.Map;
import org.simpleframework.xml.core.Context;
import org.simpleframework.xml.core.Converter;
import org.simpleframework.xml.core.Entry;
import org.simpleframework.xml.core.MapFactory;
import org.simpleframework.xml.core.Repeater;
import org.simpleframework.xml.strategy.Type;
import org.simpleframework.xml.stream.InputNode;
import org.simpleframework.xml.stream.Mode;
import org.simpleframework.xml.stream.OutputNode;
import org.simpleframework.xml.stream.Style;

class CompositeInlineMap
implements Repeater {
    private final MapFactory factory;
    private final Converter value;
    private final Converter key;
    private final Style style;
    private final Entry entry;

    public CompositeInlineMap(Context context, Entry entry, Type type) throws Exception {
        this.factory = new MapFactory(context, type);
        this.value = entry.getValue(context);
        this.key = entry.getKey(context);
        this.style = context.getStyle();
        this.entry = entry;
    }

    @Override
    public Object read(InputNode inputNode) throws Exception {
        Object object = this.factory.getInstance();
        Map map = (Map)object;
        if (map != null) {
            return this.read(inputNode, map);
        }
        return null;
    }

    @Override
    public Object read(InputNode inputNode, Object object) throws Exception {
        Map map = (Map)object;
        if (map != null) {
            return this.read(inputNode, map);
        }
        return this.read(inputNode);
    }

    private Object read(InputNode inputNode, Map map) throws Exception {
        InputNode inputNode2 = inputNode.getParent();
        String string = inputNode.getName();
        while (inputNode != null) {
            Object object = this.key.read(inputNode);
            Object object2 = this.value.read(inputNode);
            if (map != null) {
                map.put(object, object2);
            }
            inputNode = inputNode2.getNext(string);
        }
        return map;
    }

    @Override
    public boolean validate(InputNode inputNode) throws Exception {
        InputNode inputNode2 = inputNode.getParent();
        String string = inputNode.getName();
        while (inputNode != null) {
            if (!this.key.validate(inputNode)) {
                return false;
            }
            if (!this.value.validate(inputNode)) {
                return false;
            }
            inputNode = inputNode2.getNext(string);
        }
        return true;
    }

    @Override
    public void write(OutputNode outputNode, Object object) throws Exception {
        OutputNode outputNode2 = outputNode.getParent();
        Mode mode = outputNode.getMode();
        Map map = (Map)object;
        if (!outputNode.isCommitted()) {
            outputNode.remove();
        }
        this.write(outputNode2, map, mode);
    }

    private void write(OutputNode outputNode, Map map, Mode mode) throws Exception {
        String string = this.entry.getEntry();
        String string2 = this.style.getElement(string);
        for (Object k : map.keySet()) {
            OutputNode outputNode2 = outputNode.getChild(string2);
            Object v = map.get(k);
            outputNode2.setMode(mode);
            this.key.write(outputNode2, k);
            this.value.write(outputNode2, v);
        }
    }
}

