/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.xml.core;

import org.simpleframework.xml.Version;
import org.simpleframework.xml.core.AttributeException;
import org.simpleframework.xml.core.Caller;
import org.simpleframework.xml.core.Collector;
import org.simpleframework.xml.core.Contact;
import org.simpleframework.xml.core.Context;
import org.simpleframework.xml.core.Converter;
import org.simpleframework.xml.core.Criteria;
import org.simpleframework.xml.core.Decorator;
import org.simpleframework.xml.core.ElementException;
import org.simpleframework.xml.core.Instance;
import org.simpleframework.xml.core.Instantiator;
import org.simpleframework.xml.core.Label;
import org.simpleframework.xml.core.LabelMap;
import org.simpleframework.xml.core.ObjectFactory;
import org.simpleframework.xml.core.PersistenceException;
import org.simpleframework.xml.core.Primitive;
import org.simpleframework.xml.core.Revision;
import org.simpleframework.xml.core.Schema;
import org.simpleframework.xml.core.Section;
import org.simpleframework.xml.core.TextException;
import org.simpleframework.xml.core.ValueRequiredException;
import org.simpleframework.xml.core.Variable;
import org.simpleframework.xml.strategy.Type;
import org.simpleframework.xml.stream.InputNode;
import org.simpleframework.xml.stream.NamespaceMap;
import org.simpleframework.xml.stream.NodeMap;
import org.simpleframework.xml.stream.OutputNode;
import org.simpleframework.xml.stream.Position;

class Composite
implements Converter {
    private final ObjectFactory factory;
    private final Primitive primitive;
    private final Criteria criteria;
    private final Revision revision;
    private final Context context;
    private final Type type;

    public Composite(Context context, Type type) {
        this(context, type, null);
    }

    public Composite(Context context, Type type, Class clazz) {
        this.factory = new ObjectFactory(context, type, clazz);
        this.primitive = new Primitive(context, type);
        this.criteria = new Collector();
        this.revision = new Revision();
        this.context = context;
        this.type = type;
    }

    @Override
    public Object read(InputNode inputNode) throws Exception {
        Instance instance = this.factory.getInstance(inputNode);
        Class clazz = instance.getType();
        if (instance.isReference()) {
            return instance.getInstance();
        }
        if (this.context.isPrimitive(clazz)) {
            return this.readPrimitive(inputNode, instance);
        }
        return this.read(inputNode, instance, clazz);
    }

    @Override
    public Object read(InputNode inputNode, Object object) throws Exception {
        Class<?> clazz = object.getClass();
        Schema schema = this.context.getSchema(clazz);
        Caller caller = schema.getCaller();
        this.read(inputNode, object, schema);
        this.criteria.commit(object);
        caller.validate(object);
        caller.commit(object);
        return this.readResolve(inputNode, object, caller);
    }

    private Object read(InputNode inputNode, Instance instance, Class clazz) throws Exception {
        Schema schema = this.context.getSchema(clazz);
        Caller caller = schema.getCaller();
        Builder builder = this.read(schema, instance);
        Object object = builder.read(inputNode);
        caller.validate(object);
        caller.commit(object);
        instance.setInstance(object);
        return this.readResolve(inputNode, object, caller);
    }

    private Builder read(Schema schema, Instance instance) throws Exception {
        Instantiator instantiator = schema.getInstantiator();
        if (instantiator.isDefault()) {
            return new Builder(this, this.criteria, schema, instance);
        }
        return new Injector(this, this.criteria, schema, instance);
    }

    private Object readPrimitive(InputNode inputNode, Instance instance) throws Exception {
        Class clazz = instance.getType();
        Object object = this.primitive.read(inputNode, clazz);
        if (clazz != null) {
            instance.setInstance(object);
        }
        return object;
    }

    private Object readResolve(InputNode inputNode, Object object, Caller caller) throws Exception {
        if (object != null) {
            Class<?> clazz;
            Position position = inputNode.getPosition();
            Object object2 = caller.resolve(object);
            Class clazz2 = this.type.getType();
            if (!clazz2.isAssignableFrom(clazz = object2.getClass())) {
                throw new ElementException("Type %s does not match %s at %s", clazz, clazz2, position);
            }
            return object2;
        }
        return object;
    }

    private void read(InputNode inputNode, Object object, Schema schema) throws Exception {
        Section section = schema.getSection();
        this.readVersion(inputNode, object, schema);
        this.readSection(inputNode, object, section);
    }

    private void readSection(InputNode inputNode, Object object, Section section) throws Exception {
        this.readText(inputNode, object, section);
        this.readAttributes(inputNode, object, section);
        this.readElements(inputNode, object, section);
    }

    private void readVersion(InputNode inputNode, Object object, Schema schema) throws Exception {
        Label label = schema.getVersion();
        Class clazz = this.type.getType();
        if (label != null) {
            String string = label.getName();
            NodeMap<InputNode> nodeMap = inputNode.getAttributes();
            InputNode inputNode2 = nodeMap.remove(string);
            if (inputNode2 != null) {
                this.readVersion(inputNode2, object, label);
            } else {
                Version version = this.context.getVersion(clazz);
                Double d = this.revision.getDefault();
                Double d2 = version.revision();
                this.criteria.set(label, d);
                this.revision.compare(d2, d);
            }
        }
    }

    private void readVersion(InputNode inputNode, Object object, Label label) throws Exception {
        Object object2 = this.readInstance(inputNode, object, label);
        Class clazz = this.type.getType();
        if (object2 != null) {
            Version version = this.context.getVersion(clazz);
            Double d = version.revision();
            if (!object2.equals(this.revision)) {
                this.revision.compare(d, object2);
            }
        }
    }

    private void readAttributes(InputNode inputNode, Object object, Section section) throws Exception {
        NodeMap<InputNode> nodeMap = inputNode.getAttributes();
        LabelMap labelMap = section.getAttributes();
        for (String string : nodeMap) {
            InputNode inputNode2 = inputNode.getAttribute(string);
            if (inputNode2 == null) continue;
            this.readAttribute(inputNode2, object, section, labelMap);
        }
        this.validate(inputNode, labelMap, object);
    }

    private void readElements(InputNode inputNode, Object object, Section section) throws Exception {
        LabelMap labelMap = section.getElements();
        InputNode inputNode2 = inputNode.getNext();
        while (inputNode2 != null) {
            String string = inputNode2.getName();
            Section section2 = section.getSection(string);
            if (section2 != null) {
                this.readSection(inputNode2, object, section2);
            } else {
                this.readElement(inputNode2, object, section, labelMap);
            }
            inputNode2 = inputNode.getNext();
        }
        this.validate(inputNode, labelMap, object);
    }

    private void readText(InputNode inputNode, Object object, Section section) throws Exception {
        Label label = section.getText();
        if (label != null) {
            this.readInstance(inputNode, object, label);
        }
    }

    private void readAttribute(InputNode inputNode, Object object, Section section, LabelMap labelMap) throws Exception {
        String string = inputNode.getName();
        String string2 = section.getAttribute(string);
        Label label = labelMap.getLabel(string2);
        if (label == null) {
            Position position = inputNode.getPosition();
            Class clazz = this.context.getType(this.type, object);
            if (labelMap.isStrict(this.context) && this.revision.isEqual()) {
                throw new AttributeException("Attribute '%s' does not have a match in %s at %s", string2, clazz, position);
            }
        } else {
            this.readInstance(inputNode, object, label);
        }
    }

    private void readElement(InputNode inputNode, Object object, Section section, LabelMap labelMap) throws Exception {
        String string = inputNode.getName();
        String string2 = section.getPath(string);
        Label label = labelMap.getLabel(string2);
        if (label == null) {
            label = this.criteria.resolve(string2);
        }
        if (label == null) {
            Position position = inputNode.getPosition();
            Class clazz = this.context.getType(this.type, object);
            if (labelMap.isStrict(this.context) && this.revision.isEqual()) {
                throw new ElementException("Element '%s' does not have a match in %s at %s", string2, clazz, position);
            }
            inputNode.skip();
        } else {
            this.readUnion(inputNode, object, labelMap, label);
        }
    }

    private void readUnion(InputNode inputNode, Object object, LabelMap labelMap, Label label) throws Exception {
        String[] stringArray;
        Object object2 = this.readInstance(inputNode, object, label);
        for (String string : stringArray = label.getPaths()) {
            labelMap.getLabel(string);
        }
        if (label.isInline()) {
            this.criteria.set(label, object2);
        }
    }

    private Object readInstance(InputNode inputNode, Object object, Label label) throws Exception {
        Object object2 = this.readVariable(inputNode, object, label);
        if (object2 == null) {
            Position position = inputNode.getPosition();
            Class clazz = this.context.getType(this.type, object);
            if (label.isRequired() && this.revision.isEqual()) {
                throw new ValueRequiredException("Empty value for %s in %s at %s", label, clazz, position);
            }
        } else if (object2 != label.getEmpty(this.context)) {
            this.criteria.set(label, object2);
        }
        return object2;
    }

    private Object readVariable(InputNode inputNode, Object object, Label label) throws Exception {
        Converter converter = label.getConverter(this.context);
        if (label.isCollection()) {
            Object object2;
            Variable variable = this.criteria.get(label);
            Contact contact = label.getContact();
            if (variable != null) {
                Object object3 = variable.getValue();
                return converter.read(inputNode, object3);
            }
            if (object != null && (object2 = contact.get(object)) != null) {
                return converter.read(inputNode, object2);
            }
        }
        return converter.read(inputNode);
    }

    private void validate(InputNode inputNode, LabelMap labelMap, Object object) throws Exception {
        Class clazz = this.context.getType(this.type, object);
        Position position = inputNode.getPosition();
        for (Label label : labelMap) {
            if (label.isRequired() && this.revision.isEqual()) {
                throw new ValueRequiredException("Unable to satisfy %s for %s at %s", label, clazz, position);
            }
            Object object2 = label.getEmpty(this.context);
            if (object2 == null) continue;
            this.criteria.set(label, object2);
        }
    }

    @Override
    public boolean validate(InputNode inputNode) throws Exception {
        Instance instance = this.factory.getInstance(inputNode);
        if (!instance.isReference()) {
            Object object = instance.setInstance(null);
            Class clazz = instance.getType();
            return this.validate(inputNode, clazz);
        }
        return true;
    }

    private boolean validate(InputNode inputNode, Class clazz) throws Exception {
        Schema schema = this.context.getSchema(clazz);
        Section section = schema.getSection();
        this.validateText(inputNode, schema);
        this.validateSection(inputNode, section);
        return inputNode.isElement();
    }

    private void validateSection(InputNode inputNode, Section section) throws Exception {
        this.validateAttributes(inputNode, section);
        this.validateElements(inputNode, section);
    }

    private void validateAttributes(InputNode inputNode, Section section) throws Exception {
        NodeMap<InputNode> nodeMap = inputNode.getAttributes();
        LabelMap labelMap = section.getAttributes();
        for (String string : nodeMap) {
            InputNode inputNode2 = inputNode.getAttribute(string);
            if (inputNode2 == null) continue;
            this.validateAttribute(inputNode2, section, labelMap);
        }
        this.validate(inputNode, labelMap);
    }

    private void validateElements(InputNode inputNode, Section section) throws Exception {
        LabelMap labelMap = section.getElements();
        InputNode inputNode2 = inputNode.getNext();
        while (inputNode2 != null) {
            String string = inputNode2.getName();
            Section section2 = section.getSection(string);
            if (section2 != null) {
                this.validateSection(inputNode2, section2);
            } else {
                this.validateElement(inputNode2, section, labelMap);
            }
            inputNode2 = inputNode.getNext();
        }
        this.validate(inputNode, labelMap);
    }

    private void validateText(InputNode inputNode, Schema schema) throws Exception {
        Label label = schema.getText();
        if (label != null) {
            this.validate(inputNode, label);
        }
    }

    private void validateAttribute(InputNode inputNode, Section section, LabelMap labelMap) throws Exception {
        Position position = inputNode.getPosition();
        String string = inputNode.getName();
        String string2 = section.getAttribute(string);
        Label label = labelMap.getLabel(string2);
        if (label == null) {
            Class clazz = this.type.getType();
            if (labelMap.isStrict(this.context) && this.revision.isEqual()) {
                throw new AttributeException("Attribute '%s' does not exist for %s at %s", string2, clazz, position);
            }
        } else {
            this.validate(inputNode, label);
        }
    }

    private void validateElement(InputNode inputNode, Section section, LabelMap labelMap) throws Exception {
        String string = inputNode.getName();
        String string2 = section.getPath(string);
        Label label = labelMap.getLabel(string2);
        if (label == null) {
            label = this.criteria.resolve(string2);
        }
        if (label == null) {
            Position position = inputNode.getPosition();
            Class clazz = this.type.getType();
            if (labelMap.isStrict(this.context) && this.revision.isEqual()) {
                throw new ElementException("Element '%s' does not exist for %s at %s", string2, clazz, position);
            }
            inputNode.skip();
        } else {
            this.validateUnion(inputNode, labelMap, label);
        }
    }

    private void validateUnion(InputNode inputNode, LabelMap labelMap, Label label) throws Exception {
        String[] stringArray;
        for (String string : stringArray = label.getPaths()) {
            labelMap.getLabel(string);
        }
        if (label.isInline()) {
            this.criteria.set(label, null);
        }
        this.validate(inputNode, label);
    }

    private void validate(InputNode inputNode, Label label) throws Exception {
        Converter converter = label.getConverter(this.context);
        Position position = inputNode.getPosition();
        Class clazz = this.type.getType();
        boolean bl = converter.validate(inputNode);
        if (!bl) {
            throw new PersistenceException("Invalid value for %s in %s at %s", label, clazz, position);
        }
        this.criteria.set(label, null);
    }

    private void validate(InputNode inputNode, LabelMap labelMap) throws Exception {
        Position position = inputNode.getPosition();
        for (Label label : labelMap) {
            Class clazz = this.type.getType();
            if (!label.isRequired() || !this.revision.isEqual()) continue;
            throw new ValueRequiredException("Unable to satisfy %s for %s at %s", label, clazz, position);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(OutputNode outputNode, Object object) throws Exception {
        Class<?> clazz = object.getClass();
        Schema schema = this.context.getSchema(clazz);
        Caller caller = schema.getCaller();
        try {
            if (schema.isPrimitive()) {
                this.primitive.write(outputNode, object);
            } else {
                caller.persist(object);
                this.write(outputNode, object, schema);
            }
        }
        finally {
            caller.complete(object);
        }
    }

    private void write(OutputNode outputNode, Object object, Schema schema) throws Exception {
        Section section = schema.getSection();
        this.writeVersion(outputNode, object, schema);
        this.writeSection(outputNode, object, section);
    }

    private void writeSection(OutputNode outputNode, Object object, Section section) throws Exception {
        NamespaceMap namespaceMap = outputNode.getNamespaces();
        String string = section.getPrefix();
        if (string != null) {
            String string2 = namespaceMap.getReference(string);
            if (string2 == null) {
                throw new ElementException("Namespace prefix '%s' in %s is not in scope", string, this.type);
            }
            outputNode.setReference(string2);
        }
        this.writeAttributes(outputNode, object, section);
        this.writeElements(outputNode, object, section);
        this.writeText(outputNode, object, section);
    }

    private void writeVersion(OutputNode outputNode, Object object, Schema schema) throws Exception {
        Version version = schema.getRevision();
        Label label = schema.getVersion();
        if (version != null) {
            Double d = this.revision.getDefault();
            Double d2 = version.revision();
            if (this.revision.compare(d2, d)) {
                if (label.isRequired()) {
                    this.writeAttribute(outputNode, d2, label);
                }
            } else {
                this.writeAttribute(outputNode, d2, label);
            }
        }
    }

    private void writeAttributes(OutputNode outputNode, Object object, Section section) throws Exception {
        LabelMap labelMap = section.getAttributes();
        for (Label label : labelMap) {
            Contact contact = label.getContact();
            Object object2 = contact.get(object);
            Class clazz = this.context.getType(this.type, object);
            if (object2 == null) {
                object2 = label.getEmpty(this.context);
            }
            if (object2 == null && label.isRequired()) {
                throw new AttributeException("Value for %s is null in %s", label, clazz);
            }
            this.writeAttribute(outputNode, object2, label);
        }
    }

    private void writeElements(OutputNode outputNode, Object object, Section section) throws Exception {
        for (String string : section) {
            Object object2;
            Section section2 = section.getSection(string);
            if (section2 != null) {
                object2 = outputNode.getChild(string);
                this.writeSection((OutputNode)object2, object, section2);
                continue;
            }
            object2 = section.getPath(string);
            Label label = section.getElement((String)object2);
            Class clazz = this.context.getType(this.type, object);
            Variable variable = this.criteria.get(label);
            if (variable != null) continue;
            if (label == null) {
                throw new ElementException("Element '%s' not defined in %s", string, clazz);
            }
            this.writeUnion(outputNode, object, section, label);
        }
    }

    private void writeUnion(OutputNode outputNode, Object object, Section section, Label label) throws Exception {
        Contact contact = label.getContact();
        Object object2 = contact.get(object);
        Class clazz = this.context.getType(this.type, object);
        if (object2 == null && label.isRequired()) {
            throw new ElementException("Value for %s is null in %s", label, clazz);
        }
        Object object3 = this.writeReplace(object2);
        if (object3 != null) {
            this.writeElement(outputNode, object3, label);
        }
        this.criteria.set(label, object3);
    }

    private Object writeReplace(Object object) throws Exception {
        if (object != null) {
            Class<?> clazz = object.getClass();
            Caller caller = this.context.getCaller(clazz);
            return caller.replace(object);
        }
        return object;
    }

    private void writeText(OutputNode outputNode, Object object, Section section) throws Exception {
        Label label = section.getText();
        if (label != null) {
            Contact contact = label.getContact();
            Object object2 = contact.get(object);
            Class clazz = this.context.getType(this.type, object);
            if (object2 == null) {
                object2 = label.getEmpty(this.context);
            }
            if (object2 == null && label.isRequired()) {
                throw new TextException("Value for %s is null in %s", label, clazz);
            }
            this.writeText(outputNode, object2, label);
        }
    }

    private void writeAttribute(OutputNode outputNode, Object object, Label label) throws Exception {
        if (object != null) {
            Decorator decorator = label.getDecorator();
            String string = label.getName();
            String string2 = this.factory.getText(object);
            OutputNode outputNode2 = outputNode.setAttribute(string, string2);
            decorator.decorate(outputNode2);
        }
    }

    private void writeElement(OutputNode outputNode, Object object, Label label) throws Exception {
        if (object != null) {
            Class<?> clazz = object.getClass();
            Label label2 = label.getLabel(clazz);
            String string = label2.getName();
            Type type = label.getType(clazz);
            OutputNode outputNode2 = outputNode.getChild(string);
            if (!label2.isInline()) {
                this.writeNamespaces(outputNode2, type, label2);
            }
            if (label2.isInline() || !this.isOverridden(outputNode2, object, type)) {
                Converter converter = label2.getConverter(this.context);
                boolean bl = label2.isData();
                outputNode2.setData(bl);
                this.writeElement(outputNode2, object, converter);
            }
        }
    }

    private void writeElement(OutputNode outputNode, Object object, Converter converter) throws Exception {
        converter.write(outputNode, object);
    }

    private void writeNamespaces(OutputNode outputNode, Type type, Label label) throws Exception {
        Class clazz = type.getType();
        Decorator decorator = this.context.getDecorator(clazz);
        Decorator decorator2 = label.getDecorator();
        decorator2.decorate(outputNode, decorator);
    }

    private void writeText(OutputNode outputNode, Object object, Label label) throws Exception {
        if (object != null && !label.isTextList()) {
            String string = this.factory.getText(object);
            boolean bl = label.isData();
            outputNode.setData(bl);
            outputNode.setValue(string);
        }
    }

    private boolean isOverridden(OutputNode outputNode, Object object, Type type) throws Exception {
        return this.factory.setOverride(type, object, outputNode);
    }

    private class Injector
    extends Builder {
        private Injector(Composite composite2, Criteria criteria, Schema schema, Instance instance) {
            super(composite2, criteria, schema, instance);
        }

        @Override
        public Object read(InputNode inputNode) throws Exception {
            Section section = this.schema.getSection();
            this.composite.readVersion(inputNode, null, this.schema);
            this.composite.readText(inputNode, null, section);
            this.composite.readAttributes(inputNode, null, section);
            this.composite.readElements(inputNode, null, section);
            return this.readInject(inputNode);
        }

        private Object readInject(InputNode inputNode) throws Exception {
            Instantiator instantiator = this.schema.getInstantiator();
            Object object = instantiator.getInstance(this.criteria);
            this.value.setInstance(object);
            this.criteria.commit(object);
            return object;
        }
    }

    private static class Builder {
        protected final Composite composite;
        protected final Criteria criteria;
        protected final Schema schema;
        protected final Instance value;

        public Builder(Composite composite, Criteria criteria, Schema schema, Instance instance) {
            this.composite = composite;
            this.criteria = criteria;
            this.schema = schema;
            this.value = instance;
        }

        public Object read(InputNode inputNode) throws Exception {
            Object object = this.value.getInstance();
            Section section = this.schema.getSection();
            this.value.setInstance(object);
            this.composite.readVersion(inputNode, object, this.schema);
            this.composite.readText(inputNode, object, section);
            this.composite.readAttributes(inputNode, object, section);
            this.composite.readElements(inputNode, object, section);
            this.criteria.commit(object);
            return object;
        }
    }
}

