/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.xml.core;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.Collection;
import java.util.Map;
import org.simpleframework.xml.Attribute;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.ElementArray;
import org.simpleframework.xml.ElementList;
import org.simpleframework.xml.ElementMap;
import org.simpleframework.xml.core.AnnotationHandler;
import org.simpleframework.xml.core.Detail;
import org.simpleframework.xml.core.Support;
import org.simpleframework.xml.stream.Format;
import org.simpleframework.xml.stream.Verbosity;

class AnnotationFactory {
    private final Format format;
    private final boolean required;

    public AnnotationFactory(Detail detail, Support support) {
        this.required = detail.isRequired();
        this.format = support.getFormat();
    }

    public Annotation getInstance(Class clazz, Class[] classArray) throws Exception {
        ClassLoader classLoader = this.getClassLoader();
        if (Map.class.isAssignableFrom(clazz)) {
            if (this.isPrimitiveKey(classArray) && this.isAttribute()) {
                return this.getInstance(classLoader, ElementMap.class, true);
            }
            return this.getInstance(classLoader, ElementMap.class);
        }
        if (Collection.class.isAssignableFrom(clazz)) {
            return this.getInstance(classLoader, ElementList.class);
        }
        return this.getInstance(clazz);
    }

    private Annotation getInstance(Class clazz) throws Exception {
        ClassLoader classLoader = this.getClassLoader();
        Class<?> clazz2 = clazz.getComponentType();
        if (clazz.isArray()) {
            if (this.isPrimitive(clazz2)) {
                return this.getInstance(classLoader, Element.class);
            }
            return this.getInstance(classLoader, ElementArray.class);
        }
        if (this.isPrimitive(clazz) && this.isAttribute()) {
            return this.getInstance(classLoader, Attribute.class);
        }
        return this.getInstance(classLoader, Element.class);
    }

    private Annotation getInstance(ClassLoader classLoader, Class clazz) throws Exception {
        return this.getInstance(classLoader, clazz, false);
    }

    private Annotation getInstance(ClassLoader classLoader, Class clazz, boolean bl) throws Exception {
        AnnotationHandler annotationHandler = new AnnotationHandler(clazz, this.required, bl);
        Class[] classArray = new Class[]{clazz};
        return (Annotation)Proxy.newProxyInstance(classLoader, classArray, (InvocationHandler)annotationHandler);
    }

    private ClassLoader getClassLoader() throws Exception {
        return AnnotationFactory.class.getClassLoader();
    }

    private boolean isPrimitiveKey(Class[] classArray) {
        if (classArray != null && classArray.length > 0) {
            Class clazz = classArray[0].getSuperclass();
            Class clazz2 = classArray[0];
            if (clazz != null) {
                if (clazz.isEnum()) {
                    return true;
                }
                if (clazz2.isEnum()) {
                    return true;
                }
            }
            return this.isPrimitive(clazz2);
        }
        return false;
    }

    private boolean isPrimitive(Class clazz) {
        if (Number.class.isAssignableFrom(clazz)) {
            return true;
        }
        if (clazz == Boolean.class) {
            return true;
        }
        if (clazz == Character.class) {
            return true;
        }
        return clazz.isPrimitive();
    }

    private boolean isAttribute() {
        Verbosity verbosity = this.format.getVerbosity();
        if (verbosity != null) {
            return verbosity == Verbosity.LOW;
        }
        return false;
    }
}

