/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.xml.convert;

import java.lang.reflect.Constructor;
import org.simpleframework.xml.convert.Convert;
import org.simpleframework.xml.convert.ConvertException;
import org.simpleframework.xml.convert.Converter;
import org.simpleframework.xml.util.Cache;
import org.simpleframework.xml.util.ConcurrentCache;

class ConverterFactory {
    private final Cache<Converter> cache = new ConcurrentCache<Converter>();

    public Converter getInstance(Class clazz) throws Exception {
        Converter converter = this.cache.fetch(clazz);
        if (converter == null) {
            return this.getConverter(clazz);
        }
        return converter;
    }

    public Converter getInstance(Convert convert) throws Exception {
        Class<? extends Converter> clazz = convert.value();
        if (clazz.isInterface()) {
            throw new ConvertException("Can not instantiate %s", clazz);
        }
        return this.getInstance(clazz);
    }

    private Converter getConverter(Class clazz) throws Exception {
        Constructor constructor = this.getConstructor(clazz);
        if (constructor == null) {
            throw new ConvertException("No default constructor for %s", clazz);
        }
        return this.getConverter(clazz, constructor);
    }

    private Converter getConverter(Class clazz, Constructor constructor) throws Exception {
        Converter converter = (Converter)constructor.newInstance(new Object[0]);
        if (converter != null) {
            this.cache.cache(clazz, converter);
        }
        return converter;
    }

    private Constructor getConstructor(Class clazz) throws Exception {
        Constructor constructor = clazz.getDeclaredConstructor(new Class[0]);
        if (!constructor.isAccessible()) {
            constructor.setAccessible(true);
        }
        return constructor;
    }
}

