/*
 * Decompiled with CFR 0.152.
 */
package com.ecs.rdlibrary;

import android.app.Activity;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.os.Bundle;
import android.util.Log;
import com.ecs.rdlibrary.response.DeviceDescription;
import com.ecs.rdlibrary.response.DeviceInfo;
import com.ecs.rdlibrary.response.RDService;
import com.google.gson.Gson;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.simpleframework.xml.core.Persister;

public class ECSBioInfoActivity
extends Activity {
    private HashMap<Integer, DeviceDescription> deviceInfos = new HashMap();
    private static int DEVICE_INFO_REQUEST_CODE = 100;
    private static int RESULT_ERROR = -999;
    private AtomicInteger numRequests = new AtomicInteger(0);
    private boolean log = false;

    protected void onCreate(Bundle bundle) {
        super.onCreate(bundle);
        Bundle bundle2 = this.getIntent().getExtras();
        if (bundle2 != null && bundle2.containsKey("LOG")) {
            this.log = bundle2.getBoolean("LOG");
        }
        this.GetDeviceInfos();
    }

    private void GetDeviceInfos() {
        int n = this.getDeviceInfos("in.gov.uidai.rdservice.fp.INFO", "FMR");
        int n2 = this.getDeviceInfos("in.gov.uidai.rdservice.iris.INFO", "IIR");
        if (this.log) {
            Log.e((String)"***DBG***", (String)("Number of Requests: " + this.numRequests.get()));
        }
        if (n == 0 && n2 == 0) {
            this.returnErrorMessage("No Fingerprint or Iris RD Services installed on this device");
            return;
        }
    }

    private int getDeviceInfos(String string, String string2) {
        Intent intent = new Intent(string);
        PackageManager packageManager = this.getPackageManager();
        List list = packageManager.queryIntentActivities(intent, 65536);
        for (ResolveInfo resolveInfo : list) {
            Intent intent2 = new Intent(string);
            intent2.setPackage(resolveInfo.activityInfo.packageName);
            Integer n = this.numRequests.incrementAndGet();
            DeviceDescription deviceDescription = new DeviceDescription();
            deviceDescription.setDeviceType(string2);
            deviceDescription.setPackageName(resolveInfo.activityInfo.packageName);
            this.deviceInfos.put(n, deviceDescription);
            if (this.log) {
                Log.e((String)"***DBG***", (String)("Calling getDeviceInfo on package " + resolveInfo.activityInfo.packageName));
            }
            this.startActivityForResult(intent2, DEVICE_INFO_REQUEST_CODE + n);
        }
        return list.size();
    }

    protected void onActivityResult(int n, int n2, Intent intent) {
        if (this.log) {
            Log.e((String)"***DBG***", (String)("OnActivityResult - requestCode: " + n + ", resultCode: " + n2));
        }
        super.onActivityResult(n, n2, intent);
        Integer n3 = n - DEVICE_INFO_REQUEST_CODE;
        if (n2 != -1) {
            Integer n4 = this.numRequests.decrementAndGet();
            if (this.log) {
                Log.e((String)"***DBG***", (String)("Number of Requests pending: " + this.numRequests.get()));
            }
            if (n4 == 0) {
                this.ProcessDeviceInfoCompletion();
                return;
            }
            return;
        }
        try {
            Object object;
            RDService rDService;
            String string = intent.getStringExtra("RD_SERVICE_INFO");
            if (string == null) {
                if (this.log) {
                    Log.e((String)"***DBG***", (String)"OnActivityResult - serviceInfoXML is NULL");
                }
                Integer n5 = this.numRequests.decrementAndGet();
                if (this.log) {
                    Log.e((String)"***DBG***", (String)("Number of Requests pending: " + this.numRequests.get()));
                }
                if (n5 == 0) {
                    this.ProcessDeviceInfoCompletion();
                    return;
                }
                return;
            }
            if (this.log) {
                Log.e((String)"***DBG***", (String)("OnActivityResult - serviceInfoXML: " + string));
            }
            if ((rDService = (RDService)this.parseXML(RDService.class, string)).getStatus().equals("READY") && (object = intent.getStringExtra("DEVICE_INFO")) != null) {
                if (this.log) {
                    Log.e((String)"***DBG***", (String)("OnActivityResult - deviceInfoXML: " + (String)object));
                }
                DeviceInfo deviceInfo = (DeviceInfo)this.parseXML(DeviceInfo.class, (String)object);
                this.deviceInfos.get(n3).setName(deviceInfo.getDpId() + " - " + deviceInfo.getMi());
                if (this.log) {
                    Log.e((String)"***DBG***", (String)"OnActivityResult - deviceInfo added");
                }
            }
            object = this.numRequests.decrementAndGet();
            if (this.log) {
                Log.e((String)"***DBG***", (String)("Number of Requests pending: " + this.numRequests.get()));
            }
            if ((Integer)object == 0) {
                this.ProcessDeviceInfoCompletion();
                return;
            }
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            Integer n6 = this.numRequests.decrementAndGet();
            if (this.log) {
                Log.e((String)"***DBG***", (String)("Number of Requests pending: " + this.numRequests.get()));
            }
            if (n6 == 0) {
                this.ProcessDeviceInfoCompletion();
                return;
            }
            return;
        }
    }

    private void ProcessDeviceInfoCompletion() {
        DeviceDescription deviceDescription2;
        if (this.log) {
            Log.e((String)"***DBG***", (String)("Processing ProcessDeviceInfoCompletion - Num DeviceInfos = " + this.deviceInfos.values().size()));
        }
        ArrayList<DeviceDescription> arrayList = new ArrayList<DeviceDescription>();
        for (DeviceDescription deviceDescription2 : this.deviceInfos.values()) {
            if (this.log) {
                Log.e((String)"***DBG***", (String)("Processing ProcessDeviceInfoCompletion - " + deviceDescription2.getPackageName()));
            }
            if (deviceDescription2.getName() == null) {
                if (!this.log) continue;
                Log.e((String)"***DBG***", (String)("Processing ProcessDeviceInfoCompletion - " + deviceDescription2.getPackageName() + " - DeviceInfo is NULL"));
                continue;
            }
            arrayList.add(deviceDescription2);
        }
        if (this.log) {
            Log.e((String)"***DBG***", (String)"ProcessDeviceInfoCompletion - Serializing DeviceInfos");
        }
        try {
            if (this.log) {
                Log.e((String)"***DBG***", (String)("ProcessDeviceInfoCompletion - DeviceInfos is " + new Gson().toJson(arrayList)));
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        Intent intent = new Intent();
        deviceDescription2 = new Bundle();
        deviceDescription2.putString("DEVICE_INFOS", new Gson().toJson(arrayList));
        intent.putExtras((Bundle)deviceDescription2);
        this.setResult(-1, intent);
        this.finish();
        if (this.log) {
            Log.e((String)"***DBG***", (String)"ProcessDeviceInfoCompletion - DeviceInfos sent to calling app");
        }
    }

    private void returnErrorMessage(String string) {
        Intent intent = new Intent();
        Bundle bundle = new Bundle();
        bundle.putString("ERROR_MESSAGE", string);
        intent.putExtras(bundle);
        this.setResult(RESULT_ERROR, intent);
        this.finish();
    }

    private Object parseXML(Class clazz, String string) throws Exception {
        Persister persister = new Persister();
        StringReader stringReader = new StringReader(string);
        Class clazz2 = persister.read(clazz, (Reader)stringReader, false);
        return clazz2;
    }
}

