/*
 * Decompiled with CFR 0.152.
 */
package com.ecs.rdlibrary;

import android.app.Activity;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.util.Base64;
import android.util.Log;
import com.ecs.rdlibrary.request.CustOpts;
import com.ecs.rdlibrary.request.Demo;
import com.ecs.rdlibrary.request.Opts;
import com.ecs.rdlibrary.request.Param;
import com.ecs.rdlibrary.request.PidOptions;
import com.ecs.rdlibrary.response.PidData;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.simpleframework.xml.core.Persister;
import org.simpleframework.xml.stream.Format;
import org.simpleframework.xml.stream.Verbosity;

public class ECSBioCaptureActivity
extends Activity {
    private String operation = "K";
    private String deviceType = "F";
    private String bCount = "1";
    private String bType = "0";
    private String format = "0";
    private String pidVer = "2.0";
    private String timeOut = "10000";
    private String posh = "UNKNOWN";
    private String uidaiEnvironment = "P";
    private String otp = null;
    private String demoXml = null;
    private String kycVer = "2.5";
    private boolean lr = true;
    private boolean de = true;
    private boolean pfr = true;
    private List<Param> custOpts = null;
    private boolean isfaceAuth = false;
    private String txnId = null;
    private String language = null;
    private String packageName = null;
    private String wadh = null;
    private static int DEVICE_CAPTURE_REQUEST_CODE = 1;
    private static int FACE_CAPTURE_REQUEST_CODE = 3;
    private static int RESULT_ERROR = -999;

    protected void onCreate(Bundle bundle) {
        super.onCreate(bundle);
        Bundle bundle2 = this.getIntent().getExtras();
        if (bundle2 != null) {
            if (bundle2.containsKey("OPERATION")) {
                this.operation = (String)((Object)bundle2.getSerializable("OPERATION"));
            }
            if (bundle2.containsKey("DEVICETYPE")) {
                this.deviceType = (String)((Object)bundle2.getSerializable("DEVICETYPE"));
                this.isfaceAuth = this.deviceType.equals("FACE");
            }
            if (bundle2.containsKey("BCOUNT")) {
                this.bCount = (String)((Object)bundle2.getSerializable("BCOUNT"));
            }
            if (bundle2.containsKey("BTYPE")) {
                this.bType = (String)((Object)bundle2.getSerializable("BTYPE"));
            }
            if (bundle2.containsKey("FORMAT")) {
                this.format = (String)((Object)bundle2.getSerializable("FORMAT"));
            }
            if (bundle2.containsKey("PIDVER")) {
                this.pidVer = (String)((Object)bundle2.getSerializable("PIDVER"));
            }
            if (bundle2.containsKey("KYCVER")) {
                this.kycVer = (String)((Object)bundle2.getSerializable("KYCVER"));
            }
            if (bundle2.containsKey("TIMEOUT")) {
                this.timeOut = (String)((Object)bundle2.getSerializable("TIMEOUT"));
            }
            if (bundle2.containsKey("POSH")) {
                this.posh = (String)((Object)bundle2.getSerializable("POSH"));
            }
            if (bundle2.containsKey("UIDAIENVIRONMENT")) {
                this.uidaiEnvironment = (String)((Object)bundle2.getSerializable("UIDAIENVIRONMENT"));
            }
            if (bundle2.containsKey("OTP")) {
                this.otp = (String)((Object)bundle2.getSerializable("OTP"));
            }
            if (bundle2.containsKey("DEMOXML")) {
                this.demoXml = (String)((Object)bundle2.getSerializable("DEMOXML"));
            }
            if (bundle2.containsKey("LR")) {
                this.lr = (Boolean)bundle2.getSerializable("LR");
            }
            if (bundle2.containsKey("DE")) {
                this.de = (Boolean)bundle2.getSerializable("DE");
            }
            if (bundle2.containsKey("PFR")) {
                this.pfr = (Boolean)bundle2.getSerializable("PFR");
            }
            if (bundle2.containsKey("CUSTPOTS")) {
                this.custOpts = (List)((Object)bundle2.getSerializable("CUSTPOTS"));
            }
            this.language = bundle2.containsKey("LANGUAGE") ? (String)((Object)bundle2.getSerializable("LANGUAGE")) : "en";
            if (bundle2.containsKey("PACKAGE_NAME")) {
                this.packageName = bundle2.getString("PACKAGE_NAME");
            }
            if (bundle2.containsKey("WADH")) {
                this.wadh = bundle2.getString("WADH");
            }
        }
        new Thread(){

            @Override
            public void run() {
                ECSBioCaptureActivity.this.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        if (ECSBioCaptureActivity.this.isfaceAuth) {
                            ECSBioCaptureActivity.this.startCaptureFace();
                        } else {
                            ECSBioCaptureActivity.this.startCapture();
                        }
                    }
                });
            }
        }.start();
    }

    private void startCapture() {
        boolean bl;
        String string = "in.gov.uidai.rdservice.fp.CAPTURE";
        boolean bl2 = false;
        boolean bl3 = false;
        String string2 = "Fingerprint";
        Opts opts = new Opts();
        if (this.deviceType.equals("F")) {
            opts.setfCount(this.bCount);
            opts.setfType(this.bType);
            bl2 = false;
            string2 = "Fingerprint";
            string = "in.gov.uidai.rdservice.fp.CAPTURE";
        } else if (this.deviceType.equals("I")) {
            opts.setiCount(this.bCount);
            opts.setiType(this.bType);
            bl2 = true;
            string2 = "Iris";
            string = "in.gov.uidai.rdservice.iris.CAPTURE";
        } else {
            this.returnErrorMessage("Invalid Device Type specified. Supported values are I for Iris or F for Fingerprint or FACE for Face Authentication");
            return;
        }
        Intent intent = new Intent(string);
        PackageManager packageManager = this.getPackageManager();
        List list = packageManager.queryIntentActivities(intent, 65536);
        boolean bl4 = bl = list.size() > 0;
        if (!bl) {
            this.returnErrorMessage(string2 + " Support not available. Please install and configure RD Services for your device from google playstore");
            return;
        }
        opts.setFormat(this.format);
        opts.setPidVer(this.pidVer);
        opts.setTimeout(this.timeOut);
        opts.setPosh(this.posh);
        opts.setEnv(this.uidaiEnvironment);
        if (this.otp != null) {
            opts.setOtp(this.otp);
        }
        if (this.operation.equals("K")) {
            if (this.wadh == null) {
                try {
                    this.wadh = Base64.encodeToString((byte[])this.getKycWadh(this.kycVer, !bl2, bl2, this.otp != null, false, true, this.lr, this.de, this.pfr), (int)2);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            opts.setWadh(this.wadh);
        }
        CustOpts custOpts = new CustOpts();
        custOpts.setParams(new ArrayList<Param>());
        if (this.custOpts != null) {
            for (Param object2 : this.custOpts) {
                custOpts.getParams().add(object2);
            }
        }
        Object object3 = null;
        if (this.demoXml != null && !this.demoXml.isEmpty()) {
            try {
                object3 = (Demo)this.parseXML(Demo.class, this.demoXml);
            }
            catch (Exception exception) {
                this.returnErrorMessage("Invalid Demographic XML specified");
                return;
            }
        }
        PidOptions pidOptions = new PidOptions();
        pidOptions.setVer("1.0");
        pidOptions.setOpts(opts);
        pidOptions.setCustOpts(custOpts);
        pidOptions.setDemo(new Demo());
        String string3 = "";
        try {
            string3 = this.getXMLNoFormatting(pidOptions);
        }
        catch (Exception exception) {
            this.returnErrorMessage(exception.getMessage());
            return;
        }
        string3 = string3.replace("<CustOpts/>", "<CustOpts></CustOpts>");
        string3 = string3.replace("<Demo/>", "<Demo></Demo>");
        intent.putExtra("PID_OPTIONS", string3);
        if (this.packageName != null) {
            intent.setPackage(this.packageName);
        }
        this.startActivityForResult(intent, DEVICE_CAPTURE_REQUEST_CODE);
    }

    private void startCaptureFace() {
        Object object;
        Object object3;
        String string = "in.gov.uidai.rdservice.face.CAPTURE";
        if (this.custOpts == null) {
            this.custOpts = new ArrayList<Param>();
        }
        boolean bl = false;
        if (this.custOpts != null) {
            for (Param object42 : this.custOpts) {
                if (!object42.getName().equals("txnId")) continue;
                this.txnId = object42.getValue();
                bl = true;
                break;
            }
        }
        if (!bl) {
            this.txnId = UUID.randomUUID().toString();
            object3 = new Param();
            ((Param)object3).setName("txnId");
            ((Param)object3).setValue(this.txnId);
            this.custOpts.add((Param)object3);
        }
        object3 = new Param();
        ((Param)object3).setName("language");
        ((Param)object3).setValue(this.language);
        this.custOpts.add((Param)object3);
        Opts opts = new Opts();
        Intent intent = new Intent(string);
        opts.setFormat(this.format);
        opts.setPidVer(this.pidVer);
        opts.setTimeout(this.timeOut);
        opts.setPosh(this.posh);
        opts.setpCount("1");
        if (this.otp != null) {
            opts.setOtp(this.otp);
        }
        if (this.operation.equals("K")) {
            object = null;
            try {
                object = Base64.encodeToString((byte[])this.getKycWadh(this.kycVer, false, false, this.otp != null, true, true, this.lr, this.de, this.pfr), (int)2);
            }
            catch (Exception object6) {
                object6.printStackTrace();
            }
            opts.setWadh((String)object);
        }
        object = new CustOpts();
        ((CustOpts)object).setParams(new ArrayList<Param>());
        if (this.custOpts != null) {
            for (Param exception : this.custOpts) {
                ((CustOpts)object).getParams().add(exception);
            }
        }
        Object object2 = null;
        if (this.demoXml != null && !this.demoXml.isEmpty()) {
            try {
                object2 = (Demo)this.parseXML(Demo.class, this.demoXml);
            }
            catch (Exception exception) {
                this.returnErrorMessage("Invalid Demographic XML specified");
                return;
            }
        }
        PidOptions pidOptions = new PidOptions();
        pidOptions.setVer("1.0");
        pidOptions.setEnv(this.uidaiEnvironment);
        pidOptions.setOpts(opts);
        pidOptions.setCustOpts((CustOpts)object);
        pidOptions.setDemo(new Demo());
        String string2 = "";
        try {
            string2 = this.getXMLNoFormatting(pidOptions);
        }
        catch (Exception exception) {
            this.returnErrorMessage(exception.getMessage());
            return;
        }
        string2 = string2.replace("<CustOpts/>", "<CustOpts></CustOpts>");
        string2 = string2.replace("<Demo/>", "<Demo></Demo>");
        intent.putExtra("request", string2);
        this.startActivityForResult(intent, FACE_CAPTURE_REQUEST_CODE);
    }

    protected void onActivityResult(int n, int n2, Intent intent) {
        super.onActivityResult(n, n2, intent);
        if (n2 != -1) {
            this.returnErrorMessage("RD Service Error. Code : " + n2);
            return;
        }
        try {
            if (n == DEVICE_CAPTURE_REQUEST_CODE) {
                String string = intent.getStringExtra("PID_DATA");
                if (string == null) {
                    this.returnErrorMessage("Unable to capture fingerprint. pidData is Null");
                    return;
                }
                Log.e((String)"***DBG***", (String)string);
                PidData pidData = (PidData)this.parseXML(PidData.class, string);
                if (pidData.getResp() == null) {
                    this.returnErrorMessage("Capture fingerprint failed. Resp is NULL");
                    return;
                }
                if (!pidData.getResp().getErrCode().equals("0")) {
                    this.returnErrorMessage("Capture fingerprint failed. Reason: " + pidData.getResp().getErrInfo());
                    return;
                }
                Intent intent2 = new Intent();
                Bundle bundle = new Bundle();
                bundle.putString("PID_DATA", string);
                intent2.putExtras(bundle);
                this.setResult(-1, intent2);
                this.finish();
                return;
            }
            if (n == FACE_CAPTURE_REQUEST_CODE) {
                String string = intent.getStringExtra("response");
                if (string == null) {
                    this.returnErrorMessage("Unable to capture face. pidOption is Null");
                    return;
                }
                PidData pidData = (PidData)this.parseXML(PidData.class, string);
                if (pidData.getResp() == null) {
                    this.returnErrorMessage("Capture Face failed. Resp is NULL");
                    return;
                }
                if (!pidData.getResp().getErrCode().equals("0")) {
                    this.returnErrorMessage("Capture face failed. Reason: " + pidData.getResp().getErrInfo());
                    return;
                }
                if (pidData.getCustOpts() != null && pidData.getCustOpts().getParams() != null) {
                    for (Param object2 : pidData.getCustOpts().getParams()) {
                        if (!object2.getName().equals("txnStatus") || object2.getValue().equals("PID_CREATED")) continue;
                        this.returnErrorMessage("Capture face failed. Reason: PID_NOT_CREATED");
                        return;
                    }
                }
                Intent intent3 = new Intent();
                Bundle bundle = new Bundle();
                bundle.putString("PID_DATA", string);
                intent3.putExtras(bundle);
                this.setResult(-1, intent3);
                this.finish();
                return;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.returnErrorMessage(exception.getMessage());
            return;
        }
    }

    private void returnErrorMessage(String string) {
        Intent intent = new Intent();
        Bundle bundle = new Bundle();
        bundle.putString("ERROR_MESSAGE", string);
        intent.putExtras(bundle);
        this.setResult(RESULT_ERROR, intent);
        this.finish();
    }

    private String getXMLNoFormatting(Object object) throws Exception {
        StringWriter stringWriter = new StringWriter();
        Format format = new Format(0, Verbosity.LOW);
        Persister persister = new Persister(format);
        try {
            persister.write(object, stringWriter);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw exception;
        }
        return stringWriter.toString();
    }

    private Object parseXML(Class clazz, String string) throws Exception {
        Persister persister = new Persister();
        StringReader stringReader = new StringReader(string);
        Class clazz2 = persister.read(clazz, (Reader)stringReader, false);
        return clazz2;
    }

    private byte[] getKycWadh(String string, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7, boolean bl8) throws Exception {
        String string2 = "";
        if (bl) {
            string2 = string2 + "F";
        }
        if (bl2) {
            string2 = string2 + "I";
        }
        if (bl3) {
            string2 = string2 + "O";
        }
        if (bl4) {
            string2 = string2 + "P";
        }
        if (string2.isEmpty()) {
            throw new Exception("Invalid value for Ra for generating Wadh");
        }
        if (!bl5) {
            throw new Exception("Invalid Resident consent");
        }
        String string3 = string + string2 + (bl5 ? "Y" : "N") + (bl6 ? "Y" : "N") + (bl7 ? "Y" : "N") + (bl8 ? "Y" : "N");
        byte[] byArray = null;
        MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
        messageDigest.reset();
        byArray = messageDigest.digest(string3.getBytes());
        return byArray;
    }
}

