/*
 * Decompiled with CFR 0.152.
 */
package com.ecs.dbsekycapi;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import android.util.Base64;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.activity.result.ActivityResultLauncher;
import androidx.activity.result.contract.ActivityResultContract;
import androidx.activity.result.contract.ActivityResultContracts;
import androidx.appcompat.app.AppCompatActivity;
import androidx.cardview.widget.CardView;
import com.ecs.cdslutils.DialogUtils;
import com.ecs.cdslutils.ErrorHandler;
import com.ecs.cdslutils.Globals;
import com.ecs.cdslutils.ProgressUtil;
import com.ecs.cdslutils.ResponseHandler;
import com.ecs.cdslutils.ServerUtil;
import com.ecs.cdslxsds.ECSRDKycRequest;
import com.ecs.cdslxsds.ECSRDKycResponse;
import com.ecs.cdslxsds.ESignLibApiParams;
import com.ecs.dbsekycapi.R;
import com.ecs.rdlibrary.ECSBioCaptureActivity;
import java.nio.charset.StandardCharsets;

public class DBSFingerprintCaptureActivity
extends AppCompatActivity {
    private TextView authDesc;
    private ImageView authImg;
    private ActivityResultLauncher<Intent> bioCaptureLauncher;
    private ActivityResultLauncher<Intent> faceCaptureLauncher;
    private ActivityResultLauncher<Intent> irisCaptureLauncher;
    private String authMode;
    CardView btnCapture;
    private ResponseHandler responseHandler;
    private String consent;
    private String aadhaarNo;
    private String aspTxn;
    private ESignLibApiParams apiParams;

    private void viewInitialize() {
        DBSFingerprintCaptureActivity dBSFingerprintCaptureActivity = this;
        dBSFingerprintCaptureActivity.authDesc = (TextView)dBSFingerprintCaptureActivity.findViewById(R.id.authDesc);
        dBSFingerprintCaptureActivity.authImg = (ImageView)dBSFingerprintCaptureActivity.findViewById(R.id.authImage);
        dBSFingerprintCaptureActivity.btnCapture = (CardView)dBSFingerprintCaptureActivity.findViewById(R.id.btnCapture);
    }

    private void onClickListener() {
        DBSFingerprintCaptureActivity dBSFingerprintCaptureActivity = this;
        dBSFingerprintCaptureActivity.findViewById(R.id.back).setOnClickListener(object -> {
            ErrorHandler errorHandler;
            object = errorHandler;
            DBSFingerprintCaptureActivity dBSFingerprintCaptureActivity = object2;
            object();
            Object object2 = dBSFingerprintCaptureActivity.aspTxn;
            object = dBSFingerprintCaptureActivity.getString(R.string.user_Cancel);
            errorHandler.returnError((Activity)dBSFingerprintCaptureActivity, (String)object2, "E998", (String)object);
        });
        dBSFingerprintCaptureActivity.btnCapture.setOnClickListener(view -> this.captureFingerprint());
    }

    private void updateAuthIcon() {
        if (this.authMode.equals("3")) {
            DBSFingerprintCaptureActivity dBSFingerprintCaptureActivity = this;
            dBSFingerprintCaptureActivity.authDesc.setText((CharSequence)this.getString(R.string.iris_auth));
            dBSFingerprintCaptureActivity.authImg.setImageResource(R.drawable.eye_scanner);
        } else if (this.authMode.equals("4")) {
            DBSFingerprintCaptureActivity dBSFingerprintCaptureActivity = this;
            dBSFingerprintCaptureActivity.authDesc.setText((CharSequence)this.getString(R.string.face_auth));
            dBSFingerprintCaptureActivity.authImg.setImageResource(R.drawable.face_scanner);
        } else {
            DBSFingerprintCaptureActivity dBSFingerprintCaptureActivity = this;
            dBSFingerprintCaptureActivity.authDesc.setText((CharSequence)this.getString(R.string.bio_auth));
            dBSFingerprintCaptureActivity.authImg.setImageResource(R.drawable.biometric);
        }
    }

    private void receiveBundle() {
        Bundle bundle = this.getIntent().getExtras();
        if (bundle != null) {
            if (bundle.containsKey("ASP_TXN")) {
                this.aspTxn = bundle.getString("ASP_TXN");
            }
            if (bundle.containsKey("AUTH_MODE")) {
                this.authMode = bundle.getString("AUTH_MODE");
            }
            if (bundle.containsKey("AADHAAR_NUMBER")) {
                this.aadhaarNo = (String)((Object)bundle.getSerializable("AADHAAR_NUMBER"));
            }
            if (bundle.containsKey("API_PARAMS")) {
                this.apiParams = (ESignLibApiParams)bundle.getSerializable("API_PARAMS");
            }
            if (bundle.containsKey("CONSENT")) {
                this.consent = bundle.getString("CONSENT");
            }
        }
    }

    private void sendRequestToCapture(String string2, String string3, String string4) {
        Intent intent;
        Intent intent2 = intent;
        new Intent((Context)this, ECSBioCaptureActivity.class).putExtra("OPERATION", "K");
        intent2.putExtra("DEVICETYPE", string3);
        intent2.putExtra("UIDAIENVIRONMENT", string4);
        intent2.putExtra("DE", false);
        intent2.putExtra("LR", false);
        intent2.putExtra("PFR", false);
        if (string2.equals("BIO")) {
            intent2.putExtra("BTYPE", "2");
            this.bioCaptureLauncher.launch((Object)intent2);
        }
        if (string2.equals("IRIS")) {
            intent2.putExtra("BCOUNT", "1");
            this.irisCaptureLauncher.launch((Object)intent2);
        }
        if (string2.equals("FACE")) {
            Intent intent3 = intent2;
            intent3.putExtra("PCOUNT", "1");
            intent3.putExtra("BTYPE", "1");
            this.faceCaptureLauncher.launch((Object)intent2);
        }
    }

    private void registerLauncher() {
        ActivityResultContracts.StartActivityForResult startActivityForResult;
        ActivityResultContracts.StartActivityForResult startActivityForResult2;
        ActivityResultContracts.StartActivityForResult startActivityForResult3;
        DBSFingerprintCaptureActivity dBSFingerprintCaptureActivity = dBSFingerprintCaptureActivity2;
        DBSFingerprintCaptureActivity dBSFingerprintCaptureActivity2 = startActivityForResult3;
        startActivityForResult3 = new ActivityResultContracts.StartActivityForResult();
        dBSFingerprintCaptureActivity.bioCaptureLauncher = dBSFingerprintCaptureActivity.registerForActivityResult((ActivityResultContract)dBSFingerprintCaptureActivity2, activityResult -> this.handlePidData(activityResult.getData(), "FMR,FIR"));
        dBSFingerprintCaptureActivity2 = startActivityForResult2;
        startActivityForResult2 = new ActivityResultContracts.StartActivityForResult();
        dBSFingerprintCaptureActivity.faceCaptureLauncher = dBSFingerprintCaptureActivity.registerForActivityResult((ActivityResultContract)dBSFingerprintCaptureActivity2, activityResult -> this.handlePidData(activityResult.getData(), "FID"));
        dBSFingerprintCaptureActivity2 = startActivityForResult;
        startActivityForResult = new ActivityResultContracts.StartActivityForResult();
        dBSFingerprintCaptureActivity.irisCaptureLauncher = dBSFingerprintCaptureActivity.registerForActivityResult((ActivityResultContract)dBSFingerprintCaptureActivity2, activityResult -> this.handlePidData(activityResult.getData(), "IIR"));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void handlePidData(Intent intent, String string2) {
        if (intent == null) {
            DBSFingerprintCaptureActivity dBSFingerprintCaptureActivity = this;
            DialogUtils.showErrorDialog((Context)dBSFingerprintCaptureActivity, dBSFingerprintCaptureActivity.getString(R.string.uable_to_get_piddata));
            return;
        }
        try {
            String string3 = intent.getStringExtra("PID_DATA");
            if (string3 == null) {
                DialogUtils.showErrorDialog((Context)this, intent.getStringExtra("ERROR_MESSAGE"));
                return;
            }
            this.validateRequest(string3.replace("/ >", "/>"), string2);
            return;
        }
        catch (Exception exception) {
            DialogUtils.showErrorDialog((Context)this, "PID-" + exception.getMessage());
            return;
        }
    }

    private void returnSuccessResponse(ECSRDKycResponse eCSRDKycResponse) {
        DBSFingerprintCaptureActivity dBSFingerprintCaptureActivity = this;
        dBSFingerprintCaptureActivity.runOnUiThread(() -> {
            Intent intent;
            DBSFingerprintCaptureActivity dBSFingerprintCaptureActivity = object;
            ProgressUtil.getInstance().destroyProgressDialog();
            Object object = dBSFingerprintCaptureActivity.decodeBase64(eCSRDKycResponse.getESIGN_XML());
            Intent intent2 = intent;
            intent = new Intent();
            Bundle bundle = new Bundle();
            bundle.putString("ESIGN_RESPONSE_XML", (String)object);
            bundle.putBoolean("ERROR", eCSRDKycResponse.isError());
            intent.putExtras(bundle);
            dBSFingerprintCaptureActivity.setResult(-1, intent2);
            dBSFingerprintCaptureActivity.finish();
        });
    }

    public void onCreate(Bundle bundle) {
        DBSFingerprintCaptureActivity dBSFingerprintCaptureActivity = this;
        super.onCreate(bundle);
        dBSFingerprintCaptureActivity.setContentView(R.layout.activity_fingerprint_capture_dbs);
        dBSFingerprintCaptureActivity.btnCapture = (CardView)dBSFingerprintCaptureActivity.findViewById(R.id.btnCapture);
        dBSFingerprintCaptureActivity.responseHandler = new ResponseHandler();
        dBSFingerprintCaptureActivity.receiveBundle();
        dBSFingerprintCaptureActivity.viewInitialize();
        dBSFingerprintCaptureActivity.updateAuthIcon();
        dBSFingerprintCaptureActivity.onClickListener();
        dBSFingerprintCaptureActivity.registerLauncher();
    }

    public void captureFingerprint() {
        String string2 = this.apiParams.getEnvironment().equalsIgnoreCase("prod") ? "P" : "PP";
        String string3 = this.authMode;
        string3.getClass();
        int n = -1;
        switch (string3.hashCode()) {
            default: {
                break;
            }
            case 52: {
                if (!string3.equals("4")) break;
                n = 2;
                break;
            }
            case 51: {
                if (!string3.equals("3")) break;
                n = 1;
                break;
            }
            case 50: {
                if (!string3.equals("2")) break;
                n = 0;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                this.sendRequestToCapture("FACE", "FACE", string2);
                break;
            }
            case 1: {
                this.sendRequestToCapture("IRIS", "I", string2);
                break;
            }
            case 0: {
                this.sendRequestToCapture("BIO", "F", string2);
            }
        }
    }

    public void onBackPressed() {
    }

    public void validateRequest(String string2, String string3) {
        ProgressUtil.getInstance().showProgressDialog((Context)this, "Validating...");
        ServerUtil serverUtil = ServerUtil.getInstance();
        new Thread(() -> {
            ECSRDKycRequest eCSRDKycRequest;
            ECSRDKycRequest eCSRDKycRequest2;
            ECSRDKycRequest eCSRDKycRequest3 = eCSRDKycRequest2 = eCSRDKycRequest;
            ECSRDKycRequest eCSRDKycRequest4 = eCSRDKycRequest2;
            ECSRDKycRequest eCSRDKycRequest5 = eCSRDKycRequest2;
            eCSRDKycRequest5();
            eCSRDKycRequest5.setPfr(false);
            eCSRDKycRequest5.setLr(false);
            eCSRDKycRequest2.setConsent(this.consent);
            eCSRDKycRequest2.setPidData(com.ecs.cdslutils.Base64.encode(((String)string2).getBytes()));
            eCSRDKycRequest4.setUid(this.aadhaarNo);
            eCSRDKycRequest4.setUsesBio(true);
            eCSRDKycRequest3.setUsesBt(string3);
            eCSRDKycRequest3.setUsesOtp(false);
            eCSRDKycRequest3.setOtpTxn(null);
            eCSRDKycRequest.setEsignXML(com.ecs.cdslutils.Base64.encode(this.apiParams.getRequestXML().getBytes()));
            if (this.apiParams.getEnvironment().equalsIgnoreCase("prod")) {
                DBSFingerprintCaptureActivity dBSFingerprintCaptureActivity = this;
                string2 = Globals.getProdEsignUrl();
                string3 = dBSFingerprintCaptureActivity.aspTxn;
                string2 = serverUtil.performServerCall((Activity)dBSFingerprintCaptureActivity, string2, eCSRDKycRequest2, string3, ECSRDKycResponse.class, true);
            } else {
                DBSFingerprintCaptureActivity dBSFingerprintCaptureActivity = this;
                string2 = Globals.getUatEsignUrl();
                string3 = dBSFingerprintCaptureActivity.aspTxn;
                string2 = serverUtil.performServerCall((Activity)dBSFingerprintCaptureActivity, string2, eCSRDKycRequest2, string3, ECSRDKycResponse.class, true);
            }
            if (string2 != null) {
                if (((ECSRDKycResponse)((Object)string2)).isError()) {
                    string2 = ((ECSRDKycResponse)((Object)string2)).getErrXML();
                    this.responseHandler.returnErrorResponse((Activity)this, string2);
                } else {
                    this.returnSuccessResponse((ECSRDKycResponse)((Object)string2));
                }
            }
        }).start();
    }

    public String decodeBase64(String string2) {
        Object object = new byte[0];
        int n = Build.VERSION.SDK_INT;
        if (n >= 8) {
            object = Base64.decode((String)string2, (int)0);
        }
        if (n >= 19) {
            return new String((byte[])object, StandardCharsets.UTF_8);
        }
        return new String((byte[])object);
    }
}

