/*
 * Decompiled with CFR 0.152.
 */
package be.quodlibet.boxable.utils;

import be.quodlibet.boxable.line.LineStyle;
import be.quodlibet.boxable.utils.FontUtils;
import be.quodlibet.boxable.utils.PageContentStreamOptimized;
import java.awt.Color;
import java.io.IOException;
import org.apache.pdfbox.pdmodel.font.PDFont;

public final class PDStreamUtils {
    private PDStreamUtils() {
    }

    public static void write(PageContentStreamOptimized stream, String text, PDFont font, float fontSize, float x, float y, Color color) {
        try {
            stream.setFont(font, fontSize);
            stream.newLineAt(x, y - FontUtils.getDescent(font, fontSize) - FontUtils.getHeight(font, fontSize));
            stream.setNonStrokingColor(color);
            stream.showText(text);
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to write text", e);
        }
    }

    public static void rect(PageContentStreamOptimized stream, float x, float y, float width, float height, Color color) {
        try {
            stream.setNonStrokingColor(color);
            stream.addRect(x, y, width, -height);
            stream.fill();
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to draw rectangle", e);
        }
    }

    public static void rectFontMetrics(PageContentStreamOptimized stream, float x, float y, PDFont font, float fontSize) {
        PDStreamUtils.rect(stream, x, y, 3.0f, FontUtils.getHeight(font, fontSize), Color.BLUE);
        PDStreamUtils.rect(stream, x + 3.0f, y, 3.0f, FontUtils.getAscent(font, fontSize), Color.CYAN);
        PDStreamUtils.rect(stream, x + 3.0f, y - FontUtils.getHeight(font, fontSize), 3.0f, FontUtils.getDescent(font, 14.0f), Color.GREEN);
    }

    public static void setLineStyles(PageContentStreamOptimized stream, LineStyle line) throws IOException {
        stream.setStrokingColor(line.getColor());
        stream.setLineWidth(line.getWidth());
        stream.setLineCapStyle(0);
        if (line.getDashArray() != null) {
            stream.setLineDashPattern(line.getDashArray(), line.getDashPhase());
        } else {
            stream.setLineDashPattern(new float[0], 0.0f);
        }
    }
}

