/*
 * Decompiled with CFR 0.152.
 */
package be.quodlibet.boxable;

import be.quodlibet.boxable.HorizontalAlignment;
import be.quodlibet.boxable.Paragraph;
import be.quodlibet.boxable.Row;
import be.quodlibet.boxable.VerticalAlignment;
import be.quodlibet.boxable.text.WrappingFunction;
import java.awt.Color;
import java.io.IOException;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDType1Font;

public class Cell<T extends PDPage> {
    private float width;
    private String text;
    private PDFont font = PDType1Font.HELVETICA;
    private PDFont fontBold = PDType1Font.HELVETICA_BOLD;
    private float fontSize = 8.0f;
    private Color fillColor;
    private Color textColor = Color.BLACK;
    private final Row<T> row;
    private WrappingFunction wrappingFunction;
    private boolean isHeaderCell = false;
    private float leftPadding = 5.0f;
    private float rightPadding = 5.0f;
    private float topPadding = 5.0f;
    private float bottomPadding = 5.0f;
    private Paragraph paragraph = null;
    private final HorizontalAlignment align;
    private final VerticalAlignment valign;
    float horizontalFreeSpace = 0.0f;
    float verticalFreeSpace = 0.0f;

    Cell(Row<T> row, float width, String text, boolean isCalculated) {
        this(row, width, text, isCalculated, HorizontalAlignment.LEFT, VerticalAlignment.TOP);
    }

    Cell(Row<T> row, float width, String text, boolean isCalculated, HorizontalAlignment align, VerticalAlignment valign) {
        this.row = row;
        if (isCalculated) {
            double calclulatedWidth = row.getWidth() * width / 100.0f;
            this.width = (float)calclulatedWidth;
        } else {
            this.width = width;
        }
        if (this.getWidth() > row.getWidth()) {
            throw new IllegalArgumentException("Cell Width=" + this.getWidth() + " can't be bigger than row width=" + row.getWidth());
        }
        this.text = text == null ? "" : text;
        this.align = align;
        this.valign = valign;
        this.wrappingFunction = null;
    }

    public Color getTextColor() {
        return this.textColor;
    }

    public void setTextColor(Color textColor) {
        this.textColor = textColor;
    }

    public Color getFillColor() {
        return this.fillColor;
    }

    public void setFillColor(Color fillColor) {
        this.fillColor = fillColor;
    }

    public float getWidth() {
        return this.width;
    }

    public float getInnerWidth() {
        return this.getWidth() - this.getLeftPadding() - this.getRightPadding();
    }

    public float getInnerHeight() {
        return this.getHeight() - this.getBottomPadding() - this.getTopPadding();
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
        this.paragraph = null;
    }

    public PDFont getFont() {
        if (this.font == null) {
            throw new IllegalArgumentException("Font not set.");
        }
        return this.font;
    }

    public void setFont(PDFont font) {
        this.font = font;
        this.paragraph = null;
    }

    public float getFontSize() {
        return this.fontSize;
    }

    public void setFontSize(float fontSize) {
        this.fontSize = fontSize;
        this.paragraph = null;
    }

    public Paragraph getParagraph() {
        if (this.paragraph == null) {
            this.paragraph = this.isHeaderCell ? new Paragraph(this.text, this.fontBold, this.fontSize, this.getInnerWidth(), this.align, this.textColor, null, this.wrappingFunction) : new Paragraph(this.text, this.font, this.fontSize, this.getInnerWidth(), this.align, this.textColor, null, this.wrappingFunction);
        }
        return this.paragraph;
    }

    public float getExtraWidth() {
        return this.row.getLastCellExtraWidth() + this.getWidth();
    }

    public float getHeight() {
        return this.row.getHeight();
    }

    public float getTextHeight() {
        return this.getParagraph().getHeight();
    }

    public float getLeftPadding() {
        return this.leftPadding;
    }

    public void setLeftPadding(float cellLeftPadding) {
        this.leftPadding = cellLeftPadding;
        this.paragraph = null;
    }

    public float getRightPadding() {
        return this.rightPadding;
    }

    public void setRightPadding(float cellRightPadding) {
        this.rightPadding = cellRightPadding;
        this.paragraph = null;
    }

    public float getTopPadding() {
        return this.topPadding;
    }

    public void setTopPadding(float cellTopPadding) {
        this.topPadding = cellTopPadding;
    }

    public float getBottomPadding() {
        return this.bottomPadding;
    }

    public void setBottomPadding(float cellBottomPadding) {
        this.bottomPadding = cellBottomPadding;
    }

    public float getVerticalFreeSpace() {
        return this.getInnerHeight() - this.getTextHeight();
    }

    public float getHorizontalFreeSpace() {
        float tw = 0.0f;
        try {
            for (String line : this.getParagraph().getLines()) {
                tw = Math.max(tw, this.getFont().getStringWidth(line.trim()));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        tw = tw / 1000.0f * this.getFontSize();
        return this.getInnerWidth() - tw;
    }

    public HorizontalAlignment getAlign() {
        return this.align;
    }

    public VerticalAlignment getValign() {
        return this.valign;
    }

    public boolean isHeaderCell() {
        return this.isHeaderCell;
    }

    public void setHeaderCell(boolean isHeaderCell) {
        this.isHeaderCell = isHeaderCell;
    }

    public WrappingFunction getWrappingFunction() {
        return this.getParagraph().getWrappingFunction();
    }

    public void setWrappingFunction(WrappingFunction wrappingFunction) {
        this.wrappingFunction = wrappingFunction;
        this.paragraph = null;
    }

    public PDFont getFontBold() {
        return this.fontBold;
    }
}

