/*
 * Decompiled with CFR 0.152.
 */
package org.hisp.dhis.smscompression.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hisp.dhis.smscompression.SMSCompressionException;
import org.hisp.dhis.smscompression.SMSConsts;
import org.hisp.dhis.smscompression.models.SMSMetadata;
import org.hisp.dhis.smscompression.models.UID;
import org.hisp.dhis.smscompression.utils.BinaryUtils;
import org.hisp.dhis.smscompression.utils.BitInputStream;
import org.hisp.dhis.smscompression.utils.BitOutputStream;
import org.hisp.dhis.smscompression.utils.ValueUtil;

public class IDUtil {
    public static int getBitLengthForList(List<String> ids) throws SMSCompressionException {
        int len = BinaryUtils.bitlenNeeded(ids.size());
        boolean collision = false;
        do {
            collision = false;
            ArrayList<Integer> idList = new ArrayList<Integer>();
            for (String id : ids) {
                int newHash = BinaryUtils.hash(id, len);
                if (idList.contains(newHash)) {
                    ++len;
                    collision = true;
                    break;
                }
                idList.add(newHash);
            }
            if (!((double)len > Math.pow(2.0, 6.0))) continue;
            throw new SMSCompressionException("Error hashing: Group too large to support");
        } while (collision);
        return len;
    }

    public static boolean validID(String id) {
        return id.matches("^[A-z0-9]{11}$");
    }

    public static int convertIDCharToInt(char c) {
        int i = c;
        if (c >= 48 && c <= 57) {
            i -= 48;
        } else if (c >= 65 && c <= 90) {
            i -= 55;
        } else if (c >= 97 && c <= 122) {
            i -= 61;
        }
        return i;
    }

    public static char convertIDIntToChar(int i) {
        char c = (char)i;
        if ((c = (char)(c + 48)) >= '0' && c <= '9') {
            return c;
        }
        if ((c = (char)(c + 7)) >= 'A' && c <= 'Z') {
            return c;
        }
        if ((c = (char)(c + 6)) >= 'a' && c <= 'z') {
            return c;
        }
        return '\u0000';
    }

    public static void writeNewID(String id, BitOutputStream outStream) throws SMSCompressionException {
        if (!IDUtil.validID(id)) {
            throw new SMSCompressionException("Attempting to write out ID with invalid format: " + id);
        }
        for (char c : id.toCharArray()) {
            outStream.write(IDUtil.convertIDCharToInt(c), 6);
        }
    }

    public static String readNewID(BitInputStream inStream) throws SMSCompressionException {
        String id = "";
        while (id.length() < 11) {
            int i = inStream.read(6);
            id = id + IDUtil.convertIDIntToChar(i);
        }
        return id;
    }

    public static UID readID(SMSConsts.MetadataType type, SMSMetadata meta, BitInputStream inStream) throws SMSCompressionException {
        boolean useHash = ValueUtil.readBool(inStream);
        if (useHash) {
            int typeBitLen = inStream.read(6);
            Map<Integer, String> idLookup = IDUtil.getIDLookup(meta.getType(type), typeBitLen);
            int idHash = inStream.read(typeBitLen);
            return new UID(idLookup.get(idHash), idHash, type);
        }
        return new UID(IDUtil.readNewID(inStream), type);
    }

    public static Map<Integer, String> getIDLookup(List<String> idList, int hashLen) {
        HashMap<Integer, String> idLookup = new HashMap<Integer, String>();
        for (String id : idList) {
            int hash = BinaryUtils.hash(id, hashLen);
            idLookup.put(hash, id);
        }
        return idLookup;
    }

    public static void writeID(UID uid, boolean hashingEnabled, SMSMetadata meta, BitOutputStream outStream) throws SMSCompressionException {
        if (!IDUtil.validID(uid.uid)) {
            throw new SMSCompressionException("Attempting to write out ID with invalid format: " + uid.uid);
        }
        List<String> idList = meta != null ? meta.getType(uid.type) : null;
        boolean useHash = hashingEnabled && idList != null && idList.contains(uid.uid);
        ValueUtil.writeBool(useHash, outStream);
        if (useHash) {
            int typeBitLen = IDUtil.getBitLengthForList(idList);
            outStream.write(typeBitLen, 6);
            int idHash = BinaryUtils.hash(uid.uid, typeBitLen);
            outStream.write(idHash, typeBitLen);
        } else {
            IDUtil.writeNewID(uid.uid, outStream);
        }
    }

    public static String hashAsBase64(UID uid) {
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
        BitOutputStream outStream = new BitOutputStream(byteStream);
        int bitLen = BinaryUtils.bitlenNeeded(uid.hash);
        try {
            outStream.write(uid.type.ordinal(), 5);
            outStream.write(bitLen, 6);
            outStream.write(uid.hash, bitLen);
            outStream.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return Base64.getEncoder().encodeToString(byteStream.toByteArray());
    }

    public static UID getUIDFromHash(String hashStr, SMSMetadata meta) {
        byte[] hashBytes = Base64.getDecoder().decode(hashStr.replace("#", ""));
        ByteArrayInputStream byteStream = new ByteArrayInputStream(hashBytes);
        BitInputStream inStream = new BitInputStream(byteStream);
        try {
            int typeID = inStream.read(5);
            SMSConsts.MetadataType type = SMSConsts.MetadataType.values()[typeID];
            int bitLen = inStream.read(6);
            int hash = inStream.read(bitLen);
            inStream.close();
            List<String> ids = meta.getType(type);
            Map<Integer, String> idMap = IDUtil.getIDLookup(ids, IDUtil.getBitLengthForList(ids));
            String uidStr = idMap.get(hash);
            return new UID(uidStr, hash, type);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

