/*
 * Decompiled with CFR 0.152.
 */
package org.hisp.dhis.smscompression.utils;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Objects;
import org.hisp.dhis.smscompression.SMSCompressionException;

public final class BitOutputStream
implements AutoCloseable {
    private OutputStream output;
    private int currentByte;
    private int numBitsFilled;

    public BitOutputStream(OutputStream out) {
        Objects.requireNonNull(out);
        this.output = out;
        this.currentByte = 0;
        this.numBitsFilled = 0;
    }

    public void writeBit(int b) throws IOException {
        if (b != 0 && b != 1) {
            throw new IllegalArgumentException("Argument must be 0 or 1");
        }
        this.currentByte = this.currentByte << 1 | b;
        ++this.numBitsFilled;
        if (this.numBitsFilled == 8) {
            this.output.write(this.currentByte);
            this.currentByte = 0;
            this.numBitsFilled = 0;
        }
    }

    public void write(int i, int n) throws SMSCompressionException {
        try {
            if (i < 0) {
                throw new NumberFormatException("Cannot write negative ints");
            }
            int mask = 1 << n - 1;
            while (n > 0) {
                int nextBit = (mask & i) > 0 ? 1 : 0;
                this.writeBit(nextBit);
                mask >>>= 1;
                --n;
            }
        }
        catch (IOException e) {
            throw new SMSCompressionException(e);
        }
    }

    @Override
    public void close() throws IOException {
        while (this.numBitsFilled != 0) {
            this.writeBit(0);
        }
        this.output.close();
    }
}

