/*
 * Decompiled with CFR 0.152.
 */
package org.hisp.dhis.smscompression.models;

import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.hisp.dhis.smscompression.SMSCompressionException;
import org.hisp.dhis.smscompression.SMSConsts;
import org.hisp.dhis.smscompression.SMSSubmissionReader;
import org.hisp.dhis.smscompression.SMSSubmissionWriter;
import org.hisp.dhis.smscompression.models.GeoPoint;
import org.hisp.dhis.smscompression.models.SMSDataValue;
import org.hisp.dhis.smscompression.models.SMSSubmission;
import org.hisp.dhis.smscompression.models.UID;

public class TrackerEventSMSSubmission
extends SMSSubmission {
    protected UID orgUnit;
    protected UID programStage;
    protected SMSConsts.SMSEventStatus eventStatus;
    protected UID attributeOptionCombo;
    protected UID enrollment;
    protected UID event;
    protected Date eventDate;
    protected Date dueDate;
    protected GeoPoint coordinates;
    protected List<SMSDataValue> values;

    public UID getOrgUnit() {
        return this.orgUnit;
    }

    public void setOrgUnit(String orgUnit) {
        this.orgUnit = new UID(orgUnit, SMSConsts.MetadataType.ORGANISATION_UNIT);
    }

    public UID getProgramStage() {
        return this.programStage;
    }

    public void setProgramStage(String programStage) {
        this.programStage = new UID(programStage, SMSConsts.MetadataType.PROGRAM_STAGE);
    }

    public SMSConsts.SMSEventStatus getEventStatus() {
        return this.eventStatus;
    }

    public void setEventStatus(SMSConsts.SMSEventStatus eventStatus) {
        this.eventStatus = eventStatus;
    }

    public UID getAttributeOptionCombo() {
        return this.attributeOptionCombo;
    }

    public void setAttributeOptionCombo(String attributeOptionCombo) {
        this.attributeOptionCombo = new UID(attributeOptionCombo, SMSConsts.MetadataType.CATEGORY_OPTION_COMBO);
    }

    public UID getEnrollment() {
        return this.enrollment;
    }

    public void setEnrollment(String enrollment) {
        this.enrollment = new UID(enrollment, SMSConsts.MetadataType.ENROLLMENT);
    }

    public UID getEvent() {
        return this.event;
    }

    public void setEvent(String event) {
        this.event = new UID(event, SMSConsts.MetadataType.EVENT);
    }

    public Date getEventDate() {
        return this.eventDate;
    }

    public void setEventDate(Date eventDate) {
        this.eventDate = eventDate;
    }

    public Date getDueDate() {
        return this.dueDate;
    }

    public void setDueDate(Date dueDate) {
        this.dueDate = dueDate;
    }

    public GeoPoint getCoordinates() {
        return this.coordinates;
    }

    public void setCoordinates(GeoPoint coordinates) {
        this.coordinates = coordinates;
    }

    public List<SMSDataValue> getValues() {
        return this.values;
    }

    public void setValues(List<SMSDataValue> values) {
        this.values = values;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        TrackerEventSMSSubmission subm = (TrackerEventSMSSubmission)o;
        return Objects.equals(this.orgUnit, subm.orgUnit) && Objects.equals(this.programStage, subm.programStage) && Objects.equals((Object)this.eventStatus, (Object)subm.eventStatus) && Objects.equals(this.attributeOptionCombo, subm.attributeOptionCombo) && this.enrollment.equals(subm.enrollment) && Objects.equals(this.event, subm.event) && Objects.equals(this.eventDate, subm.eventDate) && Objects.equals(this.dueDate, subm.dueDate) && Objects.equals(this.coordinates, subm.coordinates) && Objects.equals(this.values, subm.values);
    }

    @Override
    public void writeSubm(SMSSubmissionWriter writer, int version) throws SMSCompressionException {
        switch (version) {
            case 1: {
                this.writeSubmV1(writer);
                break;
            }
            case 2: {
                this.writeSubmV2(writer);
                break;
            }
            default: {
                throw new SMSCompressionException(this.versionError(version));
            }
        }
    }

    private void writeSubmV1(SMSSubmissionWriter writer) throws SMSCompressionException {
        writer.writeID(this.orgUnit);
        writer.writeID(this.programStage);
        writer.writeEventStatus(this.eventStatus);
        writer.writeID(this.attributeOptionCombo);
        writer.writeID(this.enrollment);
        writer.writeID(this.event);
        writer.writeNonNullableDate(this.eventDate);
        writer.writeDataValues(this.values);
    }

    private void writeSubmV2(SMSSubmissionWriter writer) throws SMSCompressionException {
        writer.writeID(this.orgUnit);
        writer.writeID(this.programStage);
        writer.writeEventStatus(this.eventStatus);
        writer.writeID(this.attributeOptionCombo);
        writer.writeID(this.enrollment);
        writer.writeID(this.event);
        writer.writeDate(this.eventDate);
        writer.writeDate(this.dueDate);
        writer.writeGeoPoint(this.coordinates);
        boolean hasValues = this.values != null && !this.values.isEmpty();
        writer.writeBool(hasValues);
        if (hasValues) {
            writer.writeDataValues(this.values);
        }
    }

    @Override
    public void readSubm(SMSSubmissionReader reader, int version) throws SMSCompressionException {
        switch (version) {
            case 1: {
                this.readSubmV1(reader);
                break;
            }
            case 2: {
                this.readSubmV2(reader);
                break;
            }
            default: {
                throw new SMSCompressionException(this.versionError(version));
            }
        }
    }

    private void readSubmV1(SMSSubmissionReader reader) throws SMSCompressionException {
        this.orgUnit = reader.readID(SMSConsts.MetadataType.ORGANISATION_UNIT);
        this.programStage = reader.readID(SMSConsts.MetadataType.PROGRAM_STAGE);
        this.eventStatus = reader.readEventStatus();
        this.attributeOptionCombo = reader.readID(SMSConsts.MetadataType.CATEGORY_OPTION_COMBO);
        this.enrollment = reader.readID(SMSConsts.MetadataType.ENROLLMENT);
        this.event = reader.readID(SMSConsts.MetadataType.EVENT);
        this.eventDate = reader.readNonNullableDate();
        this.values = reader.readDataValues();
    }

    private void readSubmV2(SMSSubmissionReader reader) throws SMSCompressionException {
        this.orgUnit = reader.readID(SMSConsts.MetadataType.ORGANISATION_UNIT);
        this.programStage = reader.readID(SMSConsts.MetadataType.PROGRAM_STAGE);
        this.eventStatus = reader.readEventStatus();
        this.attributeOptionCombo = reader.readID(SMSConsts.MetadataType.CATEGORY_OPTION_COMBO);
        this.enrollment = reader.readID(SMSConsts.MetadataType.ENROLLMENT);
        this.event = reader.readID(SMSConsts.MetadataType.EVENT);
        this.eventDate = reader.readDate();
        this.dueDate = reader.readDate();
        this.coordinates = reader.readGeoPoint();
        boolean hasValues = reader.readBool();
        this.values = hasValues ? reader.readDataValues() : null;
    }

    @Override
    public int getCurrentVersion() {
        return 2;
    }

    @Override
    public SMSConsts.SubmissionType getType() {
        return SMSConsts.SubmissionType.TRACKER_EVENT;
    }
}

