/*
 * Decompiled with CFR 0.152.
 */
package org.hisp.dhis.smscompression.models;

import java.text.ParseException;
import java.util.Date;
import org.hisp.dhis.smscompression.SMSConsts;

public class SMSValue<T> {
    T value;
    SMSConsts.ValueType type;

    public SMSValue(T value, SMSConsts.ValueType type) {
        this.value = value;
        this.type = type;
    }

    public T getValue() {
        return this.value;
    }

    public SMSConsts.ValueType getType() {
        return this.type;
    }

    public static SMSValue<?> asSMSValue(String value) {
        if (value.equals("true") || value.equals("false")) {
            Boolean valBool = value.equals("true");
            return new SMSValue<Boolean>(valBool, SMSConsts.ValueType.BOOL);
        }
        try {
            Date valDate = SMSConsts.SIMPLE_DATE_FORMAT.parse(value);
            return new SMSValue<Date>(valDate, SMSConsts.ValueType.DATE);
        }
        catch (ParseException valDate) {
            try {
                Integer valInt = Integer.parseInt(value);
                return new SMSValue<Integer>(valInt, SMSConsts.ValueType.INT);
            }
            catch (NumberFormatException valInt) {
                try {
                    Float valFloat = Float.valueOf(Float.parseFloat(value));
                    return new SMSValue<Float>(valFloat, SMSConsts.ValueType.FLOAT);
                }
                catch (NumberFormatException numberFormatException) {
                    return new SMSValue<String>(value, SMSConsts.ValueType.STRING);
                }
            }
        }
    }
}

