/*
 * Decompiled with CFR 0.152.
 */
package org.hisp.dhis.smscompression.models;

import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.hisp.dhis.smscompression.SMSCompressionException;
import org.hisp.dhis.smscompression.SMSConsts;
import org.hisp.dhis.smscompression.SMSSubmissionReader;
import org.hisp.dhis.smscompression.SMSSubmissionWriter;
import org.hisp.dhis.smscompression.models.GeoPoint;
import org.hisp.dhis.smscompression.models.SMSDataValue;
import org.hisp.dhis.smscompression.models.UID;

public class SMSEvent {
    protected UID orgUnit;
    protected UID programStage;
    protected SMSConsts.SMSEventStatus eventStatus;
    protected UID attributeOptionCombo;
    protected UID event;
    protected Date eventDate;
    protected Date dueDate;
    protected GeoPoint coordinates;
    protected List<SMSDataValue> values;

    public UID getOrgUnit() {
        return this.orgUnit;
    }

    public void setOrgUnit(String orgUnit) {
        this.orgUnit = new UID(orgUnit, SMSConsts.MetadataType.ORGANISATION_UNIT);
    }

    public UID getProgramStage() {
        return this.programStage;
    }

    public void setProgramStage(String programStage) {
        this.programStage = new UID(programStage, SMSConsts.MetadataType.PROGRAM_STAGE);
    }

    public SMSConsts.SMSEventStatus getEventStatus() {
        return this.eventStatus;
    }

    public void setEventStatus(SMSConsts.SMSEventStatus eventStatus) {
        this.eventStatus = eventStatus;
    }

    public UID getAttributeOptionCombo() {
        return this.attributeOptionCombo;
    }

    public void setAttributeOptionCombo(String attributeOptionCombo) {
        this.attributeOptionCombo = new UID(attributeOptionCombo, SMSConsts.MetadataType.CATEGORY_OPTION_COMBO);
    }

    public UID getEvent() {
        return this.event;
    }

    public void setEvent(String event) {
        this.event = new UID(event, SMSConsts.MetadataType.EVENT);
    }

    public Date getEventDate() {
        return this.eventDate;
    }

    public void setEventDate(Date eventDate) {
        this.eventDate = eventDate;
    }

    public Date getDueDate() {
        return this.dueDate;
    }

    public void setDueDate(Date dueDate) {
        this.dueDate = dueDate;
    }

    public GeoPoint getCoordinates() {
        return this.coordinates;
    }

    public void setCoordinates(GeoPoint coordinates) {
        this.coordinates = coordinates;
    }

    public List<SMSDataValue> getValues() {
        return this.values;
    }

    public void setValues(List<SMSDataValue> values) {
        this.values = values;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SMSEvent e = (SMSEvent)o;
        return Objects.equals(this.orgUnit, e.orgUnit) && Objects.equals(this.programStage, e.programStage) && Objects.equals((Object)this.eventStatus, (Object)e.eventStatus) && Objects.equals(this.attributeOptionCombo, e.attributeOptionCombo) && this.event.equals(e.event) && Objects.equals(this.eventDate, e.eventDate) && Objects.equals(this.dueDate, e.dueDate) && Objects.equals(this.coordinates, e.coordinates) && Objects.equals(this.values, e.values);
    }

    public void writeEvent(SMSSubmissionWriter writer, int version) throws SMSCompressionException {
        if (version != 2) {
            throw new SMSCompressionException(this.versionError(version));
        }
        writer.writeID(this.orgUnit);
        writer.writeID(this.programStage);
        writer.writeEventStatus(this.eventStatus);
        writer.writeID(this.attributeOptionCombo);
        writer.writeID(this.event);
        writer.writeDate(this.eventDate);
        writer.writeDate(this.dueDate);
        writer.writeGeoPoint(this.coordinates);
        boolean hasValues = this.values != null && !this.values.isEmpty();
        writer.writeBool(hasValues);
        if (hasValues) {
            writer.writeDataValues(this.values);
        }
    }

    public void readEvent(SMSSubmissionReader reader, int version) throws SMSCompressionException {
        if (version != 2) {
            throw new SMSCompressionException(this.versionError(version));
        }
        this.orgUnit = reader.readID(SMSConsts.MetadataType.ORGANISATION_UNIT);
        this.programStage = reader.readID(SMSConsts.MetadataType.PROGRAM_STAGE);
        this.eventStatus = reader.readEventStatus();
        this.attributeOptionCombo = reader.readID(SMSConsts.MetadataType.CATEGORY_OPTION_COMBO);
        this.event = reader.readID(SMSConsts.MetadataType.EVENT);
        this.eventDate = reader.readDate();
        this.dueDate = reader.readDate();
        this.coordinates = reader.readGeoPoint();
        boolean hasValues = reader.readBool();
        this.values = hasValues ? reader.readDataValues() : null;
    }

    public int getCurrentVersion() {
        return 2;
    }

    private String versionError(int version) {
        return String.format("Version %d of %s is not supported", version, this.getClass().getSimpleName());
    }
}

