/*
 * Decompiled with CFR 0.152.
 */
package org.hisp.dhis.smscompression.models;

import org.hisp.dhis.smscompression.SMSConsts;
import org.hisp.dhis.smscompression.models.SMSValue;
import org.hisp.dhis.smscompression.models.UID;

public class SMSDataValue {
    protected UID categoryOptionCombo;
    protected UID dataElement;
    protected String value;
    protected SMSValue<?> smsValue;

    public SMSDataValue(String categoryOptionCombo, String dataElement, String value) {
        this.categoryOptionCombo = new UID(categoryOptionCombo, SMSConsts.MetadataType.CATEGORY_OPTION_COMBO);
        this.dataElement = new UID(dataElement, SMSConsts.MetadataType.DATA_ELEMENT);
        this.value = value;
        this.smsValue = SMSValue.asSMSValue(value);
    }

    public SMSDataValue(UID categoryOptionCombo, UID dataElement, SMSValue<?> smsValue) {
        this.categoryOptionCombo = categoryOptionCombo;
        this.dataElement = dataElement;
        this.smsValue = smsValue;
        this.value = smsValue.getValue().toString();
    }

    public UID getCategoryOptionCombo() {
        return this.categoryOptionCombo;
    }

    public UID getDataElement() {
        return this.dataElement;
    }

    public String getValue() {
        return this.value;
    }

    public SMSValue<?> getSMSValue() {
        return this.smsValue;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SMSDataValue dv = (SMSDataValue)o;
        return this.categoryOptionCombo.equals(dv.categoryOptionCombo) && this.dataElement.equals(dv.dataElement) && this.value.equals(dv.value);
    }

    public int hashCode() {
        return 0;
    }
}

