/*
 * Decompiled with CFR 0.152.
 */
package org.hisp.dhis.smscompression.models;

import java.util.List;
import java.util.Objects;
import org.hisp.dhis.smscompression.SMSCompressionException;
import org.hisp.dhis.smscompression.SMSConsts;
import org.hisp.dhis.smscompression.SMSSubmissionReader;
import org.hisp.dhis.smscompression.SMSSubmissionWriter;
import org.hisp.dhis.smscompression.models.SMSDataValue;
import org.hisp.dhis.smscompression.models.SMSSubmission;
import org.hisp.dhis.smscompression.models.UID;

public class AggregateDatasetSMSSubmission
extends SMSSubmission {
    protected UID orgUnit;
    protected UID dataSet;
    protected boolean complete;
    protected UID attributeOptionCombo;
    protected String period;
    protected List<SMSDataValue> values;

    public UID getOrgUnit() {
        return this.orgUnit;
    }

    public void setOrgUnit(String orgUnit) {
        this.orgUnit = new UID(orgUnit, SMSConsts.MetadataType.ORGANISATION_UNIT);
    }

    public UID getDataSet() {
        return this.dataSet;
    }

    public void setDataSet(String dataSet) {
        this.dataSet = new UID(dataSet, SMSConsts.MetadataType.DATASET);
    }

    public boolean isComplete() {
        return this.complete;
    }

    public void setComplete(boolean complete) {
        this.complete = complete;
    }

    public UID getAttributeOptionCombo() {
        return this.attributeOptionCombo;
    }

    public void setAttributeOptionCombo(String attributeOptionCombo) {
        this.attributeOptionCombo = new UID(attributeOptionCombo, SMSConsts.MetadataType.CATEGORY_OPTION_COMBO);
    }

    public String getPeriod() {
        return this.period;
    }

    public void setPeriod(String period) {
        this.period = period;
    }

    public List<SMSDataValue> getValues() {
        return this.values;
    }

    public void setValues(List<SMSDataValue> values) {
        this.values = values;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        AggregateDatasetSMSSubmission subm = (AggregateDatasetSMSSubmission)o;
        return Objects.equals(this.orgUnit, subm.orgUnit) && Objects.equals(this.dataSet, subm.dataSet) && Objects.equals(this.complete, subm.complete) && Objects.equals(this.attributeOptionCombo, subm.attributeOptionCombo) && Objects.equals(this.period, subm.period) && Objects.equals(this.values, subm.values);
    }

    @Override
    public void writeSubm(SMSSubmissionWriter writer, int version) throws SMSCompressionException {
        switch (version) {
            case 1: {
                this.writeSubmV1(writer);
                break;
            }
            case 2: {
                this.writeSubmV2(writer);
                break;
            }
            default: {
                throw new SMSCompressionException(this.versionError(version));
            }
        }
    }

    private void writeSubmV1(SMSSubmissionWriter writer) throws SMSCompressionException {
        writer.writeID(this.orgUnit);
        writer.writeID(this.dataSet);
        writer.writeBool(this.complete);
        writer.writeID(this.attributeOptionCombo);
        writer.writePeriod(this.period);
        writer.writeDataValues(this.values);
    }

    private void writeSubmV2(SMSSubmissionWriter writer) throws SMSCompressionException {
        writer.writeID(this.orgUnit);
        writer.writeID(this.dataSet);
        writer.writeBool(this.complete);
        writer.writeID(this.attributeOptionCombo);
        writer.writePeriod(this.period);
        boolean hasValues = this.values != null && !this.values.isEmpty();
        writer.writeBool(hasValues);
        if (hasValues) {
            writer.writeDataValues(this.values);
        }
    }

    @Override
    public void readSubm(SMSSubmissionReader reader, int version) throws SMSCompressionException {
        switch (version) {
            case 1: {
                this.readSubmV1(reader);
                break;
            }
            case 2: {
                this.readSubmV2(reader);
                break;
            }
            default: {
                throw new SMSCompressionException(this.versionError(version));
            }
        }
    }

    private void readSubmV1(SMSSubmissionReader reader) throws SMSCompressionException {
        this.orgUnit = reader.readID(SMSConsts.MetadataType.ORGANISATION_UNIT);
        this.dataSet = reader.readID(SMSConsts.MetadataType.DATASET);
        this.complete = reader.readBool();
        this.attributeOptionCombo = reader.readID(SMSConsts.MetadataType.CATEGORY_OPTION_COMBO);
        this.period = reader.readPeriod();
        this.values = reader.readDataValues();
    }

    private void readSubmV2(SMSSubmissionReader reader) throws SMSCompressionException {
        this.orgUnit = reader.readID(SMSConsts.MetadataType.ORGANISATION_UNIT);
        this.dataSet = reader.readID(SMSConsts.MetadataType.DATASET);
        this.complete = reader.readBool();
        this.attributeOptionCombo = reader.readID(SMSConsts.MetadataType.CATEGORY_OPTION_COMBO);
        this.period = reader.readPeriod();
        boolean hasValues = reader.readBool();
        this.values = hasValues ? reader.readDataValues() : null;
    }

    @Override
    public int getCurrentVersion() {
        return 2;
    }

    @Override
    public SMSConsts.SubmissionType getType() {
        return SMSConsts.SubmissionType.AGGREGATE_DATASET;
    }
}

