/*
 * Decompiled with CFR 0.152.
 */
package org.hisp.dhis.smscompression;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.hisp.dhis.smscompression.SMSCompressionException;
import org.hisp.dhis.smscompression.SMSConsts;
import org.hisp.dhis.smscompression.models.SMSAttributeValue;
import org.hisp.dhis.smscompression.models.SMSDataValue;
import org.hisp.dhis.smscompression.models.SMSMetadata;
import org.hisp.dhis.smscompression.models.SMSValue;
import org.hisp.dhis.smscompression.models.UID;
import org.hisp.dhis.smscompression.utils.BitInputStream;
import org.hisp.dhis.smscompression.utils.IDUtil;
import org.hisp.dhis.smscompression.utils.ValueUtil;

public class ValueReader {
    BitInputStream inStream;
    SMSMetadata meta;
    boolean hashingEnabled;

    public ValueReader(BitInputStream inStream, SMSMetadata meta) {
        this.inStream = inStream;
        this.meta = meta;
    }

    public UID readValID(int bitLen, Map<Integer, String> idLookup, SMSConsts.MetadataType type) throws SMSCompressionException {
        if (!this.hashingEnabled) {
            return new UID(ValueUtil.readString(this.inStream), type);
        }
        int idHash = this.inStream.read(bitLen);
        String id = idLookup.get(idHash);
        return new UID(id, idHash, type);
    }

    public List<SMSAttributeValue> readAttributeValues() throws SMSCompressionException {
        ArrayList<SMSAttributeValue> values = new ArrayList<SMSAttributeValue>();
        SMSConsts.MetadataType type = SMSConsts.MetadataType.TRACKED_ENTITY_ATTRIBUTE;
        int attributeBitLen = 0;
        Map<Integer, String> idLookup = null;
        this.hashingEnabled = ValueUtil.readBool(this.inStream);
        if (this.hashingEnabled) {
            attributeBitLen = this.inStream.read(6);
            idLookup = IDUtil.getIDLookup(this.meta.getType(type), attributeBitLen);
        }
        int fixedIntBitLen = this.inStream.read(4) + 1;
        int valSep = 1;
        while (valSep == 1) {
            UID id = this.readValID(attributeBitLen, idLookup, type);
            SMSValue<?> smsValue = ValueUtil.readSMSValue(fixedIntBitLen, this.inStream);
            values.add(new SMSAttributeValue(id, smsValue));
            valSep = this.inStream.read(1);
        }
        return values;
    }

    public List<SMSDataValue> readDataValues() throws SMSCompressionException {
        int catOptionComboBitLen = 0;
        int dataElementBitLen = 0;
        Map<Integer, String> cocIDLookup = null;
        Map<Integer, String> deIDLookup = null;
        SMSConsts.MetadataType cocType = SMSConsts.MetadataType.CATEGORY_OPTION_COMBO;
        SMSConsts.MetadataType deType = SMSConsts.MetadataType.DATA_ELEMENT;
        this.hashingEnabled = ValueUtil.readBool(this.inStream);
        if (this.hashingEnabled) {
            catOptionComboBitLen = this.inStream.read(6);
            cocIDLookup = IDUtil.getIDLookup(this.meta.getType(cocType), catOptionComboBitLen);
            dataElementBitLen = this.inStream.read(6);
            deIDLookup = IDUtil.getIDLookup(this.meta.getType(deType), dataElementBitLen);
        }
        int fixedIntBitLen = this.inStream.read(4) + 1;
        ArrayList<SMSDataValue> values = new ArrayList<SMSDataValue>();
        int cocSep = 1;
        while (cocSep == 1) {
            UID catOptionCombo = this.readValID(catOptionComboBitLen, cocIDLookup, cocType);
            int valSep = 1;
            while (valSep == 1) {
                UID dataElement = this.readValID(dataElementBitLen, deIDLookup, deType);
                SMSValue<?> smsValue = ValueUtil.readSMSValue(fixedIntBitLen, this.inStream);
                values.add(new SMSDataValue(catOptionCombo, dataElement, smsValue));
                valSep = this.inStream.read(1);
            }
            cocSep = this.inStream.read(1);
        }
        return values;
    }
}

