/*
 * Decompiled with CFR 0.152.
 */
package com.github.dhaval2404.imagepicker;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentActivity;
import com.github.dhaval2404.imagepicker.ImagePickerActivity;
import com.github.dhaval2404.imagepicker.constant.ImageProvider;
import com.github.dhaval2404.imagepicker.listener.DismissListener;
import com.github.dhaval2404.imagepicker.listener.ResultListener;
import com.github.dhaval2404.imagepicker.util.DialogHelper;
import java.io.File;
import java.io.Serializable;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\b\u0016\u0018\u0000 \u00042\u00020\u0001:\u0002\u0003\u0004B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0005"}, d2={"Lcom/github/dhaval2404/imagepicker/ImagePicker;", "", "()V", "Builder", "Companion", "imagepicker_release"})
public class ImagePicker {
    public static final int REQUEST_CODE = 2404;
    public static final int RESULT_ERROR = 64;
    @NotNull
    public static final String EXTRA_IMAGE_PROVIDER = "extra.image_provider";
    @NotNull
    public static final String EXTRA_CAMERA_DEVICE = "extra.camera_device";
    @NotNull
    public static final String EXTRA_IMAGE_MAX_SIZE = "extra.image_max_size";
    @NotNull
    public static final String EXTRA_CROP = "extra.crop";
    @NotNull
    public static final String EXTRA_CROP_X = "extra.crop_x";
    @NotNull
    public static final String EXTRA_CROP_Y = "extra.crop_y";
    @NotNull
    public static final String EXTRA_MAX_WIDTH = "extra.max_width";
    @NotNull
    public static final String EXTRA_MAX_HEIGHT = "extra.max_height";
    @NotNull
    public static final String EXTRA_SAVE_DIRECTORY = "extra.save_directory";
    @NotNull
    public static final String EXTRA_ERROR = "extra.error";
    @NotNull
    public static final String EXTRA_FILE_PATH = "extra.file_path";
    @NotNull
    public static final String EXTRA_MIME_TYPES = "extra.mime_types";
    public static final Companion Companion = new Companion(null);

    @JvmStatic
    @NotNull
    public static final Builder with(@NotNull Activity activity) {
        return Companion.with(activity);
    }

    @JvmStatic
    @NotNull
    public static final Builder with(@NotNull Fragment fragment) {
        return Companion.with(fragment);
    }

    @JvmStatic
    @NotNull
    public static final String getError(@Nullable Intent data) {
        return Companion.getError(data);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\r\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0006\u0010\u001e\u001a\u00020\u0000J\u000e\u0010\u001f\u001a\u00020\u00002\u0006\u0010\u0016\u001a\u00020\u0015J\b\u0010 \u001a\u00020!H\u0002J\u001a\u0010 \u001a\u00020\u00132\u0012\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020!\u0012\u0004\u0012\u00020\u00130\u0012J\u0006\u0010\b\u001a\u00020\u0000J\u0016\u0010\b\u001a\u00020\u00002\u0006\u0010#\u001a\u00020\u000b2\u0006\u0010$\u001a\u00020\u000bJ\u0006\u0010%\u001a\u00020\u0000J\u0019\u0010&\u001a\u00020\u00002\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a\u00a2\u0006\u0002\u0010'J\u0006\u0010(\u001a\u00020\u0000J\b\u0010)\u001a\u00020*H\u0002J\u0016\u0010+\u001a\u00020\u00002\u0006\u0010,\u001a\u00020\u00152\u0006\u0010-\u001a\u00020\u0015J\u000e\u0010.\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010\u001d\u001a\u00020\u00002\u0006\u0010/\u001a\u000200J\u000e\u0010\u001d\u001a\u00020\u00002\u0006\u00101\u001a\u00020\u001bJ\u0014\u00102\u001a\u00020\u00002\f\u00103\u001a\b\u0012\u0004\u0012\u00020\u001304J\u000e\u00102\u001a\u00020\u00002\u0006\u00103\u001a\u00020\u000eJ\u001a\u00105\u001a\u00020\u00002\u0012\u00106\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00130\u0012J\u0010\u00107\u001a\u00020\u00132\u0006\u00108\u001a\u00020\u0015H\u0002J\u0006\u00109\u001a\u00020\u0013J\u000e\u00109\u001a\u00020\u00132\u0006\u00108\u001a\u00020\u0015J\u0010\u0010:\u001a\u00020\u00132\u0006\u00108\u001a\u00020\u0015H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0011\u001a\u0010\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u001cR\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006;"}, d2={"Lcom/github/dhaval2404/imagepicker/ImagePicker$Builder;", "", "fragment", "Landroidx/fragment/app/Fragment;", "(Landroidx/fragment/app/Fragment;)V", "activity", "Landroid/app/Activity;", "(Landroid/app/Activity;)V", "crop", "", "cropX", "", "cropY", "dismissListener", "Lcom/github/dhaval2404/imagepicker/listener/DismissListener;", "imageProvider", "Lcom/github/dhaval2404/imagepicker/constant/ImageProvider;", "imageProviderInterceptor", "Lkotlin/Function1;", "", "maxHeight", "", "maxSize", "", "maxWidth", "mimeTypes", "", "", "[Ljava/lang/String;", "saveDir", "cameraOnly", "compress", "createIntent", "Landroid/content/Intent;", "onResult", "x", "y", "cropSquare", "galleryMimeTypes", "([Ljava/lang/String;)Lcom/github/dhaval2404/imagepicker/ImagePicker$Builder;", "galleryOnly", "getBundle", "Landroid/os/Bundle;", "maxResultSize", "width", "height", "provider", "file", "Ljava/io/File;", "path", "setDismissListener", "listener", "Lkotlin/Function0;", "setImageProviderInterceptor", "interceptor", "showImageProviderDialog", "reqCode", "start", "startActivity", "imagepicker_release"})
    public static final class Builder {
        private Fragment fragment;
        private ImageProvider imageProvider;
        private String[] mimeTypes;
        private float cropX;
        private float cropY;
        private boolean crop;
        private int maxWidth;
        private int maxHeight;
        private long maxSize;
        private Function1<? super ImageProvider, Unit> imageProviderInterceptor;
        private DismissListener dismissListener;
        private String saveDir;
        private final Activity activity;

        @NotNull
        public final Builder provider(@NotNull ImageProvider imageProvider) {
            Intrinsics.checkNotNullParameter((Object)((Object)imageProvider), (String)"imageProvider");
            this.imageProvider = imageProvider;
            return this;
        }

        @NotNull
        public final Builder cameraOnly() {
            this.imageProvider = ImageProvider.CAMERA;
            return this;
        }

        @NotNull
        public final Builder galleryOnly() {
            this.imageProvider = ImageProvider.GALLERY;
            return this;
        }

        @NotNull
        public final Builder galleryMimeTypes(@NotNull String[] mimeTypes) {
            Intrinsics.checkNotNullParameter((Object)mimeTypes, (String)"mimeTypes");
            this.mimeTypes = mimeTypes;
            return this;
        }

        @NotNull
        public final Builder crop(float x, float y) {
            this.cropX = x;
            this.cropY = y;
            return this.crop();
        }

        @NotNull
        public final Builder crop() {
            this.crop = true;
            return this;
        }

        @NotNull
        public final Builder cropSquare() {
            return this.crop(1.0f, 1.0f);
        }

        @NotNull
        public final Builder maxResultSize(int width, int height) {
            this.maxWidth = width;
            this.maxHeight = height;
            return this;
        }

        @NotNull
        public final Builder compress(int maxSize) {
            this.maxSize = (long)maxSize * 1024L;
            return this;
        }

        @NotNull
        public final Builder saveDir(@NotNull String path) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            this.saveDir = path;
            return this;
        }

        @NotNull
        public final Builder saveDir(@NotNull File file) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            this.saveDir = file.getAbsolutePath();
            return this;
        }

        @NotNull
        public final Builder setImageProviderInterceptor(@NotNull Function1<? super ImageProvider, Unit> interceptor) {
            Intrinsics.checkNotNullParameter(interceptor, (String)"interceptor");
            this.imageProviderInterceptor = interceptor;
            return this;
        }

        @NotNull
        public final Builder setDismissListener(@NotNull DismissListener listener) {
            Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
            this.dismissListener = listener;
            return this;
        }

        @NotNull
        public final Builder setDismissListener(@NotNull Function0<Unit> listener) {
            Intrinsics.checkNotNullParameter(listener, (String)"listener");
            this.dismissListener = new DismissListener(listener){
                final /* synthetic */ Function0 $listener;

                public void onDismiss() {
                    this.$listener.invoke();
                }
                {
                    this.$listener = $captured_local_variable$0;
                }
            };
            return this;
        }

        public final void start() {
            this.start(2404);
        }

        public final void start(int reqCode) {
            if (this.imageProvider == ImageProvider.BOTH) {
                this.showImageProviderDialog(reqCode);
            } else {
                this.startActivity(reqCode);
            }
        }

        private final Intent createIntent() {
            Intent intent = new Intent((Context)this.activity, ImagePickerActivity.class);
            intent.putExtras(this.getBundle());
            return intent;
        }

        public final void createIntent(@NotNull Function1<? super Intent, Unit> onResult) {
            Intrinsics.checkNotNullParameter(onResult, (String)"onResult");
            if (this.imageProvider == ImageProvider.BOTH) {
                DialogHelper.INSTANCE.showChooseAppDialog((Context)this.activity, new ResultListener<ImageProvider>(this, onResult){
                    final /* synthetic */ Builder this$0;
                    final /* synthetic */ Function1 $onResult;

                    public void onResult(@Nullable ImageProvider t) {
                        block1: {
                            ImageProvider imageProvider = t;
                            if (imageProvider == null) break block1;
                            ImageProvider imageProvider2 = imageProvider;
                            boolean bl = false;
                            boolean bl2 = false;
                            ImageProvider it = imageProvider2;
                            boolean bl3 = false;
                            Builder.access$setImageProvider$p(this.this$0, it);
                            Function1 function1 = Builder.access$getImageProviderInterceptor$p(this.this$0);
                            if (function1 != null) {
                                Unit cfr_ignored_0 = (Unit)function1.invoke((Object)((Object)Builder.access$getImageProvider$p(this.this$0)));
                            }
                            this.$onResult.invoke((Object)Builder.access$createIntent(this.this$0));
                        }
                    }
                    {
                        this.this$0 = this$0;
                        this.$onResult = $captured_local_variable$1;
                    }
                }, this.dismissListener);
            } else {
                onResult.invoke((Object)this.createIntent());
            }
        }

        private final void showImageProviderDialog(int reqCode) {
            DialogHelper.INSTANCE.showChooseAppDialog((Context)this.activity, new ResultListener<ImageProvider>(this, reqCode){
                final /* synthetic */ Builder this$0;
                final /* synthetic */ int $reqCode;

                public void onResult(@Nullable ImageProvider t) {
                    block1: {
                        ImageProvider imageProvider = t;
                        if (imageProvider == null) break block1;
                        ImageProvider imageProvider2 = imageProvider;
                        boolean bl = false;
                        boolean bl2 = false;
                        ImageProvider it = imageProvider2;
                        boolean bl3 = false;
                        Builder.access$setImageProvider$p(this.this$0, it);
                        Function1 function1 = Builder.access$getImageProviderInterceptor$p(this.this$0);
                        if (function1 != null) {
                            Unit cfr_ignored_0 = (Unit)function1.invoke((Object)((Object)Builder.access$getImageProvider$p(this.this$0)));
                        }
                        Builder.access$startActivity(this.this$0, this.$reqCode);
                    }
                }
                {
                    this.this$0 = this$0;
                    this.$reqCode = $captured_local_variable$1;
                }
            }, this.dismissListener);
        }

        private final Bundle getBundle() {
            Bundle bundle = new Bundle();
            boolean bl = false;
            boolean bl2 = false;
            Bundle $this$apply = bundle;
            boolean bl3 = false;
            $this$apply.putSerializable(ImagePicker.EXTRA_IMAGE_PROVIDER, (Serializable)((Object)this.imageProvider));
            $this$apply.putStringArray(ImagePicker.EXTRA_MIME_TYPES, this.mimeTypes);
            $this$apply.putBoolean(ImagePicker.EXTRA_CROP, this.crop);
            $this$apply.putFloat(ImagePicker.EXTRA_CROP_X, this.cropX);
            $this$apply.putFloat(ImagePicker.EXTRA_CROP_Y, this.cropY);
            $this$apply.putInt(ImagePicker.EXTRA_MAX_WIDTH, this.maxWidth);
            $this$apply.putInt(ImagePicker.EXTRA_MAX_HEIGHT, this.maxHeight);
            $this$apply.putLong(ImagePicker.EXTRA_IMAGE_MAX_SIZE, this.maxSize);
            $this$apply.putString(ImagePicker.EXTRA_SAVE_DIRECTORY, this.saveDir);
            return bundle;
        }

        private final void startActivity(int reqCode) {
            Intent intent = new Intent((Context)this.activity, ImagePickerActivity.class);
            intent.putExtras(this.getBundle());
            if (this.fragment != null) {
                Fragment fragment = this.fragment;
                if (fragment != null) {
                    fragment.startActivityForResult(intent, reqCode);
                }
            } else {
                this.activity.startActivityForResult(intent, reqCode);
            }
        }

        public Builder(@NotNull Activity activity) {
            Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
            this.activity = activity;
            this.imageProvider = ImageProvider.BOTH;
            this.mimeTypes = new String[0];
        }

        public Builder(@NotNull Fragment fragment) {
            Intrinsics.checkNotNullParameter((Object)fragment, (String)"fragment");
            FragmentActivity fragmentActivity = fragment.requireActivity();
            Intrinsics.checkNotNullExpressionValue((Object)fragmentActivity, (String)"fragment.requireActivity()");
            this((Activity)fragmentActivity);
            this.fragment = fragment;
        }

        public static final /* synthetic */ ImageProvider access$getImageProvider$p(Builder $this) {
            return $this.imageProvider;
        }

        public static final /* synthetic */ void access$setImageProvider$p(Builder $this, ImageProvider imageProvider) {
            $this.imageProvider = imageProvider;
        }

        public static final /* synthetic */ Function1 access$getImageProviderInterceptor$p(Builder $this) {
            return $this.imageProviderInterceptor;
        }

        public static final /* synthetic */ void access$setImageProviderInterceptor$p(Builder $this, Function1 function1) {
            $this.imageProviderInterceptor = function1;
        }

        public static final /* synthetic */ Intent access$createIntent(Builder $this) {
            return $this.createIntent();
        }

        public static final /* synthetic */ void access$startActivity(Builder $this, int reqCode) {
            $this.startActivity(reqCode);
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0013\u001a\u00020\u00042\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0007J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0007J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u001bH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0011X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/github/dhaval2404/imagepicker/ImagePicker$Companion;", "", "()V", "EXTRA_CAMERA_DEVICE", "", "EXTRA_CROP", "EXTRA_CROP_X", "EXTRA_CROP_Y", "EXTRA_ERROR", "EXTRA_FILE_PATH", "EXTRA_IMAGE_MAX_SIZE", "EXTRA_IMAGE_PROVIDER", "EXTRA_MAX_HEIGHT", "EXTRA_MAX_WIDTH", "EXTRA_MIME_TYPES", "EXTRA_SAVE_DIRECTORY", "REQUEST_CODE", "", "RESULT_ERROR", "getError", "data", "Landroid/content/Intent;", "with", "Lcom/github/dhaval2404/imagepicker/ImagePicker$Builder;", "activity", "Landroid/app/Activity;", "fragment", "Landroidx/fragment/app/Fragment;", "imagepicker_release"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final Builder with(@NotNull Activity activity) {
            Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
            return new Builder(activity);
        }

        @JvmStatic
        @NotNull
        public final Builder with(@NotNull Fragment fragment) {
            Intrinsics.checkNotNullParameter((Object)fragment, (String)"fragment");
            return new Builder(fragment);
        }

        @JvmStatic
        @NotNull
        public final String getError(@Nullable Intent data) {
            String error;
            Intent intent = data;
            String string = error = intent != null ? intent.getStringExtra(ImagePicker.EXTRA_ERROR) : null;
            if (error != null) {
                return error;
            }
            return "Unknown Error!";
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

