/*
 * Decompiled with CFR 0.152.
 */
package com.github.dhaval2404.imagepicker.provider;

import android.content.Context;
import android.content.ContextWrapper;
import android.os.Bundle;
import android.os.Environment;
import com.github.dhaval2404.imagepicker.ImagePickerActivity;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nJ\b\u0010\u000b\u001a\u00020\fH\u0014J\u0012\u0010\r\u001a\u00020\f2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u000fH\u0016J\u0010\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0004J\u0010\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\nH\u0004J\b\u0010\u0016\u001a\u00020\fH\u0004R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0017"}, d2={"Lcom/github/dhaval2404/imagepicker/provider/BaseProvider;", "Landroid/content/ContextWrapper;", "activity", "Lcom/github/dhaval2404/imagepicker/ImagePickerActivity;", "(Lcom/github/dhaval2404/imagepicker/ImagePickerActivity;)V", "getActivity", "()Lcom/github/dhaval2404/imagepicker/ImagePickerActivity;", "getFileDir", "Ljava/io/File;", "path", "", "onFailure", "", "onRestoreInstanceState", "savedInstanceState", "Landroid/os/Bundle;", "onSaveInstanceState", "outState", "setError", "errorRes", "", "error", "setResultCancel", "imagepicker_release"})
public abstract class BaseProvider
extends ContextWrapper {
    @NotNull
    private final ImagePickerActivity activity;

    @NotNull
    public final File getFileDir(@Nullable String path) {
        File file;
        if (path != null) {
            file = new File(path);
        } else {
            File file2 = this.getExternalFilesDir(Environment.DIRECTORY_DCIM);
            if (file2 == null) {
                file2 = this.activity.getFilesDir();
            }
            file = file2;
            Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"getExternalFilesDir(Envi\u2026CIM) ?: activity.filesDir");
        }
        return file;
    }

    protected final void setError(@NotNull String error) {
        Intrinsics.checkNotNullParameter((Object)error, (String)"error");
        this.onFailure();
        this.activity.setError(error);
    }

    protected final void setError(int errorRes) {
        String string2 = this.getString(errorRes);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getString(errorRes)");
        this.setError(string2);
    }

    protected final void setResultCancel() {
        this.onFailure();
        this.activity.setResultCancel();
    }

    protected void onFailure() {
    }

    public void onSaveInstanceState(@NotNull Bundle outState) {
        Intrinsics.checkNotNullParameter((Object)outState, (String)"outState");
    }

    public void onRestoreInstanceState(@Nullable Bundle savedInstanceState) {
    }

    @NotNull
    protected final ImagePickerActivity getActivity() {
        return this.activity;
    }

    public BaseProvider(@NotNull ImagePickerActivity activity) {
        Intrinsics.checkNotNullParameter((Object)((Object)activity), (String)"activity");
        super((Context)activity);
        this.activity = activity;
    }
}

