/*
 * Decompiled with CFR 0.152.
 */
package com.github.dhaval2404.imagepicker.provider;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import androidx.core.app.ActivityCompat;
import com.github.dhaval2404.imagepicker.ImagePickerActivity;
import com.github.dhaval2404.imagepicker.R;
import com.github.dhaval2404.imagepicker.provider.BaseProvider;
import com.github.dhaval2404.imagepicker.util.FileUtil;
import com.github.dhaval2404.imagepicker.util.IntentUtils;
import com.github.dhaval2404.imagepicker.util.PermissionUtil;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 $2\u00020\u0001:\u0001$B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\b\u001a\u00020\tH\u0002J\u0006\u0010\n\u001a\u00020\tJ\u001b\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u00a2\u0006\u0002\u0010\u0010J\b\u0010\u0011\u001a\u00020\tH\u0002J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J \u0010\u0014\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00162\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019J\b\u0010\u001a\u001a\u00020\tH\u0014J\u000e\u0010\u001b\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\u0016J\u0012\u0010\u001c\u001a\u00020\t2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0016J\u0010\u0010\u001f\u001a\u00020\t2\u0006\u0010 \u001a\u00020\u001eH\u0016J\b\u0010!\u001a\u00020\tH\u0002J\b\u0010\"\u001a\u00020\tH\u0002J\u0006\u0010#\u001a\u00020\tR\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/github/dhaval2404/imagepicker/provider/CameraProvider;", "Lcom/github/dhaval2404/imagepicker/provider/BaseProvider;", "activity", "Lcom/github/dhaval2404/imagepicker/ImagePickerActivity;", "(Lcom/github/dhaval2404/imagepicker/ImagePickerActivity;)V", "mCameraFile", "Ljava/io/File;", "mFileDir", "checkPermission", "", "delete", "getRequiredPermission", "", "", "context", "Landroid/content/Context;", "(Landroid/content/Context;)[Ljava/lang/String;", "handleResult", "isPermissionGranted", "", "onActivityResult", "requestCode", "", "resultCode", "data", "Landroid/content/Intent;", "onFailure", "onRequestPermissionsResult", "onRestoreInstanceState", "savedInstanceState", "Landroid/os/Bundle;", "onSaveInstanceState", "outState", "requestPermission", "startCameraIntent", "startIntent", "Companion", "imagepicker_release"})
public final class CameraProvider
extends BaseProvider {
    private File mCameraFile;
    private final File mFileDir;
    private static final String STATE_CAMERA_FILE = "state.camera_file";
    private static final String[] REQUIRED_PERMISSIONS;
    private static final int CAMERA_INTENT_REQ_CODE = 4281;
    private static final int PERMISSION_INTENT_REQ_CODE = 4282;
    public static final Companion Companion;

    @Override
    public void onSaveInstanceState(@NotNull Bundle outState) {
        Intrinsics.checkNotNullParameter((Object)outState, (String)"outState");
        outState.putSerializable(STATE_CAMERA_FILE, (Serializable)this.mCameraFile);
    }

    @Override
    public void onRestoreInstanceState(@Nullable Bundle savedInstanceState) {
        Bundle bundle = savedInstanceState;
        this.mCameraFile = (File)(bundle != null ? bundle.getSerializable(STATE_CAMERA_FILE) : null);
    }

    public final void startIntent() {
        if (!IntentUtils.isCameraAppAvailable((Context)this)) {
            this.setError(R.string.error_camera_app_not_found);
            return;
        }
        this.checkPermission();
    }

    private final void checkPermission() {
        if (this.isPermissionGranted((Context)this)) {
            this.startCameraIntent();
        } else {
            this.requestPermission();
        }
    }

    private final void startCameraIntent() {
        File file;
        this.mCameraFile = file = FileUtil.getImageFile$default(FileUtil.INSTANCE, this.mFileDir, null, 2, null);
        if (file != null && file.exists()) {
            Intent cameraIntent = IntentUtils.getCameraIntent((Context)this, file);
            this.getActivity().startActivityForResult(cameraIntent, 4281);
        } else {
            this.setError(R.string.error_failed_to_create_camera_image_file);
        }
    }

    private final void requestPermission() {
        ActivityCompat.requestPermissions((Activity)((Activity)this.getActivity()), (String[])this.getRequiredPermission((Context)this.getActivity()), (int)4282);
    }

    private final boolean isPermissionGranted(Context context) {
        boolean bl;
        block1: {
            String[] $this$none$iv = this.getRequiredPermission(context);
            boolean $i$f$none = false;
            String[] stringArray = $this$none$iv;
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String element$iv;
                String it = element$iv = stringArray[i];
                boolean bl2 = false;
                if (!(!PermissionUtil.INSTANCE.isPermissionGranted(context, it))) continue;
                bl = false;
                break block1;
            }
            bl = true;
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    private final String[] getRequiredPermission(Context context) {
        void $this$filterTo$iv$iv;
        String[] $this$filter$iv = REQUIRED_PERMISSIONS;
        boolean $i$f$filter = false;
        String[] stringArray = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        void var7_7 = $this$filterTo$iv$iv;
        int n = ((void)var7_7).length;
        for (int i = 0; i < n; ++i) {
            void element$iv$iv;
            void it = element$iv$iv = var7_7[i];
            boolean bl = false;
            if (!PermissionUtil.INSTANCE.isPermissionInManifest(context, (String)it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Collection $this$toTypedArray$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray2 = thisCollection$iv.toArray(new String[0]);
        if (stringArray2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        return stringArray2;
    }

    public final void onRequestPermissionsResult(int requestCode) {
        if (requestCode == 4282) {
            if (this.isPermissionGranted((Context)this)) {
                this.startIntent();
            } else {
                String string2 = this.getString(R.string.permission_camera_denied);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getString(R.string.permission_camera_denied)");
                String error = string2;
                this.setError(error);
            }
        }
    }

    public final void onActivityResult(int requestCode, int resultCode, @Nullable Intent data) {
        if (requestCode == 4281) {
            if (resultCode == -1) {
                this.handleResult();
            } else {
                this.setResultCancel();
            }
        }
    }

    private final void handleResult() {
        ImagePickerActivity imagePickerActivity = this.getActivity();
        Uri uri = Uri.fromFile((File)this.mCameraFile);
        Intrinsics.checkNotNullExpressionValue((Object)uri, (String)"Uri.fromFile(mCameraFile)");
        imagePickerActivity.setImage(uri);
    }

    @Override
    protected void onFailure() {
        this.delete();
    }

    public final void delete() {
        File file = this.mCameraFile;
        if (file != null) {
            file.delete();
        }
        this.mCameraFile = null;
    }

    public CameraProvider(@NotNull ImagePickerActivity activity) {
        Intrinsics.checkNotNullParameter((Object)((Object)activity), (String)"activity");
        super(activity);
        Intent intent = activity.getIntent();
        Intrinsics.checkNotNullExpressionValue((Object)intent, (String)"activity.intent");
        Bundle bundle = intent.getExtras();
        if (bundle == null) {
            bundle = new Bundle();
        }
        Intrinsics.checkNotNullExpressionValue((Object)bundle, (String)"activity.intent.extras ?: Bundle()");
        Bundle bundle2 = bundle;
        String fileDir = bundle2.getString("extra.save_directory");
        this.mFileDir = this.getFileDir(fileDir);
    }

    static {
        Companion = new Companion(null);
        REQUIRED_PERMISSIONS = new String[]{"android.permission.CAMERA"};
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\tR\u000e\u0010\n\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/github/dhaval2404/imagepicker/provider/CameraProvider$Companion;", "", "()V", "CAMERA_INTENT_REQ_CODE", "", "PERMISSION_INTENT_REQ_CODE", "REQUIRED_PERMISSIONS", "", "", "[Ljava/lang/String;", "STATE_CAMERA_FILE", "imagepicker_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

