/*
 * Decompiled with CFR 0.152.
 */
package com.github.dhaval2404.imagepicker.provider;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import androidx.core.app.ActivityCompat;
import com.github.dhaval2404.imagepicker.ImagePickerActivity;
import com.github.dhaval2404.imagepicker.R;
import com.github.dhaval2404.imagepicker.provider.BaseProvider;
import com.github.dhaval2404.imagepicker.util.FileUtil;
import com.github.dhaval2404.imagepicker.util.IntentUtils;
import com.github.dhaval2404.imagepicker.util.PermissionUtil;
import java.io.File;
import java.io.Serializable;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000  2\u00020\u0001:\u0001 B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\n\u001a\u00020\u000bH\u0002J\u0012\u0010\f\u001a\u00020\u000b2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0002J\u0010\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J \u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00142\b\u0010\r\u001a\u0004\u0018\u00010\u000eJ\b\u0010\u0016\u001a\u00020\u000bH\u0014J\u000e\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u0014J\u0012\u0010\u0018\u001a\u00020\u000b2\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\u001c\u001a\u00020\u001aH\u0016J\b\u0010\u001d\u001a\u00020\u000bH\u0002J\b\u0010\u001e\u001a\u00020\u000bH\u0002J\u0006\u0010\u001f\u001a\u00020\u000bR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/github/dhaval2404/imagepicker/provider/CameraProvider;", "Lcom/github/dhaval2404/imagepicker/provider/BaseProvider;", "activity", "Lcom/github/dhaval2404/imagepicker/ImagePickerActivity;", "(Lcom/github/dhaval2404/imagepicker/ImagePickerActivity;)V", "mAskCameraPermission", "", "mCameraFile", "Ljava/io/File;", "mFileDir", "checkPermission", "", "handleResult", "data", "Landroid/content/Intent;", "isPermissionGranted", "context", "Landroid/content/Context;", "onActivityResult", "requestCode", "", "resultCode", "onFailure", "onRequestPermissionsResult", "onRestoreInstanceState", "savedInstanceState", "Landroid/os/Bundle;", "onSaveInstanceState", "outState", "requestPermission", "startCameraIntent", "startIntent", "Companion", "imagepicker_release"})
public final class CameraProvider
extends BaseProvider {
    private File mCameraFile;
    private final boolean mAskCameraPermission;
    private File mFileDir;
    private static final String STATE_CAMERA_FILE = "state.camera_file";
    private static final String[] REQUIRED_PERMISSIONS;
    private static final String[] REQUIRED_PERMISSIONS_EXTENDED;
    private static final int CAMERA_INTENT_REQ_CODE = 4281;
    private static final int PERMISSION_INTENT_REQ_CODE = 4282;
    public static final Companion Companion;

    @Override
    public void onSaveInstanceState(@NotNull Bundle outState) {
        Intrinsics.checkParameterIsNotNull((Object)outState, (String)"outState");
        outState.putSerializable(STATE_CAMERA_FILE, (Serializable)this.mCameraFile);
    }

    @Override
    public void onRestoreInstanceState(@Nullable Bundle savedInstanceState) {
        Bundle bundle = savedInstanceState;
        this.mCameraFile = (File)(bundle != null ? bundle.getSerializable(STATE_CAMERA_FILE) : null);
    }

    public final void startIntent() {
        if (!IntentUtils.INSTANCE.isCameraAppAvailable((Context)this)) {
            this.setError(R.string.error_camera_app_not_found);
            return;
        }
        this.checkPermission();
    }

    private final void checkPermission() {
        if (this.isPermissionGranted((Context)this)) {
            this.startCameraIntent();
        } else {
            this.requestPermission();
        }
    }

    private final void startCameraIntent() {
        File file;
        this.mCameraFile = file = FileUtil.getImageFile$default(FileUtil.INSTANCE, this.mFileDir, null, 2, null);
        if (file != null && file.exists()) {
            Intent cameraIntent = IntentUtils.INSTANCE.getCameraIntent((Context)this, file);
            this.getActivity().startActivityForResult(cameraIntent, 4281);
        } else {
            this.setError(R.string.error_failed_to_create_camera_image_file);
        }
    }

    public final void onRequestPermissionsResult(int requestCode) {
        if (requestCode == 4282) {
            if (this.isPermissionGranted((Context)this)) {
                this.startCameraIntent();
            } else {
                int errorRes = this.mAskCameraPermission ? R.string.permission_camera_extended_denied : R.string.permission_camera_denied;
                String string2 = this.getString(errorRes);
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"getString(errorRes)");
                this.setError(string2);
            }
        }
    }

    public final void onActivityResult(int requestCode, int resultCode, @Nullable Intent data) {
        if (requestCode == 4281) {
            if (resultCode == -1) {
                this.handleResult(data);
            } else {
                this.setResultCancel();
            }
        }
    }

    private final void handleResult(Intent data) {
        ImagePickerActivity imagePickerActivity = this.getActivity();
        File file = this.mCameraFile;
        if (file == null) {
            Intrinsics.throwNpe();
        }
        imagePickerActivity.setImage(file);
    }

    @Override
    protected void onFailure() {
        block0: {
            File file = this.mCameraFile;
            if (file == null) break block0;
            file.delete();
        }
    }

    private final void requestPermission() {
        if (this.mAskCameraPermission) {
            ActivityCompat.requestPermissions((Activity)((Activity)this.getActivity()), (String[])REQUIRED_PERMISSIONS_EXTENDED, (int)4282);
        } else {
            ActivityCompat.requestPermissions((Activity)((Activity)this.getActivity()), (String[])REQUIRED_PERMISSIONS, (int)4282);
        }
    }

    private final boolean isPermissionGranted(Context context) {
        if (this.mAskCameraPermission && PermissionUtil.INSTANCE.isPermissionGranted(context, REQUIRED_PERMISSIONS_EXTENDED)) {
            return true;
        }
        return !this.mAskCameraPermission && PermissionUtil.INSTANCE.isPermissionGranted(context, REQUIRED_PERMISSIONS);
    }

    public CameraProvider(@NotNull ImagePickerActivity activity) {
        block1: {
            String fileDir;
            Intrinsics.checkParameterIsNotNull((Object)((Object)activity), (String)"activity");
            super(activity);
            this.mAskCameraPermission = PermissionUtil.INSTANCE.isPermissionInManifest((Context)this, "android.permission.CAMERA");
            Intent intent = activity.getIntent();
            Intrinsics.checkExpressionValueIsNotNull((Object)intent, (String)"activity.intent");
            Bundle bundle = intent.getExtras();
            if (bundle == null) {
                bundle = new Bundle();
            }
            Bundle bundle2 = bundle;
            String string2 = fileDir = bundle2.getString("extra.save_directory");
            if (string2 == null) break block1;
            String string3 = string2;
            boolean bl = false;
            boolean bl2 = false;
            String it = string3;
            boolean bl3 = false;
            this.mFileDir = new File(it);
        }
    }

    static {
        Companion = new Companion(null);
        REQUIRED_PERMISSIONS = new String[]{"android.permission.WRITE_EXTERNAL_STORAGE"};
        REQUIRED_PERMISSIONS_EXTENDED = new String[]{"android.permission.WRITE_EXTERNAL_STORAGE", "android.permission.CAMERA"};
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\tR\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\tR\u000e\u0010\u000b\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/github/dhaval2404/imagepicker/provider/CameraProvider$Companion;", "", "()V", "CAMERA_INTENT_REQ_CODE", "", "PERMISSION_INTENT_REQ_CODE", "REQUIRED_PERMISSIONS", "", "", "[Ljava/lang/String;", "REQUIRED_PERMISSIONS_EXTENDED", "STATE_CAMERA_FILE", "imagepicker_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

