/*
 * Decompiled with CFR 0.152.
 */
package com.github.dhaval2404.imagepicker.util;

import android.os.Environment;
import android.os.StatFs;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0002J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0004J \u0010\b\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000bJ\b\u0010\f\u001a\u00020\u000bH\u0002\u00a8\u0006\r"}, d2={"Lcom/github/dhaval2404/imagepicker/util/FileUtil;", "", "()V", "getCameraDirectory", "Ljava/io/File;", "getFreeSpace", "", "file", "getImageFile", "dir", "extension", "", "getTimestamp", "imagepicker_release"})
public final class FileUtil {
    public static final FileUtil INSTANCE;

    @Nullable
    public final File getImageFile(@Nullable File dir, @Nullable String extension) {
        try {
            File storageDir;
            String string2 = extension;
            if (string2 == null) {
                string2 = ".jpg";
            }
            String ext = string2;
            String imageFileName = "IMG_" + this.getTimestamp() + ext;
            File file = dir;
            if (file == null) {
                file = storageDir = this.getCameraDirectory();
            }
            if (!storageDir.exists()) {
                storageDir.mkdirs();
            }
            File file2 = new File(storageDir, imageFileName);
            file2.createNewFile();
            return file2;
        }
        catch (IOException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static /* synthetic */ File getImageFile$default(FileUtil fileUtil, File file, String string2, int n, Object object) {
        if ((n & 1) != 0) {
            file = null;
        }
        if ((n & 2) != 0) {
            string2 = null;
        }
        return fileUtil.getImageFile(file, string2);
    }

    private final File getCameraDirectory() {
        File dir = Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_DCIM);
        return new File(dir, "Camera");
    }

    private final String getTimestamp() {
        String timeFormat = "yyyyMMdd_HHmmssSSS";
        String string2 = new SimpleDateFormat(timeFormat, Locale.getDefault()).format(new Date());
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"SimpleDateFormat(timeFor\u2026Default()).format(Date())");
        return string2;
    }

    public final long getFreeSpace(@NotNull File file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        StatFs stat = new StatFs(file.getPath());
        long availBlocks = stat.getAvailableBlocksLong();
        long blockSize = stat.getBlockSizeLong();
        return availBlocks * blockSize;
    }

    private FileUtil() {
    }

    static {
        FileUtil fileUtil;
        INSTANCE = fileUtil = new FileUtil();
    }
}

