/*
 * Decompiled with CFR 0.152.
 */
package com.github.dhaval2404.imagepicker.provider;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import androidx.core.app.ActivityCompat;
import com.github.dhaval2404.imagepicker.ImagePickerActivity;
import com.github.dhaval2404.imagepicker.R;
import com.github.dhaval2404.imagepicker.provider.BaseProvider;
import com.github.dhaval2404.imagepicker.util.FileUtil;
import com.github.dhaval2404.imagepicker.util.IntentUtils;
import com.github.dhaval2404.imagepicker.util.PermissionUtil;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0007\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0007\u001a\u00020\bH\u0002J\u0012\u0010\t\u001a\u00020\b2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0002J \u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\b\u0010\n\u001a\u0004\u0018\u00010\u000bJ\b\u0010\u0010\u001a\u00020\bH\u0014J\u000e\u0010\u0011\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000eJ\b\u0010\u0012\u001a\u00020\bH\u0002J\u0006\u0010\u0013\u001a\u00020\bR\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/github/dhaval2404/imagepicker/provider/CameraProvider;", "Lcom/github/dhaval2404/imagepicker/provider/BaseProvider;", "activity", "Lcom/github/dhaval2404/imagepicker/ImagePickerActivity;", "(Lcom/github/dhaval2404/imagepicker/ImagePickerActivity;)V", "mCameraFile", "Ljava/io/File;", "checkPermission", "", "handleResult", "data", "Landroid/content/Intent;", "onActivityResult", "requestCode", "", "resultCode", "onFailure", "onRequestPermissionsResult", "startCameraIntent", "startIntent", "Companion", "imagepicker_release"})
public final class CameraProvider
extends BaseProvider {
    private File mCameraFile;
    private static final String[] REQUIRED_PERMISSIONS;
    private static final int CAMERA_INTENT_REQ_CODE = 4281;
    private static final int PERMISSION_INTENT_REQ_CODE = 4282;
    public static final Companion Companion;

    public final void startIntent() {
        this.checkPermission();
    }

    private final void checkPermission() {
        if (!PermissionUtil.INSTANCE.isPermissionGranted((Context)this, REQUIRED_PERMISSIONS)) {
            ActivityCompat.requestPermissions((Activity)((Activity)this.getActivity()), (String[])REQUIRED_PERMISSIONS, (int)4282);
        } else {
            this.startCameraIntent();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private final void startCameraIntent() {
        this.mCameraFile = FileUtil.getImageFile$default(FileUtil.INSTANCE, null, null, 3, null);
        if (this.mCameraFile != null) {
            File file = this.mCameraFile;
            if (file == null) {
                Intrinsics.throwNpe();
            }
            if (file.exists()) {
                Context context = (Context)this;
                File file2 = this.mCameraFile;
                if (file2 == null) {
                    Intrinsics.throwNpe();
                }
                Intent cameraIntent = IntentUtils.INSTANCE.getCameraIntent(context, file2);
                this.getActivity().startActivityForResult(cameraIntent, 4281);
                return;
            }
        }
        this.setError(R.string.error_failed_to_create_camera_image_file);
    }

    public final void onRequestPermissionsResult(int requestCode) {
        if (requestCode == 4282) {
            if (PermissionUtil.INSTANCE.isPermissionGranted((Context)this, REQUIRED_PERMISSIONS)) {
                this.startCameraIntent();
            } else {
                String error;
                String string2 = error = this.getString(R.string.permission_camera_denied);
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"error");
                this.setError(string2);
            }
        }
    }

    public final void onActivityResult(int requestCode, int resultCode, @Nullable Intent data) {
        if (requestCode == 4281) {
            if (resultCode == -1) {
                this.handleResult(data);
            } else {
                this.setResultCancel();
            }
        }
    }

    private final void handleResult(Intent data) {
        ImagePickerActivity imagePickerActivity = this.getActivity();
        File file = this.mCameraFile;
        if (file == null) {
            Intrinsics.throwNpe();
        }
        imagePickerActivity.setImage(file);
    }

    @Override
    protected void onFailure() {
        block0: {
            File file = this.mCameraFile;
            if (file == null) break block0;
            file.delete();
        }
    }

    public CameraProvider(@NotNull ImagePickerActivity activity) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)activity), (String)"activity");
        super(activity);
    }

    static {
        Companion = new Companion(null);
        REQUIRED_PERMISSIONS = new String[]{"android.permission.WRITE_EXTERNAL_STORAGE"};
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\t\u00a8\u0006\n"}, d2={"Lcom/github/dhaval2404/imagepicker/provider/CameraProvider$Companion;", "", "()V", "CAMERA_INTENT_REQ_CODE", "", "PERMISSION_INTENT_REQ_CODE", "REQUIRED_PERMISSIONS", "", "", "[Ljava/lang/String;", "imagepicker_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

