/*
 * Decompiled with CFR 0.152.
 */
package com.github.dhaval2404.imagepicker.provider;

import android.annotation.SuppressLint;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.os.AsyncTask;
import android.os.Bundle;
import android.util.Log;
import com.github.dhaval2404.imagepicker.ImagePickerActivity;
import com.github.dhaval2404.imagepicker.R;
import com.github.dhaval2404.imagepicker.provider.BaseProvider;
import com.github.dhaval2404.imagepicker.util.FileUtil;
import com.github.dhaval2404.imagepicker.util.ImageUtil;
import java.io.File;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0004\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\f\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\r\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\bH\u0002J\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000bJ\u001b\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\b0\u00122\u0006\u0010\r\u001a\u00020\u000bH\u0002\u00a2\u0006\u0002\u0010\u0013J\u0010\u0010\u0014\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000bH\u0002J\u0006\u0010\u0015\u001a\u00020\u0016J\u000e\u0010\u0017\u001a\u00020\u00162\u0006\u0010\r\u001a\u00020\u000bJ\u0014\u0010\u0018\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00120\u0019H\u0002J\u0012\u0010\u001a\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\r\u001a\u00020\u000bH\u0002J\u0010\u0010\u001b\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000bH\u0003R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/github/dhaval2404/imagepicker/provider/CompressionProvider;", "Lcom/github/dhaval2404/imagepicker/provider/BaseProvider;", "activity", "Lcom/github/dhaval2404/imagepicker/ImagePickerActivity;", "(Lcom/github/dhaval2404/imagepicker/ImagePickerActivity;)V", "mMaxFileSize", "", "mMaxHeight", "", "mMaxWidth", "mOriginalFile", "Ljava/io/File;", "applyCompression", "file", "attempt", "compress", "", "getImageSize", "", "(Ljava/io/File;)[Ljava/lang/Integer;", "handleResult", "isCompressEnabled", "", "isCompressionRequired", "resolutionList", "", "startCompression", "startCompressionWorker", "Companion", "imagepicker_release"})
public final class CompressionProvider
extends BaseProvider {
    private final int mMaxWidth;
    private final int mMaxHeight;
    private final long mMaxFileSize;
    private File mOriginalFile;
    private static final String TAG;
    public static final Companion Companion;

    public final boolean isCompressEnabled() {
        return this.mMaxFileSize > 0L;
    }

    public final boolean isCompressionRequired(@NotNull File file) {
        boolean status;
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        boolean bl = status = this.isCompressEnabled() && file.length() > this.mMaxFileSize;
        if (!status && this.mMaxWidth > 0 && this.mMaxHeight > 0) {
            Integer[] sizes = this.getImageSize(file);
            return sizes[0] > this.mMaxWidth || sizes[1] > this.mMaxHeight;
        }
        return status;
    }

    public final void compress(@NotNull File file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        this.startCompressionWorker(file);
    }

    @SuppressLint(value={"StaticFieldLeak"})
    private final void startCompressionWorker(File file) {
        this.mOriginalFile = file;
        new AsyncTask<File, Void, File>(this){
            final /* synthetic */ CompressionProvider this$0;

            @Nullable
            protected File doInBackground(File ... params) {
                Intrinsics.checkParameterIsNotNull((Object)params, (String)"params");
                return CompressionProvider.access$startCompression(this.this$0, params[0]);
            }

            protected void onPostExecute(@Nullable File file) {
                super.onPostExecute((Object)file);
                if (file != null) {
                    CompressionProvider.access$handleResult(this.this$0, file);
                } else {
                    this.this$0.setError(R.string.error_failed_to_compress_image);
                }
            }
            {
                this.this$0 = $outer;
            }
        }.execute((Object[])new File[]{file});
    }

    private final File startCompression(File file) {
        File newFile = null;
        int attempt = 0;
        do {
            File file2 = newFile;
            if (file2 != null) {
                file2.delete();
            }
            newFile = this.applyCompression(file, attempt);
            if (newFile == null) {
                return attempt > 0 ? this.applyCompression(file, attempt - 1) : null;
            }
            ++attempt;
        } while (this.isCompressionRequired(newFile));
        return newFile;
    }

    private final File applyCompression(File file, int attempt) {
        File file2;
        File compressFile;
        List<Integer[]> resList = this.resolutionList();
        if (attempt >= resList.size()) {
            return null;
        }
        Integer[] resolution = resList.get(attempt);
        int maxWidth = resolution[0];
        int maxHeight = resolution[1];
        if (this.mMaxWidth > 0 && this.mMaxHeight > 0 && (maxWidth > this.mMaxWidth || maxHeight > this.mMaxHeight)) {
            maxHeight = this.mMaxHeight;
            maxWidth = this.mMaxWidth;
        }
        Log.d((String)TAG, (String)("maxWidth:" + maxWidth + ", maxHeight:" + maxHeight));
        Bitmap.CompressFormat format = Bitmap.CompressFormat.JPEG;
        int quality = 90;
        String string2 = file.getAbsolutePath();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"file.absolutePath");
        if (StringsKt.endsWith$default((String)string2, (String)".png", (boolean)false, (int)2, null)) {
            format = Bitmap.CompressFormat.PNG;
            quality = 100;
        }
        if ((compressFile = FileUtil.INSTANCE.getCameraFile()) != null) {
            float f = maxWidth;
            float f2 = maxHeight;
            String string3 = compressFile.getAbsolutePath();
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"compressFile.absolutePath");
            file2 = ImageUtil.INSTANCE.compressImage(file, f, f2, format, quality, string3);
        } else {
            file2 = null;
        }
        return file2;
    }

    private final List<Integer[]> resolutionList() {
        return CollectionsKt.listOf((Object[])new Integer[][]{{2580, 1944}, {2080, 1542}, {1600, 1200}, {1392, 1024}, {640, 480}, {320, 240}, {160, 120}, {80, 60}, {40, 30}});
    }

    private final void handleResult(File file) {
        this.getActivity().setCompressedImage(file);
    }

    private final Integer[] getImageSize(File file) {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeFile((String)file.getAbsolutePath(), (BitmapFactory.Options)options);
        return new Integer[]{options.outWidth, options.outHeight};
    }

    public CompressionProvider(@NotNull ImagePickerActivity activity) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)activity), (String)"activity");
        super(activity);
        Intent intent = activity.getIntent();
        Intrinsics.checkExpressionValueIsNotNull((Object)intent, (String)"activity.intent");
        Bundle bundle = intent.getExtras();
        if (bundle == null) {
            Intrinsics.throwNpe();
        }
        Bundle bundle2 = bundle;
        this.mMaxWidth = bundle2.getInt("extra.max_width", 0);
        this.mMaxHeight = bundle2.getInt("extra.max_height", 0);
        this.mMaxFileSize = bundle2.getLong("extra.image_max_size", 0L);
    }

    static {
        Companion = new Companion(null);
        TAG = CompressionProvider.class.getSimpleName();
    }

    public static final /* synthetic */ File access$startCompression(CompressionProvider $this, File file) {
        return $this.startCompression(file);
    }

    public static final /* synthetic */ void access$handleResult(CompressionProvider $this, File file) {
        $this.handleResult(file);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/github/dhaval2404/imagepicker/provider/CompressionProvider$Companion;", "", "()V", "TAG", "", "kotlin.jvm.PlatformType", "imagepicker_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

