/*
 * Decompiled with CFR 0.152.
 */
package com.github.dhaval2404.imagepicker;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentActivity;
import com.github.dhaval2404.imagepicker.ImagePickerActivity;
import com.github.dhaval2404.imagepicker.constant.ImageProvider;
import com.github.dhaval2404.imagepicker.listener.ResultListener;
import com.github.dhaval2404.imagepicker.util.DialogHelper;
import java.io.File;
import java.io.Serializable;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\u0018\u0000 \u00042\u00020\u0001:\u0002\u0003\u0004B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0005"}, d2={"Lcom/github/dhaval2404/imagepicker/ImagePicker;", "", "()V", "Builder", "Companion", "imagepicker_release"})
public final class ImagePicker {
    public static final int REQUEST_CODE = 2404;
    public static final int RESULT_ERROR = 64;
    @NotNull
    public static final String EXTRA_IMAGE_PROVIDER = "extra.image_provider";
    @NotNull
    public static final String EXTRA_IMAGE_MAX_SIZE = "extra.image_max_size";
    @NotNull
    public static final String EXTRA_CROP_X = "extra.crop_x";
    @NotNull
    public static final String EXTRA_CROP_Y = "extra.crop_y";
    @NotNull
    public static final String EXTRA_MAX_WIDTH = "extra.max_width";
    @NotNull
    public static final String EXTRA_MAX_HEIGHT = "extra.max_height";
    @NotNull
    public static final String EXTRA_ERROR = "extra.error";
    @NotNull
    public static final String EXTRA_FILE_PATH = "extra.file_path";
    public static final Companion Companion = new Companion(null);

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\f\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\r\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0006\u0010\u0012\u001a\u00020\u0000J\u000e\u0010\u0013\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\u000eJ\u0016\u0010\u0014\u001a\u00020\u00002\u0006\u0010\u0015\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\tJ\u0006\u0010\u0017\u001a\u00020\u0000J\u0006\u0010\u0018\u001a\u00020\u0000J\u0016\u0010\u0019\u001a\u00020\u00002\u0006\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u001b\u001a\u00020\u000eJ\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u000eH\u0002J\u0006\u0010\u001f\u001a\u00020\u001dJ\u000e\u0010\u001f\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u000eJ\u0010\u0010 \u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u000eH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/github/dhaval2404/imagepicker/ImagePicker$Builder;", "", "fragment", "Landroidx/fragment/app/Fragment;", "(Landroidx/fragment/app/Fragment;)V", "activity", "Landroid/app/Activity;", "(Landroid/app/Activity;)V", "cropX", "", "cropY", "imageProvider", "Lcom/github/dhaval2404/imagepicker/constant/ImageProvider;", "maxHeight", "", "maxSize", "", "maxWidth", "cameraOnly", "compress", "crop", "x", "y", "cropSquare", "galleryOnly", "maxResultSize", "width", "height", "showImageProviderDialog", "", "reqCode", "start", "startActivity", "imagepicker_release"})
    public static final class Builder {
        private Fragment fragment;
        private ImageProvider imageProvider;
        private float cropX;
        private float cropY;
        private int maxWidth;
        private int maxHeight;
        private long maxSize;
        private final Activity activity;

        @NotNull
        public final Builder cameraOnly() {
            this.imageProvider = ImageProvider.CAMERA;
            return this;
        }

        @NotNull
        public final Builder galleryOnly() {
            this.imageProvider = ImageProvider.GALLERY;
            return this;
        }

        @NotNull
        public final Builder crop(float x, float y) {
            this.cropX = x;
            this.cropY = y;
            return this;
        }

        @NotNull
        public final Builder cropSquare() {
            return this.crop(1.0f, 1.0f);
        }

        @NotNull
        public final Builder maxResultSize(int width, int height) {
            this.maxWidth = width;
            this.maxHeight = height;
            return this;
        }

        @NotNull
        public final Builder compress(int maxSize) {
            this.maxSize = (long)maxSize * 1024L;
            return this;
        }

        public final void start() {
            this.start(2404);
        }

        public final void start(int reqCode) {
            if (this.imageProvider == ImageProvider.BOTH) {
                this.showImageProviderDialog(reqCode);
            } else {
                this.startActivity(reqCode);
            }
        }

        private final void showImageProviderDialog(int reqCode) {
            DialogHelper.INSTANCE.showChooseAppDialog((Context)this.activity, new ResultListener<ImageProvider>(this, reqCode){
                final /* synthetic */ Builder this$0;
                final /* synthetic */ int $reqCode;

                public void onResult(@NotNull ImageProvider t) {
                    Intrinsics.checkParameterIsNotNull((Object)((Object)t), (String)"t");
                    Builder.access$setImageProvider$p(this.this$0, t);
                    Builder.access$startActivity(this.this$0, this.$reqCode);
                }
                {
                    this.this$0 = $outer;
                    this.$reqCode = $captured_local_variable$1;
                }
            });
        }

        private final void startActivity(int reqCode) {
            Bundle bundle = new Bundle();
            bundle.putSerializable(ImagePicker.EXTRA_IMAGE_PROVIDER, (Serializable)((Object)this.imageProvider));
            bundle.putFloat(ImagePicker.EXTRA_CROP_X, this.cropX);
            bundle.putFloat(ImagePicker.EXTRA_CROP_Y, this.cropY);
            bundle.putInt(ImagePicker.EXTRA_MAX_WIDTH, this.maxWidth);
            bundle.putInt(ImagePicker.EXTRA_MAX_HEIGHT, this.maxHeight);
            bundle.putLong(ImagePicker.EXTRA_IMAGE_MAX_SIZE, this.maxSize);
            Intent intent = new Intent((Context)this.activity, ImagePickerActivity.class);
            intent.putExtras(bundle);
            if (this.fragment != null) {
                Fragment fragment = this.fragment;
                if (fragment != null) {
                    fragment.startActivityForResult(intent, reqCode);
                }
            } else {
                this.activity.startActivityForResult(intent, reqCode);
            }
        }

        public Builder(@NotNull Activity activity) {
            Intrinsics.checkParameterIsNotNull((Object)activity, (String)"activity");
            this.activity = activity;
            this.imageProvider = ImageProvider.BOTH;
        }

        public Builder(@NotNull Fragment fragment) {
            Intrinsics.checkParameterIsNotNull((Object)fragment, (String)"fragment");
            FragmentActivity fragmentActivity = fragment.getActivity();
            if (fragmentActivity == null) {
                Intrinsics.throwNpe();
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)fragmentActivity, (String)"fragment.activity!!");
            this((Activity)fragmentActivity);
            this.fragment = fragment;
        }

        public static final /* synthetic */ ImageProvider access$getImageProvider$p(Builder $this) {
            return $this.imageProvider;
        }

        public static final /* synthetic */ void access$setImageProvider$p(Builder $this, ImageProvider imageProvider) {
            $this.imageProvider = imageProvider;
        }

        public static final /* synthetic */ void access$startActivity(Builder $this, int reqCode) {
            $this.startActivity(reqCode);
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000f\u001a\u00020\u00042\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u00132\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00042\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011J\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018J\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u001aR\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/github/dhaval2404/imagepicker/ImagePicker$Companion;", "", "()V", "EXTRA_CROP_X", "", "EXTRA_CROP_Y", "EXTRA_ERROR", "EXTRA_FILE_PATH", "EXTRA_IMAGE_MAX_SIZE", "EXTRA_IMAGE_PROVIDER", "EXTRA_MAX_HEIGHT", "EXTRA_MAX_WIDTH", "REQUEST_CODE", "", "RESULT_ERROR", "getError", "data", "Landroid/content/Intent;", "getFile", "Ljava/io/File;", "getFilePath", "with", "Lcom/github/dhaval2404/imagepicker/ImagePicker$Builder;", "activity", "Landroid/app/Activity;", "fragment", "Landroidx/fragment/app/Fragment;", "imagepicker_release"})
    public static final class Companion {
        @NotNull
        public final Builder with(@NotNull Activity activity) {
            Intrinsics.checkParameterIsNotNull((Object)activity, (String)"activity");
            return new Builder(activity);
        }

        @NotNull
        public final Builder with(@NotNull Fragment fragment) {
            Intrinsics.checkParameterIsNotNull((Object)fragment, (String)"fragment");
            return new Builder(fragment);
        }

        @NotNull
        public final String getError(@Nullable Intent data) {
            String error;
            Intent intent = data;
            String string = error = intent != null ? intent.getStringExtra(ImagePicker.EXTRA_ERROR) : null;
            if (error != null) {
                return error;
            }
            return "Unknown Error!";
        }

        @Nullable
        public final String getFilePath(@Nullable Intent data) {
            Intent intent = data;
            return intent != null ? intent.getStringExtra(ImagePicker.EXTRA_FILE_PATH) : null;
        }

        @Nullable
        public final File getFile(@Nullable Intent data) {
            String path = this.getFilePath(data);
            if (path != null) {
                return new File(path);
            }
            return null;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

