/*
 * Decompiled with CFR 0.152.
 */
package com.github.dfqin.grantor;

import android.app.Activity;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.ActivityCompat;
import android.support.v7.app.AlertDialog;
import android.support.v7.app.AppCompatActivity;
import android.text.TextUtils;
import com.github.dfqin.grantor.PermissionListener;
import com.github.dfqin.grantor.PermissionsUtil;
import java.io.Serializable;

public class PermissionActivity
extends AppCompatActivity {
    private static final int PERMISSION_REQUEST_CODE = 64;
    private boolean isRequireCheck;
    private String[] permission;
    private String key;
    private boolean showTip;
    private PermissionsUtil.TipInfo tipInfo;
    private final String defaultTitle = "\u5e2e\u52a9";
    private final String defaultContent = "\u5f53\u524d\u5e94\u7528\u7f3a\u5c11\u5fc5\u8981\u6743\u9650\u3002\n \n \u8bf7\u70b9\u51fb \"\u8bbe\u7f6e\"-\"\u6743\u9650\"-\u6253\u5f00\u6240\u9700\u6743\u9650\u3002";
    private final String defaultCancel = "\u53d6\u6d88";
    private final String defaultEnsure = "\u8bbe\u7f6e";

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (this.getIntent() == null || !this.getIntent().hasExtra("permission")) {
            this.finish();
            return;
        }
        this.isRequireCheck = true;
        this.permission = this.getIntent().getStringArrayExtra("permission");
        this.key = this.getIntent().getStringExtra("key");
        this.showTip = this.getIntent().getBooleanExtra("showTip", true);
        Serializable ser = this.getIntent().getSerializableExtra("tip");
        this.tipInfo = ser == null ? new PermissionsUtil.TipInfo("\u5e2e\u52a9", "\u5f53\u524d\u5e94\u7528\u7f3a\u5c11\u5fc5\u8981\u6743\u9650\u3002\n \n \u8bf7\u70b9\u51fb \"\u8bbe\u7f6e\"-\"\u6743\u9650\"-\u6253\u5f00\u6240\u9700\u6743\u9650\u3002", "\u53d6\u6d88", "\u8bbe\u7f6e") : (PermissionsUtil.TipInfo)ser;
    }

    protected void onResume() {
        super.onResume();
        if (this.isRequireCheck) {
            if (PermissionsUtil.hasPermission((Context)this, this.permission)) {
                this.permissionsGranted();
            } else {
                this.requestPermissions(this.permission);
                this.isRequireCheck = false;
            }
        } else {
            this.isRequireCheck = true;
        }
    }

    private void requestPermissions(String[] permission) {
        ActivityCompat.requestPermissions((Activity)this, (String[])permission, (int)64);
    }

    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        if (requestCode == 64 && PermissionsUtil.isGranted(grantResults) && PermissionsUtil.hasPermission((Context)this, permissions)) {
            this.permissionsGranted();
        } else if (this.showTip) {
            this.showMissingPermissionDialog();
        } else {
            this.permissionsDenied();
        }
    }

    private void showMissingPermissionDialog() {
        AlertDialog.Builder builder = new AlertDialog.Builder((Context)this);
        builder.setTitle((CharSequence)(TextUtils.isEmpty((CharSequence)this.tipInfo.title) ? "\u5e2e\u52a9" : this.tipInfo.title));
        builder.setMessage((CharSequence)(TextUtils.isEmpty((CharSequence)this.tipInfo.content) ? "\u5f53\u524d\u5e94\u7528\u7f3a\u5c11\u5fc5\u8981\u6743\u9650\u3002\n \n \u8bf7\u70b9\u51fb \"\u8bbe\u7f6e\"-\"\u6743\u9650\"-\u6253\u5f00\u6240\u9700\u6743\u9650\u3002" : this.tipInfo.content));
        builder.setNegativeButton((CharSequence)(TextUtils.isEmpty((CharSequence)this.tipInfo.cancel) ? "\u53d6\u6d88" : this.tipInfo.cancel), new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                PermissionActivity.this.permissionsDenied();
            }
        });
        builder.setPositiveButton((CharSequence)(TextUtils.isEmpty((CharSequence)this.tipInfo.ensure) ? "\u8bbe\u7f6e" : this.tipInfo.ensure), new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                PermissionsUtil.gotoSetting((Context)PermissionActivity.this);
            }
        });
        builder.setCancelable(false);
        builder.show();
    }

    private void permissionsDenied() {
        PermissionListener listener = PermissionsUtil.fetchListener(this.key);
        if (listener != null) {
            listener.permissionDenied(this.permission);
        }
        this.finish();
    }

    private void permissionsGranted() {
        PermissionListener listener = PermissionsUtil.fetchListener(this.key);
        if (listener != null) {
            listener.permissionGranted(this.permission);
        }
        this.finish();
    }

    protected void onDestroy() {
        PermissionsUtil.fetchListener(this.key);
        super.onDestroy();
    }
}

