/*
 * Decompiled with CFR 0.152.
 */
package com.gigamole.infinitecycleviewpager;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Rect;
import android.os.Build;
import android.os.Handler;
import android.support.v4.view.PagerAdapter;
import android.support.v4.view.ViewCompat;
import android.support.v4.view.ViewPager;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.animation.AnimationUtils;
import android.view.animation.Interpolator;
import com.gigamole.infinitecycleviewpager.InfiniteCyclePagerAdapter;
import com.gigamole.infinitecycleviewpager.InfiniteCycleScroller;
import com.gigamole.infinitecycleviewpager.OnInfiniteCyclePageTransformListener;
import com.gigamole.infinitecycleviewpager.R;
import com.gigamole.infinitecycleviewpager.VerticalViewPager;
import com.gigamole.infinitecycleviewpager.ViewPageable;
import java.lang.reflect.Field;

class InfiniteCycleManager
implements InfiniteCyclePagerAdapter.OnNotifyDataSetChangedListener {
    private static final int MIN_CYCLE_COUNT = 3;
    private static final int MIN_POINTER_COUNT = 1;
    protected static final int DEFAULT_OFFSCREEN_PAGE_LIMIT = 2;
    protected static final int DEFAULT_PAGE_MARGIN = 0;
    protected static final boolean DEFAULT_DISABLE_FLAG = false;
    protected static final boolean DEFAULT_ENABLE_FLAG = true;
    private static final float DEFAULT_MIN_SCALE = 0.55f;
    private static final float DEFAULT_MAX_SCALE = 0.8f;
    private static final int DEFAULT_MIN_PAGE_SCALE_OFFSET = 30;
    private static final int DEFAULT_CENTER_PAGE_SCALE_OFFSET = 50;
    private static final boolean DEFAULT_IS_MEDIUM_SCALED = true;
    private static final int DEFAULT_SCROLL_DURATION = 500;
    private Context mContext;
    private ViewPageable mViewPageable;
    private View mCastViewPageable;
    private InfiniteCyclePagerAdapter mInfiniteCyclePagerAdapter;
    private PageScrolledState mInnerPageScrolledState = PageScrolledState.IDLE;
    private PageScrolledState mOuterPageScrolledState = PageScrolledState.IDLE;
    private float mPageScrolledPositionOffset;
    private float mPageScrolledPosition;
    private int mStackCount;
    private int mItemCount;
    private boolean mIsLeftPageBringToFront;
    private boolean mIsRightPageBringToFront;
    private boolean mWasMinusOne;
    private boolean mWasPlusOne;
    private final Rect mHitRect = new Rect();
    private boolean mIsInitialItem;
    private boolean mIsAdapterInitialPosition;
    private boolean mIsDataSetChanged;
    private int mState;
    private OnInfiniteCyclePageTransformListener mOnInfiniteCyclePageTransformListener;
    private float mMinPageScaleOffset;
    private float mCenterPageScaleOffset;
    private float mMinPageScale;
    private float mMaxPageScale;
    private float mCenterScaleBy;
    private boolean mIsMediumScaled = false;
    private boolean mIsVertical;
    private int mScrollDuration;
    private Interpolator mInterpolator;
    private boolean mIsAutoScroll;
    private boolean mIsAutoScrollPositive;
    private final Handler mAutoScrollHandler = new Handler();
    private final Runnable mAutoScrollRunnable = new Runnable(){

        @Override
        public void run() {
            if (!InfiniteCycleManager.this.mIsAutoScroll) {
                return;
            }
            InfiniteCycleManager.this.mViewPageable.setCurrentItem(InfiniteCycleManager.this.getRealItem() + (InfiniteCycleManager.this.mIsAutoScrollPositive ? 1 : -1));
            InfiniteCycleManager.this.mAutoScrollHandler.postDelayed((Runnable)this, (long)InfiniteCycleManager.this.mScrollDuration);
        }
    };
    protected final ViewPager.OnPageChangeListener mInfinityCyclePageChangeListener = new ViewPager.SimpleOnPageChangeListener(){

        public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
            InfiniteCycleManager.this.mStackCount = 0;
            if (InfiniteCycleManager.this.mState != 2 || InfiniteCycleManager.this.mIsInitialItem) {
                boolean goingRight;
                if (InfiniteCycleManager.this.mOuterPageScrolledState == PageScrolledState.IDLE && positionOffset > 0.0f) {
                    InfiniteCycleManager.this.mPageScrolledPosition = InfiniteCycleManager.this.mViewPageable.getCurrentItem();
                    InfiniteCycleManager.this.mOuterPageScrolledState = (float)position == InfiniteCycleManager.this.mPageScrolledPosition ? PageScrolledState.GOING_LEFT : PageScrolledState.GOING_RIGHT;
                }
                boolean bl = goingRight = (float)position == InfiniteCycleManager.this.mPageScrolledPosition;
                if (InfiniteCycleManager.this.mOuterPageScrolledState == PageScrolledState.GOING_LEFT && !goingRight) {
                    InfiniteCycleManager.this.mOuterPageScrolledState = PageScrolledState.GOING_RIGHT;
                } else if (InfiniteCycleManager.this.mOuterPageScrolledState == PageScrolledState.GOING_RIGHT && goingRight) {
                    InfiniteCycleManager.this.mOuterPageScrolledState = PageScrolledState.GOING_LEFT;
                }
            }
            if (InfiniteCycleManager.this.mPageScrolledPositionOffset <= positionOffset) {
                InfiniteCycleManager.this.mInnerPageScrolledState = PageScrolledState.GOING_LEFT;
            } else {
                InfiniteCycleManager.this.mInnerPageScrolledState = PageScrolledState.GOING_RIGHT;
            }
            InfiniteCycleManager.this.mPageScrolledPositionOffset = positionOffset;
            if ((InfiniteCycleManager.this.isSmallPositionOffset(positionOffset) ? 0.0f : positionOffset) == 0.0f) {
                InfiniteCycleManager.this.disableHardwareLayers();
                InfiniteCycleManager.this.mInnerPageScrolledState = PageScrolledState.IDLE;
                InfiniteCycleManager.this.mOuterPageScrolledState = PageScrolledState.IDLE;
                InfiniteCycleManager.this.mWasMinusOne = false;
                InfiniteCycleManager.this.mWasPlusOne = false;
                InfiniteCycleManager.this.mIsLeftPageBringToFront = false;
                InfiniteCycleManager.this.mIsRightPageBringToFront = false;
                InfiniteCycleManager.this.mIsInitialItem = false;
            }
        }

        public void onPageScrollStateChanged(int state) {
            InfiniteCycleManager.this.mState = state;
        }
    };

    public InfiniteCycleManager(Context context, ViewPageable viewPageable, AttributeSet attributeSet) {
        this.mContext = context;
        this.mIsVertical = viewPageable instanceof VerticalViewPager;
        this.mViewPageable = viewPageable;
        this.mCastViewPageable = (View)viewPageable;
        this.mViewPageable.setPageTransformer(false, this.getInfinityCyclePageTransformer());
        this.mViewPageable.addOnPageChangeListener(this.mInfinityCyclePageChangeListener);
        this.mViewPageable.setClipChildren(false);
        this.mViewPageable.setDrawingCacheEnabled(false);
        this.mViewPageable.setWillNotCacheDrawing(true);
        this.mViewPageable.setPageMargin(0);
        this.mViewPageable.setOffscreenPageLimit(2);
        this.mViewPageable.setOverScrollMode(2);
        this.resetScroller();
        this.processAttributeSet(attributeSet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processAttributeSet(AttributeSet attributeSet) {
        if (attributeSet == null) {
            return;
        }
        TypedArray typedArray = this.mContext.obtainStyledAttributes(attributeSet, this.mIsVertical ? R.styleable.VerticalInfiniteCycleViewPager : R.styleable.HorizontalInfiniteCycleViewPager);
        try {
            this.setMinPageScaleOffset(typedArray.getDimension(this.mIsVertical ? R.styleable.VerticalInfiniteCycleViewPager_icvp_min_page_scale_offset : R.styleable.HorizontalInfiniteCycleViewPager_icvp_min_page_scale_offset, 30.0f));
            this.setCenterPageScaleOffset(typedArray.getDimension(this.mIsVertical ? R.styleable.VerticalInfiniteCycleViewPager_icvp_center_page_scale_offset : R.styleable.HorizontalInfiniteCycleViewPager_icvp_center_page_scale_offset, 50.0f));
            this.setMinPageScale(typedArray.getFloat(this.mIsVertical ? R.styleable.VerticalInfiniteCycleViewPager_icvp_min_page_scale : R.styleable.HorizontalInfiniteCycleViewPager_icvp_min_page_scale, 0.55f));
            this.setMaxPageScale(typedArray.getFloat(this.mIsVertical ? R.styleable.VerticalInfiniteCycleViewPager_icvp_max_page_scale : R.styleable.HorizontalInfiniteCycleViewPager_icvp_max_page_scale, 0.8f));
            this.setMediumScaled(typedArray.getBoolean(this.mIsVertical ? R.styleable.VerticalInfiniteCycleViewPager_icvp_medium_scaled : R.styleable.HorizontalInfiniteCycleViewPager_icvp_medium_scaled, true));
            this.setScrollDuration(typedArray.getInteger(this.mIsVertical ? R.styleable.VerticalInfiniteCycleViewPager_icvp_scroll_duration : R.styleable.HorizontalInfiniteCycleViewPager_icvp_scroll_duration, 500));
            Interpolator interpolator = null;
            try {
                int interpolatorId = typedArray.getResourceId(this.mIsVertical ? R.styleable.VerticalInfiniteCycleViewPager_icvp_interpolator : R.styleable.HorizontalInfiniteCycleViewPager_icvp_interpolator, 0);
                interpolator = interpolatorId == 0 ? null : AnimationUtils.loadInterpolator((Context)this.mContext, (int)interpolatorId);
                this.setInterpolator(interpolator);
            }
            catch (Resources.NotFoundException exception) {
                interpolator = null;
                exception.printStackTrace();
            }
            finally {
                this.setInterpolator(interpolator);
            }
        }
        finally {
            typedArray.recycle();
        }
    }

    public float getMinPageScaleOffset() {
        return this.mMinPageScaleOffset;
    }

    public void setMinPageScaleOffset(float minPageScaleOffset) {
        this.mMinPageScaleOffset = minPageScaleOffset;
    }

    public float getCenterPageScaleOffset() {
        return this.mCenterPageScaleOffset;
    }

    public void setCenterPageScaleOffset(float centerPageScaleOffset) {
        this.mCenterPageScaleOffset = centerPageScaleOffset;
    }

    public float getMinPageScale() {
        return this.mMinPageScale;
    }

    public void setMinPageScale(float minPageScale) {
        this.mMinPageScale = minPageScale;
        this.resetScaleBy();
    }

    public float getMaxPageScale() {
        return this.mMaxPageScale;
    }

    public void setMaxPageScale(float maxPageScale) {
        this.mMaxPageScale = maxPageScale;
        this.resetScaleBy();
    }

    public boolean isMediumScaled() {
        return this.mIsMediumScaled;
    }

    public void setMediumScaled(boolean mediumScaled) {
        this.mIsMediumScaled = mediumScaled;
    }

    public int getScrollDuration() {
        return this.mScrollDuration;
    }

    public void setScrollDuration(int scrollDuration) {
        this.mScrollDuration = scrollDuration;
        this.resetScroller();
    }

    public Interpolator getInterpolator() {
        return this.mInterpolator;
    }

    public void setInterpolator(Interpolator interpolator) {
        this.mInterpolator = interpolator == null ? new SpringInterpolator() : interpolator;
        this.resetScroller();
    }

    public boolean isVertical() {
        return this.mIsVertical;
    }

    public int getState() {
        return this.mState;
    }

    public OnInfiniteCyclePageTransformListener getOnInfiniteCyclePageTransformListener() {
        return this.mOnInfiniteCyclePageTransformListener;
    }

    public void setOnInfiniteCyclePageTransformListener(OnInfiniteCyclePageTransformListener onInfiniteCyclePageTransformListener) {
        this.mOnInfiniteCyclePageTransformListener = onInfiniteCyclePageTransformListener;
    }

    public InfiniteCyclePageTransformer getInfinityCyclePageTransformer() {
        return new InfiniteCyclePageTransformer();
    }

    public InfiniteCyclePagerAdapter getInfiniteCyclePagerAdapter() {
        return this.mInfiniteCyclePagerAdapter;
    }

    public PagerAdapter setAdapter(PagerAdapter adapter) {
        if (adapter != null && adapter.getCount() >= 3) {
            this.mItemCount = adapter.getCount();
            this.mInfiniteCyclePagerAdapter = new InfiniteCyclePagerAdapter(adapter);
            this.mInfiniteCyclePagerAdapter.setOnNotifyDataSetChangedListener(this);
            return this.mInfiniteCyclePagerAdapter;
        }
        if (this.mInfiniteCyclePagerAdapter != null) {
            this.mInfiniteCyclePagerAdapter.setOnNotifyDataSetChangedListener(null);
            this.mInfiniteCyclePagerAdapter = null;
        }
        return adapter;
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (this.mViewPageable.getAdapter() == null || this.mViewPageable.getAdapter().getCount() == 0) {
            return false;
        }
        if (this.mIsAutoScroll || this.mIsInitialItem || this.mViewPageable.isFakeDragging()) {
            return false;
        }
        if (event.getPointerCount() > 1 || !this.mViewPageable.hasWindowFocus()) {
            event.setAction(1);
        }
        this.checkHitRect(event);
        return true;
    }

    public boolean onInterceptTouchEvent(MotionEvent event) {
        return this.onTouchEvent(event);
    }

    public void onWindowFocusChanged(boolean hasWindowFocus) {
        if (hasWindowFocus) {
            this.invalidateTransformer();
        }
    }

    public int setCurrentItem(int item) {
        this.mIsInitialItem = true;
        if (this.mViewPageable.getAdapter() == null || this.mViewPageable.getAdapter().getCount() < 3) {
            return item;
        }
        int count = this.mViewPageable.getAdapter().getCount();
        if (this.mIsAdapterInitialPosition) {
            this.mIsAdapterInitialPosition = false;
            return this.mInfiniteCyclePagerAdapter.getCount() / 2 / count * count;
        }
        return this.mViewPageable.getCurrentItem() + Math.min(count, item) - this.getRealItem();
    }

    public int getRealItem() {
        if (this.mViewPageable.getAdapter() == null || this.mViewPageable.getAdapter().getCount() < 3) {
            return this.mViewPageable.getCurrentItem();
        }
        return this.mInfiniteCyclePagerAdapter.getVirtualPosition(this.mViewPageable.getCurrentItem());
    }

    public void notifyDataSetChanged() {
        if (this.mInfiniteCyclePagerAdapter == null) {
            this.mViewPageable.getAdapter().notifyDataSetChanged();
            this.mIsDataSetChanged = true;
        } else {
            this.mInfiniteCyclePagerAdapter.notifyDataSetChanged();
        }
        this.postInvalidateTransformer();
    }

    public void invalidateTransformer() {
        if (this.mViewPageable.getAdapter() == null || this.mViewPageable.getAdapter().getCount() == 0 || this.mViewPageable.getChildCount() == 0) {
            return;
        }
        if (this.mViewPageable.beginFakeDrag()) {
            this.mViewPageable.fakeDragBy(0.0f);
            this.mViewPageable.endFakeDrag();
        }
    }

    public void postInvalidateTransformer() {
        this.mViewPageable.post(new Runnable(){

            @Override
            public void run() {
                InfiniteCycleManager.this.invalidateTransformer();
                InfiniteCycleManager.this.mIsDataSetChanged = false;
            }
        });
    }

    private void enableHardwareLayer(View v) {
        int layerType;
        int n = layerType = Build.VERSION.SDK_INT > 19 ? 0 : 2;
        if (v.getLayerType() != layerType) {
            v.setLayerType(layerType, null);
        }
    }

    private void disableHardwareLayers() {
        if (Build.VERSION.SDK_INT > 19) {
            return;
        }
        for (int i = 0; i < this.mViewPageable.getChildCount(); ++i) {
            View child = this.mViewPageable.getChildAt(i);
            if (child.getLayerType() == 0) continue;
            child.setLayerType(0, null);
        }
    }

    private boolean isSmallPositionOffset(float positionOffset) {
        return Math.abs(positionOffset) < 1.0E-4f;
    }

    private void checkHitRect(MotionEvent event) {
        if (event.getAction() == 0) {
            this.mHitRect.set(this.mCastViewPageable.getLeft(), this.mCastViewPageable.getTop(), this.mCastViewPageable.getRight(), this.mCastViewPageable.getBottom());
        } else if (event.getAction() == 2 && !this.mHitRect.contains(this.mCastViewPageable.getLeft() + (int)event.getX(), this.mCastViewPageable.getTop() + (int)event.getY())) {
            event.setAction(1);
        }
    }

    private void resetScroller() {
        if (this.mViewPageable == null) {
            return;
        }
        try {
            Field scroller = this.mIsVertical ? VerticalViewPager.class.getDeclaredField("mScroller") : ViewPager.class.getDeclaredField("mScroller");
            scroller.setAccessible(true);
            InfiniteCycleScroller infiniteCycleScroller = new InfiniteCycleScroller(this.mContext, this.mInterpolator);
            infiniteCycleScroller.setDuration(this.mScrollDuration);
            scroller.set(this.mViewPageable, (Object)infiniteCycleScroller);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void resetPager() {
        this.mIsAdapterInitialPosition = true;
        this.mViewPageable.setCurrentItem(0);
        this.postInvalidateTransformer();
    }

    private void resetScaleBy() {
        this.mCenterScaleBy = (this.mMaxPageScale - this.mMinPageScale) * 0.5f;
    }

    public void startAutoScroll(boolean isAutoScrollPositive) {
        if (this.mIsAutoScroll && isAutoScrollPositive == this.mIsAutoScrollPositive) {
            return;
        }
        this.mIsAutoScroll = true;
        this.mIsAutoScrollPositive = isAutoScrollPositive;
        this.mAutoScrollHandler.removeCallbacks(this.mAutoScrollRunnable);
        this.mAutoScrollHandler.post(this.mAutoScrollRunnable);
    }

    public void stopAutoScroll() {
        if (!this.mIsAutoScroll) {
            return;
        }
        this.mIsAutoScroll = false;
        this.mAutoScrollHandler.removeCallbacks(this.mAutoScrollRunnable);
    }

    @Override
    public void onChanged() {
        this.mIsDataSetChanged = true;
    }

    private final class SpringInterpolator
    implements Interpolator {
        private static final float FACTOR = 0.5f;

        private SpringInterpolator() {
        }

        public float getInterpolation(float input) {
            return (float)(Math.pow(2.0, -10.0f * input) * Math.sin((double)(input - 0.125f) * (Math.PI * 2) / 0.5) + 1.0);
        }
    }

    private static enum PageScrolledState {
        IDLE,
        GOING_LEFT,
        GOING_RIGHT;

    }

    protected class InfiniteCyclePageTransformer
    implements ViewPager.PageTransformer {
        protected InfiniteCyclePageTransformer() {
        }

        public void transformPage(View page, float position) {
            float negativeFraction;
            float translation;
            float scale;
            float fraction;
            if (InfiniteCycleManager.this.mOnInfiniteCyclePageTransformListener != null) {
                InfiniteCycleManager.this.mOnInfiniteCyclePageTransformListener.onPreTransform(page, position);
            }
            InfiniteCycleManager.this.enableHardwareLayer(page);
            if (InfiniteCycleManager.this.mItemCount == 3) {
                if (position > 2.0f || position < -2.0f || InfiniteCycleManager.this.mStackCount != 0 && position > 1.0f || InfiniteCycleManager.this.mStackCount != 0 && position < -1.0f) {
                    page.setVisibility(8);
                    return;
                }
                page.setVisibility(0);
            }
            float pageSize = InfiniteCycleManager.this.mIsVertical ? (float)page.getMeasuredHeight() : (float)page.getMeasuredWidth();
            float pageMinScaleOffset = pageSize * InfiniteCycleManager.this.mMinPageScale;
            float pageSubScaleByOffset = pageSize * InfiniteCycleManager.this.mCenterScaleBy;
            float pageMinScaleEdgeOffset = (pageSize - pageMinScaleOffset) * 0.5f;
            float pageMaxScaleEdgeOffset = (pageSize - pageSize * InfiniteCycleManager.this.mMaxPageScale) * 0.5f;
            float pageSubScaleEdgeOffset = (pageSize - pageSize * (InfiniteCycleManager.this.mMinPageScale + InfiniteCycleManager.this.mCenterScaleBy)) * 0.5f;
            if (InfiniteCycleManager.this.mItemCount < 4 && InfiniteCycleManager.this.mStackCount == 0 && position > -2.0f && position < -1.0f) {
                fraction = -1.0f - position;
                scale = InfiniteCycleManager.this.mMinPageScale;
                translation = pageSize - pageMinScaleEdgeOffset + InfiniteCycleManager.this.mMinPageScaleOffset + (pageSize * 2.0f - pageMinScaleOffset - InfiniteCycleManager.this.mMinPageScaleOffset * 2.0f) * fraction;
                InfiniteCycleManager.this.mStackCount++;
            } else if (InfiniteCycleManager.this.mItemCount > 3 && position >= -2.0f && position < -1.0f) {
                fraction = 1.0f + (position + 1.0f);
                scale = InfiniteCycleManager.this.mMinPageScale;
                translation = pageSize * 2.0f - (pageSize + pageMinScaleEdgeOffset - InfiniteCycleManager.this.mMinPageScaleOffset) * fraction;
            } else if (position >= -1.0f && position <= -0.5f) {
                float positiveFraction = 1.0f + (position + 0.5f) * 2.0f;
                float negativeFraction2 = 1.0f - positiveFraction;
                if (InfiniteCycleManager.this.mIsMediumScaled) {
                    float startOffset = pageSize - pageSubScaleByOffset - pageMaxScaleEdgeOffset + InfiniteCycleManager.this.mMinPageScaleOffset;
                    scale = InfiniteCycleManager.this.mMinPageScale + InfiniteCycleManager.this.mCenterScaleBy - InfiniteCycleManager.this.mCenterScaleBy * negativeFraction2;
                    translation = startOffset - (startOffset - pageSubScaleEdgeOffset + InfiniteCycleManager.this.mCenterPageScaleOffset) * positiveFraction;
                } else {
                    float startOffset = pageSize - pageMinScaleEdgeOffset + InfiniteCycleManager.this.mMinPageScaleOffset;
                    scale = InfiniteCycleManager.this.mMaxPageScale - (InfiniteCycleManager.this.mMaxPageScale - InfiniteCycleManager.this.mMinPageScale) * negativeFraction2;
                    translation = startOffset - (startOffset - pageMaxScaleEdgeOffset + InfiniteCycleManager.this.mCenterPageScaleOffset) * positiveFraction;
                }
            } else if (position >= -0.5f && position <= 0.0f) {
                fraction = -position * 2.0f;
                scale = InfiniteCycleManager.this.mMaxPageScale - (InfiniteCycleManager.this.mIsMediumScaled ? InfiniteCycleManager.this.mCenterScaleBy * fraction : 0.0f);
                translation = ((InfiniteCycleManager.this.mIsMediumScaled ? pageSubScaleEdgeOffset : pageMaxScaleEdgeOffset) - InfiniteCycleManager.this.mCenterPageScaleOffset) * fraction;
            } else if (position >= 0.0f && position <= 0.5f) {
                negativeFraction = position * 2.0f;
                float positiveFraction = 1.0f - negativeFraction;
                scale = !InfiniteCycleManager.this.mIsMediumScaled ? InfiniteCycleManager.this.mMaxPageScale : InfiniteCycleManager.this.mMinPageScale + InfiniteCycleManager.this.mCenterScaleBy + InfiniteCycleManager.this.mCenterScaleBy * positiveFraction;
                translation = (-(InfiniteCycleManager.this.mIsMediumScaled ? pageSubScaleEdgeOffset : pageMaxScaleEdgeOffset) + InfiniteCycleManager.this.mCenterPageScaleOffset) * negativeFraction;
            } else if (position >= 0.5f && position <= 1.0f) {
                negativeFraction = (position - 0.5f) * 2.0f;
                float positiveFraction = 1.0f - negativeFraction;
                if (InfiniteCycleManager.this.mIsMediumScaled) {
                    scale = InfiniteCycleManager.this.mMinPageScale + InfiniteCycleManager.this.mCenterScaleBy * positiveFraction;
                    translation = -pageSubScaleEdgeOffset + InfiniteCycleManager.this.mCenterPageScaleOffset + (-pageSize + pageSubScaleByOffset + pageMaxScaleEdgeOffset + pageSubScaleEdgeOffset - InfiniteCycleManager.this.mMinPageScaleOffset - InfiniteCycleManager.this.mCenterPageScaleOffset) * negativeFraction;
                } else {
                    scale = InfiniteCycleManager.this.mMinPageScale + (InfiniteCycleManager.this.mMaxPageScale - InfiniteCycleManager.this.mMinPageScale) * positiveFraction;
                    translation = -pageMaxScaleEdgeOffset + InfiniteCycleManager.this.mCenterPageScaleOffset + (-pageSize + pageMaxScaleEdgeOffset + pageMinScaleEdgeOffset - InfiniteCycleManager.this.mMinPageScaleOffset - InfiniteCycleManager.this.mCenterPageScaleOffset) * negativeFraction;
                }
            } else if (InfiniteCycleManager.this.mItemCount > 3 && position > 1.0f && position <= 2.0f) {
                negativeFraction = 1.0f + (position - 1.0f);
                float positiveFraction = 1.0f - negativeFraction;
                scale = InfiniteCycleManager.this.mMinPageScale;
                translation = -(pageSize - pageMinScaleEdgeOffset + InfiniteCycleManager.this.mMinPageScaleOffset) + (pageSize + pageMinScaleEdgeOffset - InfiniteCycleManager.this.mMinPageScaleOffset) * positiveFraction;
            } else if (InfiniteCycleManager.this.mItemCount < 4 && InfiniteCycleManager.this.mStackCount == 0 && position > 1.0f && position < 2.0f) {
                fraction = 1.0f - position;
                scale = InfiniteCycleManager.this.mMinPageScale;
                translation = -(pageSize - pageMinScaleEdgeOffset + InfiniteCycleManager.this.mMinPageScaleOffset) + (pageSize * 2.0f - pageMinScaleOffset - InfiniteCycleManager.this.mMinPageScaleOffset * 2.0f) * fraction;
                InfiniteCycleManager.this.mStackCount++;
            } else {
                scale = InfiniteCycleManager.this.mMinPageScale;
                translation = 0.0f;
            }
            ViewCompat.setScaleX((View)page, (float)scale);
            ViewCompat.setScaleY((View)page, (float)scale);
            if (InfiniteCycleManager.this.mIsVertical) {
                ViewCompat.setTranslationY((View)page, (float)translation);
            } else {
                ViewCompat.setTranslationX((View)page, (float)translation);
            }
            boolean needBringToFront = false;
            if (InfiniteCycleManager.this.mItemCount == 2) {
                InfiniteCycleManager.this.mIsLeftPageBringToFront = true;
            }
            switch (InfiniteCycleManager.this.mOuterPageScrolledState) {
                case GOING_LEFT: {
                    InfiniteCycleManager.this.mIsLeftPageBringToFront = false;
                    if (InfiniteCycleManager.this.mInnerPageScrolledState == PageScrolledState.GOING_LEFT) {
                        if (position > -0.5f && position <= 0.0f) {
                            if (InfiniteCycleManager.this.mIsRightPageBringToFront) break;
                            InfiniteCycleManager.this.mIsRightPageBringToFront = true;
                            needBringToFront = true;
                            break;
                        }
                        if (position >= 0.0f && position < 0.5f) {
                            needBringToFront = true;
                            break;
                        }
                        if (!(position > 0.5f) || !(position < 1.0f) || InfiniteCycleManager.this.mIsRightPageBringToFront || InfiniteCycleManager.this.mViewPageable.getChildCount() <= 3) break;
                        needBringToFront = true;
                        break;
                    }
                    if (!(InfiniteCycleManager.this.mPageScrolledPositionOffset < 0.5f) || !(position > -0.5f) || !(position <= 0.0f)) break;
                    needBringToFront = true;
                    break;
                }
                case GOING_RIGHT: {
                    InfiniteCycleManager.this.mIsRightPageBringToFront = false;
                    if (InfiniteCycleManager.this.mInnerPageScrolledState == PageScrolledState.GOING_RIGHT) {
                        if (position >= 0.0f && position < 0.5f) {
                            if (InfiniteCycleManager.this.mIsLeftPageBringToFront) break;
                            InfiniteCycleManager.this.mIsLeftPageBringToFront = true;
                            needBringToFront = true;
                            break;
                        }
                        if (position > -0.5f && position <= 0.0f) {
                            needBringToFront = true;
                            break;
                        }
                        if (!(position > -1.0f) || !(position < -0.5f) || InfiniteCycleManager.this.mIsLeftPageBringToFront || InfiniteCycleManager.this.mViewPageable.getChildCount() <= 3) break;
                        needBringToFront = true;
                        break;
                    }
                    if (!(InfiniteCycleManager.this.mPageScrolledPositionOffset > 0.5f) || !(position >= 0.0f) || !(position < 0.5f)) break;
                    needBringToFront = true;
                    break;
                }
                default: {
                    if (InfiniteCycleManager.this.mIsDataSetChanged) {
                        InfiniteCycleManager.this.mIsLeftPageBringToFront = false;
                        InfiniteCycleManager.this.mIsRightPageBringToFront = false;
                    } else {
                        if (!InfiniteCycleManager.this.mWasPlusOne && position == 1.0f) {
                            InfiniteCycleManager.this.mWasPlusOne = true;
                        } else if (InfiniteCycleManager.this.mWasPlusOne && position == -1.0f) {
                            InfiniteCycleManager.this.mIsLeftPageBringToFront = true;
                        } else if (!InfiniteCycleManager.this.mWasPlusOne && position == -1.0f || InfiniteCycleManager.this.mWasPlusOne && InfiniteCycleManager.this.mIsLeftPageBringToFront && position == -2.0f) {
                            InfiniteCycleManager.this.mIsLeftPageBringToFront = false;
                        }
                        if (!InfiniteCycleManager.this.mWasMinusOne && position == -1.0f) {
                            InfiniteCycleManager.this.mWasMinusOne = true;
                        } else if (InfiniteCycleManager.this.mWasMinusOne && position == 1.0f) {
                            InfiniteCycleManager.this.mIsRightPageBringToFront = true;
                        } else if (!InfiniteCycleManager.this.mWasMinusOne && position == 1.0f || InfiniteCycleManager.this.mWasMinusOne && InfiniteCycleManager.this.mIsRightPageBringToFront && position == 2.0f) {
                            InfiniteCycleManager.this.mIsRightPageBringToFront = false;
                        }
                    }
                    if (position != 0.0f) break;
                    needBringToFront = true;
                }
            }
            if (needBringToFront) {
                page.bringToFront();
                InfiniteCycleManager.this.mCastViewPageable.invalidate();
            }
            if (InfiniteCycleManager.this.mOnInfiniteCyclePageTransformListener != null) {
                InfiniteCycleManager.this.mOnInfiniteCyclePageTransformListener.onPostTransform(page, position);
            }
        }
    }
}

