/*
 * Decompiled with CFR 0.152.
 */
package cn.devezhao.persist4j.util;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentFactory;
import org.dom4j.Element;
import org.dom4j.io.DOMReader;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXParseException;

public class XmlHelper {
    private static final Log LOG = LogFactory.getLog(XmlHelper.class);
    public static final EntityResolver DEFAULT_DTD_RESOLVER = new DTDEntityResolver();
    public static final XmlHelper INSTANCE = new XmlHelper();
    private DOMReader domReader;
    private SAXReader saxReader;

    public SAXReader createSAXReader(String file, List<String> errorsList, EntityResolver entityResolver) {
        if (this.saxReader == null) {
            this.saxReader = new SAXReader();
        }
        if (entityResolver != null) {
            this.saxReader.setEntityResolver(entityResolver);
            this.saxReader.setValidation(true);
        }
        this.saxReader.setErrorHandler((ErrorHandler)new ErrorLogger(file, errorsList));
        this.saxReader.setMergeAdjacentText(true);
        return this.saxReader;
    }

    public DOMReader createDOMReader() {
        if (this.domReader == null) {
            this.domReader = new DOMReader();
        }
        return this.domReader;
    }

    public static Element createDom4jElement(String elName) {
        return DocumentFactory.getInstance().createElement(elName);
    }

    public static Document createDom4jDocument() {
        return DocumentFactory.getInstance().createDocument("UTF-8");
    }

    public static Document read(InputStream in) throws DocumentException {
        return XmlHelper.read(in, null);
    }

    public static Document read(InputStream in, EntityResolver resolver) throws DocumentException {
        SAXReader reader = INSTANCE.createSAXReader("#INPUT_STREAM_FILE", null, resolver);
        return reader.read(in);
    }

    public static void dump(Element element) {
        try {
            OutputFormat outformat = OutputFormat.createPrettyPrint();
            XMLWriter writer = new XMLWriter((OutputStream)System.out, outformat);
            writer.write(element);
            writer.flush();
            System.out.println();
        }
        catch (Throwable t) {
            System.err.println(element.asXML());
        }
    }

    public static class DTDEntityResolver
    implements EntityResolver {
        public static final String PUBLIC_ID = "metadata.dtd";
        public static final String SYSTEM_ID = "https://raw.githubusercontent.com/devezhao/persist4j/master/src/main/resources/metadata.dtd";

        DTDEntityResolver() {
        }

        @Override
        public InputSource resolveEntity(String publicId, String systemId) {
            InputStream stream = this.getClass().getClassLoader().getResourceAsStream(PUBLIC_ID);
            InputSource source = new InputSource(stream);
            source.setPublicId(PUBLIC_ID);
            source.setSystemId(SYSTEM_ID);
            source.setEncoding("UTF-8");
            return source;
        }
    }

    public static class ErrorLogger
    implements ErrorHandler {
        private String file;
        private List<String> errors;

        ErrorLogger(String file, List<String> errors) {
            this.file = file;
            this.errors = errors;
        }

        @Override
        public void error(SAXParseException error) {
            String message = this.file + '(' + error.getLineNumber() + ") " + error.getMessage();
            LOG.error((Object)("Error parsing XML[" + this.file + "]: " + message));
            if (this.errors != null) {
                this.errors.add(message);
            }
        }

        @Override
        public void fatalError(SAXParseException error) {
            this.error(error);
        }

        @Override
        public void warning(SAXParseException warn) {
            LOG.warn((Object)("Warning parsing XML: " + this.file + '(' + warn.getLineNumber() + ") " + warn.getMessage()));
        }
    }
}

