/*
 * Decompiled with CFR 0.152.
 */
package cn.devezhao.persist4j.query.compiler;

import antlr.collections.AST;
import cn.devezhao.persist4j.Entity;
import cn.devezhao.persist4j.Field;
import cn.devezhao.persist4j.Filter;
import cn.devezhao.persist4j.dialect.Dialect;
import cn.devezhao.persist4j.dialect.FieldType;
import cn.devezhao.persist4j.engine.SqlExecutorContext;
import cn.devezhao.persist4j.query.compiler.CompileException;
import cn.devezhao.persist4j.query.compiler.JoinField;
import cn.devezhao.persist4j.query.compiler.JoinTree;
import cn.devezhao.persist4j.query.compiler.NestedSelectContext;
import cn.devezhao.persist4j.query.compiler.ParameterItem;
import cn.devezhao.persist4j.query.compiler.SelectItem;
import cn.devezhao.persist4j.query.compiler.SelectItemType;
import cn.devezhao.persist4j.query.compiler.antlr.AjQLParser;
import cn.devezhao.persist4j.query.compiler.antlr.ParserException;
import cn.devezhao.persist4j.query.compiler.antlr.ParserHelper;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class QueryCompiler
implements Serializable {
    private static final long serialVersionUID = -47840212541257542L;
    private static final Log LOG = LogFactory.getLog(QueryCompiler.class);
    public static final char NAME_FIELD_PREFIX = '&';
    public static final char IDLABEL_FIELD_PREFIX = '#';
    public static final char CUSTOM_FUNC_PREFIX = '$';
    public static final char FORCE_JOIN_PREFIX = '^';
    public static final char NAMED_PARAM = ':';
    public static final char INDEX_PARAM = '?';
    private String ajql;
    private List<SelectItem> selectList = new LinkedList<SelectItem>();
    private String compiledSql = null;
    private Entity rootEntity;
    private final Map<String, JoinField> joinFieldMap = new HashMap<String, JoinField>();
    private final Map<String, ParameterItem> inParameters = new HashMap<String, ParameterItem>();
    private int inParametersIndex = 0;
    private SqlExecutorContext sqlExecutorContext;
    private int nestedTableIncrease = 0;
    private NestedSelectContext nestedSelectContext;

    public QueryCompiler(String ajql) {
        this.ajql = ajql;
    }

    public String compile(SqlExecutorContext context) throws CompileException {
        return this.compile(context, null);
    }

    public String compile(SqlExecutorContext context, Filter filter) throws CompileException {
        if (this.compiledSql != null) {
            return this.compiledSql;
        }
        this.sqlExecutorContext = context;
        AjQLParser parser = ParserHelper.createAjQLParser(this.ajql, true);
        try {
            parser.statement();
        }
        catch (Exception ex) {
            this.handleParseException(ex, this.ajql);
        }
        this.compiledSql = this.compileQuery(parser.getAST(), filter);
        return this.compiledSql;
    }

    public Entity getRootEntity() {
        this.throwIfUncompile();
        return this.rootEntity;
    }

    public SelectItem[] getSelectItems() throws IllegalStateException {
        this.throwIfUncompile();
        return this.selectList.toArray(new SelectItem[0]);
    }

    public String getCompiledSql() throws IllegalStateException {
        this.throwIfUncompile();
        return this.compiledSql;
    }

    public Map<String, ParameterItem> getInParameters() throws IllegalStateException {
        this.throwIfUncompile();
        return this.inParameters;
    }

    private String compileQuery(AST select, Filter filter) {
        AST next;
        Entity entity;
        AST from = select.getNextSibling();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Compiling select clause [ " + select.toStringList() + " ]"));
        }
        this.rootEntity = entity = this.sqlExecutorContext.getEntity(from.getFirstChild().getText());
        JoinTree aJTree = new JoinTree(entity.getPhysicalName(), this.nestedSelectContext == null ? -1 : this.nestedSelectContext.getTableIncrease());
        boolean distinctAggregator = false;
        HashSet<JoinField> distinctFields = new HashSet<JoinField>();
        HashMap<JoinField, AST> mutliFieldsAggregators = new HashMap<JoinField, AST>();
        LinkedList<JoinField> selectFields = new LinkedList<JoinField>();
        AST item = select.getFirstChild();
        do {
            JoinField aJF;
            if (item.getType() == 5) {
                AST next2 = item.getNextSibling();
                if (ParserHelper.isAggregator(next2.getType())) {
                    distinctAggregator = true;
                    continue;
                }
                item = next2;
                aJF = this.bindJoinField(aJTree, entity, item, SelectItemType.Field);
                distinctFields.add(aJF);
            } else if (item.getType() == 28) {
                aJF = this.bindJoinField(aJTree, entity, item, SelectItemType.Aggregator);
                aJF.setAggregator(item.getText(), null);
                mutliFieldsAggregators.put(aJF, item);
            } else if (ParserHelper.isAggregator(item.getType())) {
                boolean withDistinct;
                AST column = item.getFirstChild();
                boolean bl = withDistinct = column.getType() == 5;
                if (withDistinct) {
                    column = column.getNextSibling();
                }
                aJF = this.bindJoinField(aJTree, entity, column, SelectItemType.Aggregator);
                aJF.setAggregator(item.getText(), withDistinct ? "distinct" : null);
                if (ParserHelper.isAggregatorWithMode(item.getType())) {
                    if ((column = column.getNextSibling()) != null && column.getType() == 40) {
                        String sep = column.getNextSibling().getText();
                        aJF.setAggregatorMode(String.format("separator '%s'", sep));
                    } else if (column != null) {
                        String mode = column.getNextSibling().getText();
                        aJF.setAggregatorMode(mode);
                    }
                }
                if (distinctAggregator) {
                    distinctFields.add(aJF);
                    distinctAggregator = false;
                }
            } else {
                aJF = this.bindJoinField(aJTree, entity, item, SelectItemType.Field);
            }
            selectFields.add(aJF);
        } while ((item = item.getNextSibling()) != null);
        this.selectList.clear();
        this.selectList.addAll(selectFields);
        AST where = null;
        AST group = null;
        AST having = null;
        AST order = null;
        for (next = from.getNextSibling(); next != null; next = next.getNextSibling()) {
            switch (next.getType()) {
                case 7: {
                    where = next;
                    break;
                }
                case 13: {
                    group = next;
                    break;
                }
                case 15: {
                    having = next;
                    break;
                }
                case 10: {
                    order = next;
                }
            }
            this.findJoinFields(next, aJTree, entity);
        }
        if (filter != null) {
            String fstrs = filter.evaluate(this.rootEntity);
            fstrs = "where " + (where == null ? fstrs : "1=1 and " + fstrs);
            AjQLParser parser = ParserHelper.createAjQLParser(fstrs);
            try {
                parser.whereClause();
            }
            catch (Exception ex) {
                this.handleParseException(ex, fstrs);
            }
            AST nood = parser.getAST();
            this.findJoinFields(nood, aJTree, entity);
            if (where == null) {
                where = nood;
            } else {
                AST and = nood.getFirstChild().getNextSibling().getNextSibling().getNextSibling();
                where.addChild(and);
            }
        }
        StringBuilder sql = new StringBuilder("select ");
        String aJQL = aJTree.toJoinsSQL(this.sqlExecutorContext.getDialect());
        int columnIncrease = 0;
        Iterator iter = selectFields.iterator();
        while (true) {
            JoinField aJF = (JoinField)iter.next();
            String clause = aJF.as(columnIncrease, this.sqlExecutorContext.getDialect());
            if (aJF.getType() == SelectItemType.Aggregator) {
                if ("CONCAT".equalsIgnoreCase(aJF.getAggregator())) {
                    AST node = (AST)mutliFieldsAggregators.get(aJF);
                    StringBuilder concat = this.compileByClause(node, "concat");
                    concat.insert(6, "( ").append(") as ");
                    clause = concat.toString();
                } else if ("GROUP_CONCAT".equalsIgnoreCase(aJF.getAggregator())) {
                    StringBuilder s = new StringBuilder(aJF.getAggregator()).append("( ");
                    if (aJF.getAggregatorSibling() != null) {
                        s.append("distinct ");
                    }
                    s.append(aJF.getName()).append(" ");
                    if (aJF.getAggregatorMode() != null) {
                        s.append(aJF.getAggregatorMode()).append(" ");
                    }
                    clause = s.append(")").toString();
                } else {
                    clause = aJF.getAggregatorMode() != null ? String.format("%s( %s, '%s' ) as ", aJF.getAggregator(), aJF.getName(), aJF.getAggregatorMode()) : (aJF.getAggregatorSibling() != null ? String.format("%s( %s %s ) as ", aJF.getAggregator(), aJF.getAggregatorSibling(), aJF.getName()) : String.format("%s( %s ) as ", aJF.getAggregator(), aJF.getName()));
                }
                clause = clause + "_c" + columnIncrease;
            }
            if (distinctFields.contains(aJF)) {
                sql.append("distinct ");
            }
            sql.append(clause);
            if (!iter.hasNext()) break;
            sql.append(", ");
            ++columnIncrease;
        }
        sql.append(" from ").append(aJQL).append(" where ");
        StringBuilder clause = new StringBuilder();
        if (where == null) {
            sql.append("( 1 = 1 ) ");
        } else {
            JoinField aJF = null;
            next = where.getFirstChild();
            int prevType = 0;
            AST lastField = null;
            do {
                int type = next.getType();
                String text = next.getText();
                if (next.getNextSibling() != null && next.getNextSibling().getType() == 38) {
                    lastField = next;
                    continue;
                }
                switch (type) {
                    case 45: {
                        aJF = this.getJoinField(next, null, this.sqlExecutorContext.getDialect());
                        clause.append(aJF.getName());
                        break;
                    }
                    case 43: {
                        clause.append('\'').append(text).append('\'');
                        break;
                    }
                    case 32: {
                        clause.append(this.compileInClause(next));
                        break;
                    }
                    case 34: {
                        clause.append(this.compileExistsClause(next, aJTree.getRootJoinNode()));
                        break;
                    }
                    case 48: 
                    case 49: {
                        clause.append('?');
                        ++this.inParametersIndex;
                        text = text.charAt(0) == '?' ? String.valueOf(this.inParametersIndex) : text;
                        this.inParameters.put(text, new ParameterItem(text, this.inParametersIndex, aJF.getField()));
                        break;
                    }
                    case 38: {
                        clause.append(this.compileMatchClause(next, lastField));
                        lastField = null;
                        next = next.getNextSibling();
                        break;
                    }
                    case 60: 
                    case 61: {
                        clause.append('&');
                        break;
                    }
                    default: {
                        if (type == 47 && prevType == 51) {
                            clause.deleteCharAt(clause.length() - 1);
                        }
                        if (ParserHelper.isAggregator(type)) {
                            clause.append(this.compileAggregator(next));
                            break;
                        }
                        if (ParserHelper.isInIgnore(type)) {
                            clause.append(text);
                            if (prevType != 61) break;
                            clause.append(" = 0");
                            break;
                        }
                        LOG.warn((Object)("Unknow token in `where` clause : <" + type + ", " + text + ">"));
                    }
                }
                clause.append(' ');
                prevType = type;
            } while (next != null && (next = next.getNextSibling()) != null);
            sql.append((CharSequence)clause);
        }
        if (group != null) {
            sql.append(this.compileGroupByClause(group, having));
        }
        if (order != null) {
            sql.append(this.compileOrderByClause(order));
        }
        return sql.toString().trim();
    }

    private String compileInClause(AST in) {
        AST next = in.getFirstChild();
        StringBuilder clause = new StringBuilder();
        JoinField aJF = this.getJoinField(next, null, this.sqlExecutorContext.getDialect());
        clause.append(aJF.getName());
        if (next.getNextSibling().getType() == 30) {
            clause.append(" not");
            next = next.getNextSibling();
        }
        clause.append(" in ( ");
        while ((next = next.getNextSibling()) != null) {
            String text = next.getText();
            int ttype = next.getType();
            switch (ttype) {
                case 43: {
                    clause.append('\'').append(text).append('\'');
                    break;
                }
                case 4: {
                    String nestedSql = this.compileNestedSelect(null, next);
                    return clause.append(nestedSql).append(" )").toString();
                }
                default: {
                    if (ParserHelper.isInIgnoreValue(ttype) || ParserHelper.isInIgnore(ttype)) {
                        clause.append(text);
                        break;
                    }
                    LOG.warn((Object)("Unknow token in `in` clause [ " + ttype + ":" + text + " ]"));
                }
            }
            if (ttype != 41) continue;
            clause.append(' ');
        }
        return clause.append(" )").toString();
    }

    private String compileExistsClause(AST exists, JoinTree.JoinNode root) {
        StringBuilder clause = new StringBuilder();
        clause.append("exists ( ");
        AST next = exists.getFirstChild();
        do {
            String text = next.getText();
            int ttype = next.getType();
            switch (ttype) {
                case 43: {
                    clause.append('\'').append(text).append('\'');
                    break;
                }
                case 4: {
                    String nestedSql = this.compileNestedSelect(root, next);
                    return clause.append(nestedSql).append(" )").toString();
                }
                default: {
                    if (ParserHelper.isInIgnoreValue(ttype) || ParserHelper.isInIgnore(ttype)) {
                        clause.append(text);
                        break;
                    }
                    LOG.warn((Object)("Unknow token in `exists` clause [ " + ttype + ":" + text + " ]"));
                }
            }
            if (ttype != 41) continue;
            clause.append(' ');
        } while ((next = next.getNextSibling()) != null);
        return clause.append(" )").toString();
    }

    private String compileNestedSelect(JoinTree.JoinNode root, AST select) {
        NestedSelectContext context = null;
        if (root != null) {
            context = new NestedSelectContext(this.rootEntity, root, this.nestedTableIncrease++);
        }
        QueryCompiler nested = new QueryCompiler(this.sqlExecutorContext, context, this.inParametersIndex);
        String nestedSql = nested.compileNestedSelect(select);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Compiled nested select clause [ " + nestedSql + " ]"));
        }
        if (!nested.inParameters.isEmpty()) {
            this.inParameters.putAll(nested.inParameters);
            this.inParametersIndex = nested.inParametersIndex;
        }
        return nestedSql;
    }

    private String compileGroupByClause(AST by, AST having) {
        AST rollup;
        AST with;
        StringBuilder clause = new StringBuilder();
        clause.append((CharSequence)this.compileByClause(by, "group by "));
        if (having != null) {
            clause.append((CharSequence)this.compileByClause(having, "having "));
            with = having.getNextSibling();
        } else {
            with = by.getNextSibling();
        }
        if (with != null && with.getType() == 16 && (rollup = with.getFirstChild()) != null && rollup.getType() == 17) {
            clause.append("with rollup ");
        }
        return clause.toString();
    }

    private String compileOrderByClause(AST by) {
        return this.compileByClause(by, "order by ").toString();
    }

    private StringBuilder compileByClause(AST ast, String who) {
        StringBuilder clause = new StringBuilder(who);
        AST next = who.toUpperCase().startsWith("HAVING") || "CONCAT".equalsIgnoreCase(who) ? ast.getFirstChild() : ast.getFirstChild().getNextSibling();
        do {
            int type = next.getType();
            switch (type) {
                case 41: {
                    clause.insert(clause.length() - 1, ',');
                    break;
                }
                case 45: {
                    JoinField aJF = this.getJoinField(next, null, this.sqlExecutorContext.getDialect());
                    clause.append(aJF.getName()).append(' ');
                    break;
                }
                case 11: 
                case 12: {
                    clause.append(next.getText()).append(' ');
                    break;
                }
                case 43: {
                    clause.append('\'').append(next.getText()).append("' ");
                    break;
                }
                default: {
                    if (ParserHelper.isAggregator(type)) {
                        clause.append(this.compileAggregator(next));
                    } else {
                        clause.append(next.getText());
                    }
                    clause.append(' ');
                }
            }
        } while ((next = next.getNextSibling()) != null);
        return clause;
    }

    private String compileMatchClause(AST match, AST field) {
        JoinField aJF = this.getJoinField(field, null, this.sqlExecutorContext.getDialect());
        AST query = match.getNextSibling();
        return String.format("match (%s) against ('%s' in boolean mode)", aJF.getName(), query.getText());
    }

    private String compileAggregator(AST next) {
        if (ParserHelper.isAggregatorWithNested(next.getType())) {
            StringBuilder concat = this.compileByClause(next, "concat");
            concat.insert(6, "( ").append(")");
            return concat.toString();
        }
        JoinField aJF = this.getJoinField(next.getFirstChild(), next, this.sqlExecutorContext.getDialect());
        StringBuilder clause = new StringBuilder(next.getText()).append("( ");
        if (aJF.getAggregatorMode() != null) {
            clause.append(aJF.getName()).append(", '").append(aJF.getAggregatorMode()).append('\'');
        } else {
            if (aJF.getAggregatorSibling() != null) {
                clause.append(aJF.getAggregatorSibling()).append(' ');
            }
            clause.append(aJF.getName());
        }
        clause.append(" )");
        return clause.toString();
    }

    /*
     * WARNING - void declaration
     */
    private JoinField bindJoinField(JoinTree tree, Entity entity, AST item, SelectItemType type) {
        String[] joined;
        String itemName = item.getText();
        JoinField ifExists = this.joinFieldMap.get(itemName);
        if (ifExists != null) {
            return new JoinField(ifExists, type);
        }
        if (ParserHelper.isAggregatorWithNested(item.getType())) {
            this.findJoinFields(item, tree, entity);
            return new JoinField(null, null, itemName, type);
        }
        String path = itemName;
        if (path.charAt(0) == '&') {
            type = SelectItemType.NameField;
            path = path.substring(1);
            joined = path.split("\\.");
            path = path + '.';
            Entity currentEntity = entity;
            for (int i = 0; i < joined.length; ++i) {
                Field field = currentEntity.getField(joined[i]);
                currentEntity = this.getReferenceEntity(field);
                if (i + 1 != joined.length) continue;
                path = path + currentEntity.getNameField().getName();
                break;
            }
        }
        joined = path.split("\\.");
        if (path.charAt(0) == '^') {
            if (joined.length == 2) {
                Entity joinEntity = this.sqlExecutorContext.getEntity(joined[0].substring(1));
                Field referenceTo = null;
                for (Field to : this.rootEntity.getReferenceToFields()) {
                    if (!joinEntity.equals(to.getOwnEntity())) continue;
                    referenceTo = to;
                    break;
                }
                if (referenceTo == null) {
                    throw new CompileException("Entity " + joinEntity.getName() + " no reference-to " + this.rootEntity.getName());
                }
                JoinTree.JoinNode joinNode = tree.addChildJoin(joinEntity.getPhysicalName(), this.rootEntity.getPrimaryField().getPhysicalName(), referenceTo.getPhysicalName());
                JoinField aJF = new JoinField(joinNode, joinEntity.getField(joined[1]), itemName, type);
                this.joinFieldMap.put(itemName, aJF);
                return aJF;
            }
            if (joined.length == 1 && this.nestedSelectContext != null) {
                Entity root = this.nestedSelectContext.getRoot();
                JoinField aJF = new JoinField(this.nestedSelectContext.getRootNode(), root.getField(joined[0].substring(1)), itemName, type);
                this.joinFieldMap.put(itemName, aJF);
                return aJF;
            }
            throw new CompileException("Force join must has two nodes");
        }
        if (joined.length == 1) {
            Field field = entity.getField(joined[0]);
            Validate.notNull((Object)field, (String)("Unknow field [ " + joined[0] + " ] in entity [ " + entity.getName() + " ]"));
            JoinField aJF = new JoinField(tree.getRootJoinNode(), field, itemName, type);
            this.joinFieldMap.put(itemName, aJF);
            return aJF;
        }
        Entity crte = entity;
        Object var11_18 = null;
        for (int i = 0; i < joined.length; ++i) {
            void var11_22;
            void var11_19;
            String fn = joined[i];
            Field crtf = crte.getField(fn);
            Validate.notNull((Object)crtf, (String)("Unknow field [ " + fn + " ] in entity [ " + crte.getName() + " ]"));
            crte = this.getReferenceEntity(crtf);
            if (var11_19 == null) {
                JoinTree.JoinNode joinNode = tree.addChildJoin(crte.getPhysicalName(), crtf.getPhysicalName(), crte.getPrimaryField().getPhysicalName());
            } else {
                JoinTree.JoinNode joinNode = tree.addChildJoin(crte.getPhysicalName(), crtf.getPhysicalName(), crte.getPrimaryField().getPhysicalName(), (JoinTree.JoinNode)var11_19);
            }
            if (i + 2 != joined.length) continue;
            Field last = crte.getField(joined[i + 1]);
            Validate.notNull((Object)last, (String)("Unknow field [ " + fn + " ] in entity [ " + crte.getName() + " ]"));
            JoinField aJF = new JoinField((JoinTree.JoinNode)var11_22, last, itemName, type);
            this.joinFieldMap.put(itemName, aJF);
            return aJF;
        }
        throw new CompileException("Unknow error on bind JoinField");
    }

    private Entity getReferenceEntity(Field field) {
        if (FieldType.REFERENCE != field.getType()) {
            throw new CompileException("Field [ " + field + " ] does not support joins");
        }
        return field.getReferenceEntity();
    }

    private void findJoinFields(AST ast, JoinTree aJTree, Entity entity) {
        ast = ast.getFirstChild();
        do {
            AST node;
            if ((node = ast).getType() != 45 && ((node = node.getFirstChild()) == null || node.getType() != 45)) continue;
            this.bindJoinField(aJTree, entity, node, SelectItemType.Field);
        } while ((ast = ast.getNextSibling()) != null);
    }

    private JoinField getJoinField(AST item, AST aggregator, Dialect dialect) {
        JoinField aJF = this.joinFieldMap.get(item.getText());
        if (aJF == null) {
            throw new CompileException("Unknow JoinField in clause [ " + item.getType() + ", " + item.getText() + " ]");
        }
        JoinField clone = new JoinField(aJF, null);
        if (aggregator != null) {
            clone.setAggregator(aggregator.getText(), null);
            if (ParserHelper.isAggregatorWithMode(aggregator.getType())) {
                String mode = item.getNextSibling().getNextSibling().getText();
                clone.setAggregatorMode(mode);
            } else {
                clone.setAggregatorMode(null);
            }
        } else {
            clone.setAggregator(null, null);
            clone.setAggregatorMode(null);
        }
        clone.as(-1, dialect);
        return clone;
    }

    private void throwIfUncompile() {
        if (this.compiledSql == null) {
            throw new IllegalStateException("uncompile");
        }
    }

    private void handleParseException(Exception ex, String ajql) {
        if (ex instanceof ParserException) {
            Throwable cause = ex.getCause();
            throw new CompileException("ANTLR cannot parse AjQL stream, threw an exception [ " + cause.getClass().getName() + ": " + ex.getCause() + " {" + ajql + "} ]", ex.getCause());
        }
        throw new CompileException("Parse AjQL error {" + ajql + "}", ex);
    }

    private QueryCompiler(SqlExecutorContext context, NestedSelectContext nestedSelectContext, int inParametersIndex) {
        this.sqlExecutorContext = context;
        this.nestedSelectContext = nestedSelectContext;
        this.inParametersIndex = inParametersIndex;
    }

    private String compileNestedSelect(AST nestedSelect) {
        return this.compileQuery(nestedSelect, null);
    }
}

