/*
 * Decompiled with CFR 0.152.
 */
package cn.devezhao.persist4j.query.compiler;

import cn.devezhao.persist4j.Field;
import cn.devezhao.persist4j.dialect.Dialect;
import cn.devezhao.persist4j.query.compiler.JoinTree;
import cn.devezhao.persist4j.query.compiler.SelectItem;
import cn.devezhao.persist4j.query.compiler.SelectItemType;
import java.util.Objects;

public class JoinField
implements SelectItem {
    private static final long serialVersionUID = 6578159656188301525L;
    private final JoinTree.JoinNode tableNode;
    private final Field field;
    private final String fieldPath;
    private final SelectItemType type;
    private String name;
    private String alias;
    private Integer index;
    private String fullPath = null;
    private String aggregator;
    private String aggregatorSibling;
    private String aggregatorMode;

    JoinField(JoinTree.JoinNode tableNode, Field field, String fieldPath, SelectItemType type) {
        this.tableNode = tableNode;
        this.field = field;
        this.fieldPath = fieldPath;
        this.type = type;
    }

    JoinField(JoinField joinField, SelectItemType type) {
        this.tableNode = joinField.tableNode;
        this.field = joinField.field;
        this.fieldPath = joinField.fieldPath;
        this.type = type;
    }

    @Override
    public String getFieldPath() {
        return this.fieldPath;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getAlias() {
        return this.alias;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public Field getField() {
        return this.field;
    }

    @Override
    public SelectItemType getType() {
        return this.type;
    }

    protected void setAggregator(String aggregator, String aggregatorSibling) {
        this.aggregator = aggregator;
        this.aggregatorSibling = aggregatorSibling;
    }

    public String getAggregator() {
        return this.aggregator;
    }

    public String getAggregatorSibling() {
        return this.aggregatorSibling;
    }

    protected void setAggregatorMode(String mode) {
        this.aggregatorMode = mode;
    }

    public String getAggregatorMode() {
        return this.aggregatorMode;
    }

    protected String as(int increase, Dialect dialect) {
        if (this.fullPath != null) {
            return this.fullPath;
        }
        this.index = increase;
        this.name = this.tableNode == null ? "$" : String.format("%s.%s", this.tableNode.getAlias(), dialect.quote(this.field.getPhysicalName()));
        this.alias = "_c" + this.index;
        this.fullPath = this.name + " as " + this.alias;
        return this.fullPath;
    }

    public String toString() {
        if (this.getAggregator() != null) {
            return String.format("%s%s[%s->%s->%s]", this.getAggregator(), this.getAggregatorMode() == null ? "" : "," + this.getAggregatorMode(), this.fieldPath, this.name, this.alias);
        }
        return String.format("[%s->%s->%s]", this.fieldPath, this.name, this.alias);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return o.hashCode() == this.hashCode();
    }

    public int hashCode() {
        return Objects.hash(this.tableNode, this.field, this.fieldPath, this.aggregator, this.aggregatorMode);
    }
}

