/*
 * Decompiled with CFR 0.152.
 */
package cn.devezhao.persist4j.query;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SlowLogger {
    private static final Log LOG = LogFactory.getLog(SlowLogger.class);
    private static final ThreadLocal<Long> QUERY_START = new ThreadLocal();

    public static void start() {
        QUERY_START.set(System.currentTimeMillis());
    }

    public static void stop(int loggerTime, int resultSize) {
        SlowLogger.stop(loggerTime, resultSize, null);
    }

    public static void stop(int loggerTime, int resultSize, String sql) {
        int time;
        if (!LOG.isInfoEnabled() || loggerTime <= 0) {
            return;
        }
        Long start = QUERY_START.get();
        if (start == null) {
            start = 0L;
        }
        QUERY_START.remove();
        int n = time = start == 0L ? loggerTime : (int)(System.currentTimeMillis() - start);
        if (time <= loggerTime && resultSize <= 10000) {
            return;
        }
        StringBuilder logs = new StringBuilder().append("\n** SQL Slower/Many ***********************************************************************").append("\nSQL:        ").append(sql == null ? "Unknow" : sql);
        if (time > loggerTime) {
            logs.append("\nTime:       ").append(time).append("ms");
        }
        if (resultSize > 10000) {
            logs.append("\nResult(s):  ").append(resultSize);
        }
        LOG.warn((Object)logs);
    }
}

