/*
 * Decompiled with CFR 0.152.
 */
package cn.devezhao.persist4j.query;

import cn.devezhao.persist4j.Entity;
import cn.devezhao.persist4j.engine.ID;
import cn.devezhao.persist4j.engine.SqlExecutorContext;
import cn.devezhao.persist4j.engine.StandardRecord;
import cn.devezhao.persist4j.query.compiler.SelectItem;
import cn.devezhao.persist4j.record.FieldValueException;
import cn.devezhao.persist4j.util.CaseInsensitiveMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class QueryedRecord
extends StandardRecord {
    private static final long serialVersionUID = 5113799283331109208L;
    private static final Log LOG = LogFactory.getLog(QueryedRecord.class);
    private final Map<String, Object> idLabel = new CaseInsensitiveMap<Object>();
    private SelectItem[] selectItems;

    protected QueryedRecord() {
    }

    protected QueryedRecord(Entity entity, SqlExecutorContext context) {
        super(entity, null);
    }

    public void setSelectItems(SelectItem[] selectItems) {
        this.selectItems = (SelectItem[])selectItems.clone();
    }

    public SelectItem[] getSelectItems() {
        return (SelectItem[])this.selectItems.clone();
    }

    @Override
    protected void setObject(String key, Object value) {
        Entity e = this.getEntity();
        if (e.containsField(key)) {
            try {
                super.setObject(key, value);
            }
            catch (FieldValueException ex) {
                LOG.warn((Object)("QueryedRecord#setObject error : " + key + "=" + value), (Throwable)((Object)ex));
            }
            return;
        }
        if (key.charAt(0) == '&') {
            ID id = this.getID(key = key.substring(1));
            if (id != null) {
                id.setLabel(value);
            } else {
                this.idLabel.put(key, value);
            }
        } else {
            this.recordMap.put(key, value);
        }
    }

    @Override
    protected Object getObject(String key, Class<?> clazz) {
        Entity e = this.getEntity();
        if (e.containsField(key)) {
            return super.getObject(key, clazz);
        }
        return this.recordMap.get(key);
    }

    protected void completeAfter() {
        if (this.idLabel.isEmpty()) {
            return;
        }
        for (Map.Entry<String, Object> e : this.idLabel.entrySet()) {
            ID id = this.getID(e.getKey());
            if (id == null) continue;
            id.setLabel(e.getValue());
        }
    }
}

