/*
 * Decompiled with CFR 0.152.
 */
package cn.devezhao.persist4j.query;

import cn.devezhao.persist4j.PersistManagerFactory;
import cn.devezhao.persist4j.dialect.Type;
import cn.devezhao.persist4j.exception.SqlExceptionConverter;
import cn.devezhao.persist4j.query.AjqlResultImpl;
import cn.devezhao.persist4j.query.BaseQuery;
import cn.devezhao.persist4j.query.NativeQuery;
import cn.devezhao.persist4j.query.SlowLogger;
import cn.devezhao.persist4j.util.SqlHelper;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.jdbc.datasource.DataSourceUtils;

public class NativeQueryImpl
extends BaseQuery<NativeQuery>
implements NativeQuery {
    private static final long serialVersionUID = -5302544598435577417L;
    private static final Log LOG = LogFactory.getLog(NativeQueryImpl.class);
    private final String sql;
    private transient PersistManagerFactory managerFactory;
    private Map<Integer, Object> inParameters = new HashMap<Integer, Object>();
    private Type[] parameterTypes = null;
    private Type[] returnTypes = null;
    private transient List<Object[]> dataCache = null;

    public NativeQueryImpl(String sql, PersistManagerFactory managerFactory) {
        this.sql = sql;
        this.managerFactory = managerFactory;
    }

    @Override
    public NativeQuery setInParameterType(Type ... fTypes) {
        this.parameterTypes = fTypes;
        return this;
    }

    @Override
    public NativeQuery setReturnType(Type ... fTypes) {
        this.returnTypes = fTypes;
        return this;
    }

    @Override
    public NativeQuery setParameter(int position, Object value) {
        this.inParameters.put(position, value);
        return this;
    }

    @Override
    public Object[][] array() {
        if (this.execQuery(0).isEmpty()) {
            return AjqlResultImpl.EMPTY_OBJECT_ARRAYS;
        }
        return (Object[][])this.dataCache.toArray((T[])new Object[this.dataCache.size()][]);
    }

    @Override
    public Object[] unique() {
        this.setMaxResults(1);
        this.setLimit(1, this.offset);
        if (this.execQuery(1).isEmpty()) {
            return null;
        }
        return this.dataCache.get(0);
    }

    @Override
    public NativeQuery reset() {
        if (this.dataCache != null) {
            this.dataCache = null;
        }
        return this;
    }

    protected List<Object[]> execQuery(int fetch) {
        List<Object[]> list;
        if (this.dataCache != null) {
            return this.dataCache;
        }
        this.dataCache = new LinkedList<Object[]>();
        if (fetch == 1) {
            this.setMaxResults(1);
        }
        String aSql = this.sql;
        if (this.limit > 0) {
            aSql = this.managerFactory.getDialect().insertLimit(aSql, this.limit, this.offset);
        }
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)(">> " + aSql));
        }
        SlowLogger.start();
        Connection connect = DataSourceUtils.getConnection((DataSource)this.managerFactory.getDataSource());
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = connect.prepareStatement(aSql);
            if (!this.inParameters.isEmpty()) {
                if (this.parameterTypes != null && this.parameterTypes.length == this.inParameters.size()) {
                    for (Map.Entry<Integer, Object> e : this.inParameters.entrySet()) {
                        int idx = e.getKey() - 1;
                        this.parameterTypes[idx].getFieldEditor().set(pstmt, idx + 1, e.getValue());
                    }
                } else {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)"Parameter type unset, use #setObject");
                    }
                    for (Map.Entry<Integer, Object> e : this.inParameters.entrySet()) {
                        pstmt.setObject(e.getKey(), e.getValue());
                    }
                }
            }
            if (this.getTimeout() > 0) {
                pstmt.setQueryTimeout(this.getTimeout());
            }
            rs = pstmt.executeQuery();
            int colCount = rs.getMetaData().getColumnCount();
            if (fetch > 0) {
                rs.setFetchSize(fetch);
            }
            if (this.getFirstResult() > 0) {
                rs.absolute(this.getFirstResult());
            }
            if (this.getMaxResults() <= 0) {
                while (rs.next()) {
                    this.dataCache.add(this.readRow(rs, colCount));
                }
            } else {
                int current = 0;
                while (current++ < this.getMaxResults() && rs.next()) {
                    this.dataCache.add(this.readRow(rs, colCount));
                }
            }
            list = this.dataCache;
        }
        catch (SQLException sqlex) {
            try {
                throw SqlExceptionConverter.convert(sqlex, "#NATIVE_QUERY", aSql);
            }
            catch (Throwable throwable) {
                SqlHelper.close(rs);
                SqlHelper.close(pstmt);
                SqlHelper.close(connect, this.managerFactory.getDataSource());
                SlowLogger.stop(this.getSlowLoggerTime(), this.dataCache.size(), aSql);
                throw throwable;
            }
        }
        SqlHelper.close(rs);
        SqlHelper.close(pstmt);
        SqlHelper.close(connect, this.managerFactory.getDataSource());
        SlowLogger.stop(this.getSlowLoggerTime(), this.dataCache.size(), aSql);
        return list;
    }

    Object[] readRow(ResultSet rs, int colCount) throws SQLException {
        Object[] values = new Object[colCount];
        if (this.returnTypes != null && this.returnTypes.length == colCount) {
            for (int i = 0; i < colCount; ++i) {
                values[i] = this.returnTypes[i].getFieldEditor().get(rs, i + 1);
            }
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Return type unset, use #getObject");
            }
            for (int i = 0; i < colCount; ++i) {
                values[i] = rs.getObject(i + 1);
            }
        }
        return values;
    }
}

