/*
 * Decompiled with CFR 0.152.
 */
package cn.devezhao.persist4j.exception;

import cn.devezhao.persist4j.exception.JdbcException;
import cn.devezhao.persist4j.exception.jdbc.ConstraintViolationException;
import cn.devezhao.persist4j.exception.jdbc.DataTruncationException;
import cn.devezhao.persist4j.exception.jdbc.GenericJdbcException;
import cn.devezhao.persist4j.exception.jdbc.LockAcquisitionException;
import cn.devezhao.persist4j.exception.jdbc.SqlSyntaxException;
import java.sql.DataTruncation;
import java.sql.SQLException;
import java.sql.SQLIntegrityConstraintViolationException;
import java.sql.SQLSyntaxErrorException;
import java.util.HashSet;
import java.util.Set;

public class SqlExceptionConverter {
    private static final Set<String> SQL_GRAMMAR_CATEGORIES = new HashSet<String>();
    private static final Set<String> DATA_CATEGORIES = new HashSet<String>();
    private static final Set<String> INTEGRITY_VIOLATION_CATEGORIES = new HashSet<String>();
    private static final Set<String> CONNECTION_CATEGORIES = new HashSet<String>();

    private SqlExceptionConverter() {
    }

    public static JdbcException convert(SQLException sqlex, String message, String sql) {
        String stateCode = sqlex.getSQLState();
        if (stateCode != null && stateCode.length() >= 2) {
            String classCode = stateCode.substring(0, 2);
            if (SQL_GRAMMAR_CATEGORIES.contains(classCode)) {
                if (sqlex instanceof SQLSyntaxErrorException && sqlex.getLocalizedMessage().contains("this is incompatible with sql_mode=only_full_group_by")) {
                    message = "INCOMPATIBLE SQLMODE(ONLY_FULL_GROUP_BY)";
                }
                return new SqlSyntaxException(message, sqlex, sql);
            }
            if (INTEGRITY_VIOLATION_CATEGORIES.contains(classCode) || sqlex instanceof SQLIntegrityConstraintViolationException) {
                return new ConstraintViolationException(message, sqlex, sql);
            }
        }
        if ("40001".equals(stateCode)) {
            return new LockAcquisitionException(message, sqlex, sql);
        }
        if ("61000".equals(stateCode)) {
            return new LockAcquisitionException(message, sqlex, sql);
        }
        if (sqlex instanceof DataTruncation) {
            return new DataTruncationException(message, sqlex, sql);
        }
        return SqlExceptionConverter.handledNonSpecificException(sqlex, message, sql);
    }

    public static boolean isConstraintViolationException(SQLException sqlex) {
        String stateCode = sqlex.getSQLState();
        if (stateCode != null && stateCode.length() >= 2) {
            String classCode = stateCode.substring(0, 2);
            return INTEGRITY_VIOLATION_CATEGORIES.contains(classCode) || sqlex instanceof SQLIntegrityConstraintViolationException;
        }
        return false;
    }

    private static JdbcException handledNonSpecificException(SQLException sqlex, String message, String sql) {
        return new GenericJdbcException(message, sqlex, sql);
    }

    static {
        SQL_GRAMMAR_CATEGORIES.add("07");
        SQL_GRAMMAR_CATEGORIES.add("37");
        SQL_GRAMMAR_CATEGORIES.add("42");
        SQL_GRAMMAR_CATEGORIES.add("65");
        SQL_GRAMMAR_CATEGORIES.add("S0");
        SQL_GRAMMAR_CATEGORIES.add("20");
        DATA_CATEGORIES.add("22");
        DATA_CATEGORIES.add("21");
        DATA_CATEGORIES.add("02");
        INTEGRITY_VIOLATION_CATEGORIES.add("23");
        INTEGRITY_VIOLATION_CATEGORIES.add("27");
        INTEGRITY_VIOLATION_CATEGORIES.add("44");
        CONNECTION_CATEGORIES.add("08");
    }
}

