/*
 * Decompiled with CFR 0.152.
 */
package cn.devezhao.persist4j.engine;

import cn.devezhao.commons.ByteUtils;
import cn.devezhao.persist4j.Entity;
import cn.devezhao.persist4j.Field;
import cn.devezhao.persist4j.PersistException;
import cn.devezhao.persist4j.Record;
import cn.devezhao.persist4j.dialect.FieldType;
import cn.devezhao.persist4j.engine.ID;
import cn.devezhao.persist4j.engine.NullValue;
import cn.devezhao.persist4j.metadata.MissingMetaExcetion;
import cn.devezhao.persist4j.record.FieldValueException;
import cn.devezhao.persist4j.util.CaseInsensitiveMap;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.Time;
import java.time.LocalTime;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class StandardRecord
implements Record {
    private static final long serialVersionUID = -3714155230415024491L;
    private static final Log LOG = LogFactory.getLog(StandardRecord.class);
    private final Entity entity;
    private final ID editor;
    protected Map<String, Object> recordMap = new CaseInsensitiveMap<Object>();

    protected StandardRecord() {
        this.entity = null;
        this.editor = null;
    }

    public StandardRecord(Entity entity) {
        this(entity, null);
    }

    public StandardRecord(Entity entity, ID editor) {
        Validate.notNull((Object)entity, (String)"'entity' must not be null");
        this.entity = entity;
        this.editor = editor;
    }

    @Override
    public Entity getEntity() {
        return this.entity;
    }

    @Override
    public ID getEditor() {
        return this.editor;
    }

    @Override
    public ID getPrimary() {
        return this.getID(this.entity.getPrimaryField().getName());
    }

    @Override
    public ID getID(String key) {
        return (ID)this.getObject(key, ID.class);
    }

    @Override
    public Record setID(String key, ID value) {
        if (this.entity.getPrimaryField().getName().equalsIgnoreCase(key) && this.getPrimary() != null) {
            throw new IllegalStateException("Primary field value already exists, can not be re-settings");
        }
        this.setObject(key, value);
        return this;
    }

    @Override
    public ID[] getIDArray(String key) {
        Object v = this.recordMap.get(key);
        if (v == null) {
            return ID.EMPTY_ID_ARRAY;
        }
        return (ID[])v;
    }

    @Override
    public Record setIDArray(String key, ID[] value) {
        this.setObject(key, value);
        return this;
    }

    @Override
    public Character getChar(String key) {
        return (Character)this.getObject(key, Character.class);
    }

    @Override
    public Record setChar(String key, Character value) {
        this.setObject(key, value);
        return this;
    }

    @Override
    public String getString(String key) {
        return (String)this.getObject(key, String.class);
    }

    @Override
    public Record setString(String key, String value) {
        this.setObject(key, value);
        return this;
    }

    @Override
    public Integer getInt(String key) {
        return (Integer)this.getObject(key, Integer.class);
    }

    @Override
    public Record setInt(String key, Integer value) {
        this.setObject(key, value);
        return this;
    }

    @Override
    public Long getLong(String key) {
        return (Long)this.getObject(key, Long.class);
    }

    @Override
    public Record setLong(String key, Long value) {
        this.setObject(key, value);
        return this;
    }

    @Override
    public Double getDouble(String key) {
        return (Double)this.getObject(key, Double.class);
    }

    @Override
    public Record setDouble(String key, Double value) {
        this.setObject(key, value);
        return this;
    }

    @Override
    public BigDecimal getDecimal(String key) {
        return (BigDecimal)this.getObject(key, BigDecimal.class);
    }

    @Override
    public Record setDecimal(String key, BigDecimal value) {
        this.setObject(key, value);
        return this;
    }

    @Override
    public Date getDate(String key) {
        return (Date)this.getObject(key, Date.class);
    }

    @Override
    public Record setDate(String key, Date value) {
        this.setObject(key, value);
        return this;
    }

    @Override
    public LocalTime getTime(String key) {
        Object v = this.recordMap.get(key);
        if (v instanceof Time) {
            v = ((Time)v).toLocalTime();
        }
        return (LocalTime)v;
    }

    @Override
    public Record setTime(String key, LocalTime value) {
        this.setObject(key, value);
        return this;
    }

    @Override
    public Boolean getBoolean(String key) {
        return (Boolean)this.getObject(key, Boolean.class);
    }

    @Override
    public Record setBoolean(String key, Boolean value) {
        this.setObject(key, value);
        return this;
    }

    @Override
    public Reader getReader(String key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Record setReader(String key, Reader value) {
        String content;
        if (value == null) {
            return this;
        }
        try {
            content = ByteUtils.read((Reader)value);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
        return this.setReader(key, content);
    }

    @Override
    public Record setReader(String key, String value) {
        if (value == null) {
            return this;
        }
        this.setObject(key, value);
        return this;
    }

    @Override
    public InputStream getBinary(String key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Record setBinary(String key, InputStream value) {
        this.setObject(key, value);
        return this;
    }

    @Override
    public Object getObjectValue(String key) {
        return this.recordMap.get(key);
    }

    @Override
    public Record setObjectValue(String key, Object value) {
        if (key == null || value == null) {
            return this;
        }
        this.recordMap.put(key, value);
        return this;
    }

    @Override
    public boolean hasValue(String key) {
        return this.hasValue(key, true);
    }

    @Override
    public boolean hasValue(String key, boolean includeNullValue) {
        boolean has = this.recordMap.containsKey(key);
        if (!has) {
            return false;
        }
        return includeNullValue || !NullValue.is(this.recordMap.get(key));
    }

    @Override
    public Object removeValue(String key) {
        return this.recordMap.remove(key);
    }

    @Override
    public Object setNull(String key) {
        Object old = this.recordMap.get(key);
        this.recordMap.put(key, new NullValue());
        return old;
    }

    @Override
    public Iterator<String> getAvailableFieldIterator() {
        return this.recordMap.keySet().iterator();
    }

    @Override
    public Set<String> getAvailableFields() {
        return Collections.unmodifiableSet(this.recordMap.keySet());
    }

    @Override
    public Record clone() {
        StandardRecord o;
        try {
            o = (StandardRecord)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        o.recordMap = new CaseInsensitiveMap<Object>(this.recordMap);
        return o;
    }

    @Override
    public JSON serialize() {
        return new JSONObject(this.recordMap);
    }

    @Override
    public boolean isEmpty() {
        if (this.recordMap.isEmpty()) {
            return true;
        }
        return this.recordMap.size() == 1 && this.getPrimary() != null;
    }

    protected void setObject(String key, Object value) {
        if (!this.entity.containsField(key)) {
            throw new MissingMetaExcetion(key, this.entity.getName());
        }
        if (value == null) {
            return;
        }
        Field field = this.entity.getField(key);
        if (field.getType() == FieldType.REFERENCE || field.getType() == FieldType.ANY_REFERENCE || field.getType() == FieldType.REFERENCE_LIST) {
            this.checkReferenceValue(field, value);
        }
        if (LOG.isDebugEnabled() && this.recordMap.containsKey(key)) {
            LOG.warn((Object)("Update field [" + key + "] value. OLD: " + this.recordMap.get(key) + ", NEW: " + value));
        }
        this.recordMap.put(key, value);
    }

    protected Object getObject(String key, Class<?> matchsClazz) {
        Class<?> valueClazz;
        if (!this.entity.containsField(key)) {
            throw new MissingMetaExcetion(key, this.entity.getName());
        }
        Object value = this.recordMap.get(key);
        Class<?> clazz = valueClazz = value == null ? null : value.getClass();
        if (value == null || NullValue.is(value)) {
            return null;
        }
        if (matchsClazz.isAssignableFrom(valueClazz)) {
            return value;
        }
        if (Long.class.isAssignableFrom(matchsClazz) && Integer.class.isAssignableFrom(valueClazz)) {
            return ((Integer)value).longValue();
        }
        if (Integer.class.isAssignableFrom(matchsClazz) && Long.class.isAssignableFrom(valueClazz)) {
            return ((Long)value).intValue();
        }
        if (Double.class.isAssignableFrom(matchsClazz) && BigDecimal.class.isAssignableFrom(valueClazz)) {
            return ((BigDecimal)value).doubleValue();
        }
        if (BigDecimal.class.isAssignableFrom(matchsClazz) && Double.class.isAssignableFrom(valueClazz)) {
            return BigDecimal.valueOf((Double)value);
        }
        throw new PersistException("Can't cast field [ " + key + " ] value type " + value.getClass() + " to " + matchsClazz);
    }

    protected void checkReferenceValue(Field field, Object value) {
        ID[] idList = value.getClass() == ID[].class ? (ID[])value : new ID[]{(ID)value};
        Entity[] refEntities = field.getReferenceEntities();
        for (ID id : idList) {
            int idType = id.getEntityCode();
            boolean idInvalid = true;
            for (Entity entity : refEntities) {
                if (entity.getEntityCode() != idType) continue;
                idInvalid = false;
                break;
            }
            if (!idInvalid) continue;
            throw new FieldValueException("Field [ " + field + " ] value [ " + id + " ] is wrong. Cannot reference non-specify record of entity");
        }
    }
}

