/*
 * Decompiled with CFR 0.152.
 */
package cn.devezhao.persist4j.dialect.editor;

import cn.devezhao.persist4j.dialect.FieldType;
import cn.devezhao.persist4j.dialect.editor.AbstractFieldEditor;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.sql.Clob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class NTextEditor
extends AbstractFieldEditor {
    private static final long serialVersionUID = -6531990086997201844L;

    @Override
    public int getType() {
        return FieldType.NTEXT.getMask();
    }

    @Override
    public Object get(ResultSet rs, int index) throws SQLException {
        Object val = super.get(rs, index);
        return this.read2String(val);
    }

    public Object read2String(Object ntext) {
        if (ntext == null) {
            return null;
        }
        if (ntext instanceof Clob) {
            try (Reader reader = ((Clob)ntext).getCharacterStream();
                 BufferedReader br = new BufferedReader(reader);){
                StringBuilder sb = new StringBuilder();
                String line = br.readLine();
                while (line != null) {
                    sb.append(line);
                    line = br.readLine();
                }
                ntext = sb.toString();
            }
            catch (Exception ex) {
                LOG.error((Object)"Reading Clob failed", (Throwable)ex);
            }
        } else if (ntext instanceof Reader) {
            try (BufferedReader br = ntext instanceof BufferedReader ? (BufferedReader)ntext : new BufferedReader((Reader)ntext);){
                StringBuilder sb = new StringBuilder();
                try {
                    String line;
                    while ((line = br.readLine()) != null) {
                        sb.append(line);
                    }
                    ntext = sb.toString();
                }
                catch (IOException ex) {
                    LOG.error((Object)"Reading Reader failed", (Throwable)ex);
                }
            }
            catch (IOException ex) {
                LOG.error((Object)"Reading Reader failed", (Throwable)ex);
            }
        }
        return ntext;
    }

    @Override
    public void set(PreparedStatement pstmt, int index, Object value) throws SQLException {
        pstmt.setString(index, value.toString());
    }
}

