/*
 * Decompiled with CFR 0.152.
 */
package cn.devezhao.persist4j.dialect;

import cn.devezhao.persist4j.dialect.Dialect;
import cn.devezhao.persist4j.dialect.FieldType;
import cn.devezhao.persist4j.engine.ID;
import java.util.Locale;

public class OracleDialect
extends Dialect {
    private static final long serialVersionUID = 5056057920212451174L;

    public OracleDialect() {
        String idt = String.format("CHAR(%d)", ID.getIDGenerator().getLength());
        this.registerColumnType(FieldType.PRIMARY.getMask(), idt, 1);
        this.registerColumnType(FieldType.REFERENCE.getMask(), idt, 1);
        this.registerColumnType(FieldType.ANY_REFERENCE.getMask(), idt, 1);
        this.registerColumnType(FieldType.REFERENCE_LIST.getMask(), "VARCHAR2(420)", 1);
        this.registerColumnType(FieldType.INT.getMask(), "INT", 4);
        this.registerColumnType(FieldType.SMALL_INT.getMask(), "SMALLINT", 5);
        this.registerColumnType(FieldType.DOUBLE.getMask(), "NUMBER(19, 8)", 2);
        this.registerColumnType(FieldType.DECIMAL.getMask(), "NUMBER(19, 8)", 2);
        this.registerColumnType(FieldType.LONG.getMask(), "LONG", -5);
        this.registerColumnType(FieldType.CHAR.getMask(), "CHAR(1)", 1);
        this.registerColumnType(FieldType.STRING.getMask(), "VARCHAR2(%d)", 12);
        this.registerColumnType(FieldType.TEXT.getMask(), "LONG VARCHAR", -1);
        this.registerColumnType(FieldType.DATE.getMask(), "DATE", 91);
        this.registerColumnType(FieldType.TIMESTAMP.getMask(), "TIMESTAMP", 93);
        this.registerColumnType(FieldType.TIME.getMask(), "TIME", 92);
        this.registerColumnType(FieldType.BOOL.getMask(), "CHAR(1)", 1);
        this.registerColumnType(FieldType.NTEXT.getMask(), "CLOB", 2005);
        this.registerColumnType(FieldType.BINARY.getMask(), "BLOB", 2004);
    }

    @Override
    public String getDialectName() {
        return "oracle";
    }

    @Override
    public char getStartQuote() {
        return QUOTED[4];
    }

    @Override
    public char getClosedQuote() {
        return QUOTED[4];
    }

    @Override
    public String insertLimit(String query, int limit, int offset) {
        String pagingSelect;
        query = query.trim();
        boolean isForUpdate = false;
        if (query.toLowerCase(Locale.ROOT).endsWith(" for update")) {
            query = query.substring(0, query.length() - 11);
            isForUpdate = true;
        }
        if (offset > 0) {
            pagingSelect = "select * from ( select row_.*, ROWNUM rownum_ from ( %s ) where rownum_ <= ? and rownum_ > ?";
            pagingSelect = String.format(pagingSelect, query, limit + offset, offset);
        } else {
            pagingSelect = "select * from ( %s ) where ROWNUM <= %d";
            pagingSelect = String.format(pagingSelect, query, limit);
        }
        if (isForUpdate) {
            pagingSelect = pagingSelect + " for update";
        }
        return pagingSelect;
    }
}

