/*
 * Decompiled with CFR 0.152.
 */
package cn.devezhao.persist4j.dialect;

import cn.devezhao.persist4j.dialect.Dialect;
import cn.devezhao.persist4j.dialect.FieldType;
import cn.devezhao.persist4j.engine.ID;

public class MySQL5Dialect
extends Dialect {
    private static final long serialVersionUID = 9022968517851901342L;

    public MySQL5Dialect() {
        String idt = String.format("char(%d)", ID.getIDGenerator().getLength());
        this.registerColumnType(FieldType.PRIMARY.getMask(), idt, 1);
        this.registerColumnType(FieldType.REFERENCE.getMask(), idt, 1);
        this.registerColumnType(FieldType.ANY_REFERENCE.getMask(), idt, 12);
        this.registerColumnType(FieldType.REFERENCE_LIST.getMask(), "varchar(420)", 12);
        this.registerColumnType(FieldType.INT.getMask(), "int(11)", 4);
        this.registerColumnType(FieldType.SMALL_INT.getMask(), "smallint(6)", 5);
        this.registerColumnType(FieldType.DOUBLE.getMask(), "double(19, %d)", 8);
        this.registerColumnType(FieldType.DECIMAL.getMask(), "decimal(29, %d)", 3);
        this.registerColumnType(FieldType.LONG.getMask(), "bigint(20)", -5);
        this.registerColumnType(FieldType.CHAR.getMask(), "char(1)", 1);
        this.registerColumnType(FieldType.STRING.getMask(), "varchar(%d)", 12);
        this.registerColumnType(FieldType.TEXT.getMask(), "text(%d)", 12);
        this.registerColumnType(FieldType.DATE.getMask(), "date", 91);
        this.registerColumnType(FieldType.TIMESTAMP.getMask(), "timestamp", 93);
        this.registerColumnType(FieldType.TIME.getMask(), "time", 92);
        this.registerColumnType(FieldType.BOOL.getMask(), "char(1)", 1);
        this.registerColumnType(FieldType.NTEXT.getMask(), "longtext", -1);
        this.registerColumnType(FieldType.BINARY.getMask(), "longblob", 2004);
    }

    @Override
    public String getDialectName() {
        return "mysql5";
    }

    @Override
    public char getClosedQuote() {
        return QUOTED[0];
    }

    @Override
    public char getStartQuote() {
        return QUOTED[1];
    }

    @Override
    public String insertLimit(String query, int limit, int offset) {
        return query + " limit " + limit + (offset > 0 ? " offset " + offset : "");
    }

    @Override
    public boolean supportsLimitOffset() {
        return Boolean.TRUE;
    }

    @Override
    public boolean supportsFullText() {
        return Boolean.TRUE;
    }
}

