/*
 * Decompiled with CFR 0.152.
 */
package cn.devezhao.commons.xml;

import cn.devezhao.commons.xml.FastSAXReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;

public class XMLHelper {
    private static final FastSAXReader FAST_SAX_READER = new FastSAXReader(100);

    public static Document parseText(String text) {
        try {
            return DocumentHelper.parseText((String)text);
        }
        catch (DocumentException ex) {
            throw new IllegalArgumentException("Bad XML content: " + text, ex);
        }
    }

    public static Document createDocument(String fileName) {
        try {
            return XMLHelper.createDocument(new FileInputStream(fileName));
        }
        catch (FileNotFoundException ex) {
            throw new RuntimeException("Could't found specify file: " + fileName, ex);
        }
    }

    public static Document createDocument(InputStream stream) {
        SAXReader saxReader = FAST_SAX_READER.getSAXParser(false);
        try {
            saxReader.setEncoding("UTF-8");
            Document document = saxReader.read(stream);
            return document;
        }
        catch (DocumentException ex) {
            throw new RuntimeException("Could't read XML from InputStream!", ex);
        }
        finally {
            FAST_SAX_READER.release(saxReader);
            try {
                stream.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static Document createDocument(Reader reader) {
        return XMLHelper.createDocument(reader, "UTF-8");
    }

    public static Document createDocument(Reader reader, String encoding) {
        return XMLHelper.createDocument(reader, encoding, false);
    }

    public static Document createDocument(Reader reader, String encoding, boolean xxe) {
        SAXReader saxReader = FAST_SAX_READER.getSAXParser(xxe);
        try {
            saxReader.setEncoding(encoding);
            Document document = saxReader.read(reader);
            return document;
        }
        catch (DocumentException ex) {
            throw new RuntimeException("Could't read XML from InputStream!", ex);
        }
        finally {
            FAST_SAX_READER.release(saxReader);
            try {
                reader.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static String getText(Node node, String xpath) {
        if (node == null) {
            return "";
        }
        if (!StringUtils.isEmpty((String)xpath)) {
            node = node.selectSingleNode(xpath);
        }
        return node == null ? "" : node.getText();
    }

    public static String getAttribute(Node node, String xpath, String attrName) {
        if (node == null) {
            return "";
        }
        if (!StringUtils.isEmpty((String)xpath)) {
            node = node.selectSingleNode(xpath);
        }
        return node == null ? "" : StringUtils.defaultIfEmpty((String)node.valueOf("@" + attrName), (String)"");
    }
}

