/*
 * Decompiled with CFR 0.152.
 */
package cn.devezhao.commons.web;

import cn.devezhao.commons.ThrowableUtils;
import cn.devezhao.commons.web.ServletUtils;
import java.io.FileNotFoundException;
import java.io.IOException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;

public class JhtmlForward
extends HttpServlet {
    private static final long serialVersionUID = -6821655106468381401L;
    protected String contextPath;
    protected String prefix;
    protected String suffix;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.contextPath = config.getServletContext().getContextPath();
        this.prefix = StringUtils.defaultIfEmpty((String)config.getInitParameter("prefix"), (String)"");
        this.suffix = StringUtils.defaultIfEmpty((String)config.getInitParameter("suffix"), (String)".htm");
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String toUrl = request.getRequestURI();
        toUrl = toUrl.replaceFirst(this.contextPath, this.prefix);
        toUrl = toUrl.replace(this.suffix, ".jsp");
        try {
            ServletUtils.forward((ServletRequest)request, response, toUrl);
        }
        catch (Exception ex) {
            Throwable root = ThrowableUtils.getRootCause(ex);
            if (root instanceof FileNotFoundException) {
                response.sendError(404, root.getLocalizedMessage());
            }
            response.sendError(500, root.getLocalizedMessage());
        }
    }
}

