/*
 * Decompiled with CFR 0.152.
 */
package cn.devezhao.commons.web;

import cn.devezhao.commons.ThrowableUtils;
import cn.devezhao.commons.web.RequestContext;
import cn.devezhao.commons.web.RequestContextImpl;
import cn.devezhao.commons.web.RequestExecutor;
import java.lang.reflect.InvocationTargetException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class BaseServlet
extends HttpServlet
implements RequestExecutor {
    private static final long serialVersionUID = -4379864218946482170L;
    private static final Log LOG = LogFactory.getLog(BaseServlet.class);

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) {
        this.execute(req, resp);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) {
        this.execute(req, resp);
    }

    protected void execute(HttpServletRequest request, HttpServletResponse response) {
        RequestContext context = this.createRequestContext(request, response);
        try {
            long start = 0L;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Executing request: " + context));
                start = System.currentTimeMillis();
            }
            this.execute(context);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Execute completed. Time of is: " + (System.currentTimeMillis() - start) + " ms."));
            }
        }
        catch (Exception ex) {
            this.handleException(context, ex);
        }
    }

    @Override
    public void handleException(RequestContext context, Throwable ex) {
        Throwable cause = this.getRootCause(ex);
        LOG.error((Object)"Execute request failure!", cause);
        if (cause instanceof RuntimeException) {
            throw (RuntimeException)cause;
        }
        throw new RuntimeException(cause);
    }

    protected RequestContext createRequestContext(HttpServletRequest request, HttpServletResponse response) {
        return new RequestContextImpl(request, response);
    }

    protected Throwable getRootCause(Throwable cause) {
        Throwable rootCause = cause == null ? new RuntimeException("\u672a\u77e5\u9519\u8bef") : (cause instanceof InvocationTargetException ? ((InvocationTargetException)cause).getTargetException() : ThrowableUtils.getRootCause(cause));
        return rootCause;
    }
}

