/*
 * Decompiled with CFR 0.152.
 */
package cn.devezhao.commons.sql.builder;

import cn.devezhao.commons.sql.SqlHelper;
import cn.devezhao.commons.sql.builder.ConditionalBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class SelectBuilder
extends ConditionalBuilder {
    private final List<String> columns = new LinkedList<String>();
    private String orderBy;
    private String groupBy;
    private int limit = -1;
    private int offset = -1;

    public SelectBuilder(String table) {
        super(table);
    }

    public SelectBuilder addColumn(String column) {
        this.columns.add(column);
        return this;
    }

    public SelectBuilder addColumns(String[] columns) {
        Collections.addAll(this.columns, columns);
        return this;
    }

    public SelectBuilder addColumns(String column, String ... columns) {
        this.columns.add(column);
        this.columns.addAll(Arrays.asList(columns));
        return this;
    }

    public SelectBuilder setOrderBy(String orderBy) {
        this.orderBy = orderBy;
        return this;
    }

    public SelectBuilder setGroupBy(String groupBy) {
        this.groupBy = groupBy;
        return this;
    }

    public SelectBuilder setLimit(int limit) {
        return this.setLimit(limit, -1);
    }

    public SelectBuilder setLimit(int limit, int offset) {
        this.limit = limit;
        this.offset = offset;
        return this;
    }

    @Override
    public String toSql() {
        StringBuilder sql = new StringBuilder("select ");
        for (String c : this.columns) {
            if (c.contains("(")) {
                sql.append(c);
            } else {
                sql.append(SqlHelper.wrapIdent(c));
            }
            sql.append(", ");
        }
        int len = sql.length();
        sql.delete(len - 2, len);
        sql.append(" from ").append(SqlHelper.wrapIdent(this.table.toLowerCase())).append(" where (1 = 1)");
        if (this.whereClause != null) {
            sql.append(" and ").append(this.whereClause.toSql());
        }
        if (!StringUtils.isBlank((String)this.whereString)) {
            sql.append(" and ").append(this.whereString);
        }
        if (this.groupBy != null) {
            sql.append(" group by ").append(this.groupBy);
        }
        if (this.orderBy != null) {
            sql.append(" order by ").append(this.orderBy);
        }
        if (this.limit > 0) {
            sql.append(" limit ").append(this.limit);
            if (this.offset > -1) {
                sql.append(" offset ").append(this.offset);
            }
        }
        return sql.toString();
    }

    public boolean hasColumn() {
        return !this.columns.isEmpty();
    }
}

