/*
 * Decompiled with CFR 0.152.
 */
package cn.devezhao.commons.sql;

import cn.devezhao.commons.ThrowableUtils;
import cn.devezhao.commons.sql.Builder;
import cn.devezhao.commons.sql.DataAccessException;
import cn.devezhao.commons.sql.builder.WhereClause;
import com.mchange.v2.c3p0.ComboPooledDataSource;
import com.mchange.v2.c3p0.cfg.C3P0Config;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLIntegrityConstraintViolationException;
import java.sql.Statement;
import java.util.LinkedList;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SqlHelper {
    private static final Log LOG = LogFactory.getLog(SqlHelper.class);
    private static final SqlHelper instance = new SqlHelper();
    private final Object comboPooledDataSourceLock = new Object();
    private ComboPooledDataSource comboPooledDataSource;

    private SqlHelper() {
    }

    public static SqlHelper getInstance() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection doGetConnection() {
        if (this.comboPooledDataSource == null) {
            Object object = this.comboPooledDataSourceLock;
            synchronized (object) {
                if (this.comboPooledDataSource == null) {
                    try {
                        C3P0Config.initializeUserOverridesAsString();
                        this.comboPooledDataSource = new ComboPooledDataSource();
                    }
                    catch (Exception ex) {
                        LOG.error((Object)"Initialize ComboPooledDataSource failure!!!", (Throwable)ex);
                        throw new ExceptionInInitializerError(ex);
                    }
                }
            }
        }
        try {
            return this.comboPooledDataSource.getConnection();
        }
        catch (SQLException ex) {
            LOG.error((Object)"Could not get JDBC Connection!", (Throwable)ex);
            throw new DataAccessException("Could not get JDBC Connection!", ex);
        }
    }

    public static Connection getConnection() {
        return SqlHelper.getInstance().doGetConnection();
    }

    public static long executeInsert(Builder builder) {
        return SqlHelper.executeInsert(builder.toSql());
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static long executeInsert(String asql) {
        long l;
        Connection connect = SqlHelper.getConnection();
        PreparedStatement pstmt = null;
        ResultSet keyRs = null;
        try {
            pstmt = connect.prepareStatement(asql, 1);
            pstmt.executeUpdate();
            keyRs = pstmt.getGeneratedKeys();
            keyRs.next();
            l = keyRs.getLong(1);
        }
        catch (SQLException ex) {
            try {
                LOG.error((Object)"Execute SQL(insert) failure!", (Throwable)ex);
                throw new DataAccessException("Execute SQL(insert) failure!", ex);
                catch (Throwable ex2) {
                    LOG.error((Object)"Execute SQL(insert) unexception error!", ex2);
                    throw new DataAccessException("Execute SQL(insert) unexception error!", ex2);
                }
            }
            catch (Throwable throwable) {
                SqlHelper.attemptClose(keyRs);
                SqlHelper.attemptClose(pstmt);
                SqlHelper.attemptClose(connect);
                throw throwable;
            }
        }
        SqlHelper.attemptClose(keyRs);
        SqlHelper.attemptClose(pstmt);
        SqlHelper.attemptClose(connect);
        return l;
    }

    public static int executeSql(Builder builder) {
        return SqlHelper.executeSql(builder.toSql());
    }

    public static int executeSql(String asql) {
        Connection connect = SqlHelper.getConnection();
        Statement stmt = null;
        try {
            stmt = connect.createStatement();
            int n = stmt.executeUpdate(asql);
            return n;
        }
        catch (SQLException ex) {
            LOG.error((Object)"Execute SQL failure!", (Throwable)ex);
            throw new DataAccessException("Execute SQL failure!", ex);
        }
        catch (Throwable ex) {
            LOG.error((Object)"Execute SQL unexception error!", ex);
            throw new DataAccessException("Execute SQL unexception error!", ex);
        }
        finally {
            SqlHelper.attemptClose(stmt);
            SqlHelper.attemptClose(connect);
        }
    }

    public static int executeBtachSql(Builder[] builders) {
        String[] sqls = new String[builders.length];
        int idx = 0;
        for (Builder b : builders) {
            sqls[idx++] = b.toSql();
        }
        return SqlHelper.executeBtachSql(sqls);
    }

    public static int executeBtachSql(String[] asqls) {
        if (asqls.length == 1) {
            return SqlHelper.executeSql(asqls[0]);
        }
        Connection connect = SqlHelper.getConnection();
        Statement stmt = null;
        try {
            stmt = connect.createStatement();
            for (String asql : asqls) {
                stmt.addBatch(asql);
            }
            int[] affs = stmt.executeBatch();
            int aff = 0;
            for (int a : affs) {
                aff += a;
            }
            int n = aff;
            return n;
        }
        catch (SQLException ex) {
            LOG.error((Object)"Execute SQL batch failure!", (Throwable)ex);
            throw new DataAccessException("Execute SQL batch failure!", ex);
        }
        catch (Throwable ex) {
            LOG.error((Object)"Execute SQL batch unexception error!", ex);
            throw new DataAccessException("Execute SQL batch unexception error!", ex);
        }
        finally {
            SqlHelper.attemptClose(stmt);
            SqlHelper.attemptClose(connect);
        }
    }

    public static Object[][] executeQuery(Builder builder, Object ... inParameters) {
        return SqlHelper.executeQuery(builder.toSql(), inParameters);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Object[][] executeQuery(String asql, Object ... inParameters) {
        Connection connect = SqlHelper.getConnection();
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        LinkedList<Object[]> results = new LinkedList<Object[]>();
        try {
            pstmt = connect.prepareStatement(asql);
            if (inParameters.length > 0) {
                for (int i = 0; i < inParameters.length; ++i) {
                    pstmt.setObject(1 + i, inParameters[i]);
                }
            }
            rs = pstmt.executeQuery();
            ResultSetMetaData rsmd = rs.getMetaData();
            int colLen = rsmd.getColumnCount();
            while (rs.next()) {
                Object[] tmp = new Object[colLen];
                for (int i = 0; i < colLen; ++i) {
                    tmp[i] = rs.getObject(i + 1);
                }
                results.add(tmp);
            }
        }
        catch (SQLException ex) {
            try {
                LOG.error((Object)"Execute SQL(select) failure!", (Throwable)ex);
                throw new DataAccessException("Execute SQL(select) failure!", ex);
                catch (Throwable ex2) {
                    LOG.error((Object)"Execute SQL(select) unexception error!", ex2);
                    throw new DataAccessException("Execute SQL(select) unexception error!", ex2);
                }
            }
            catch (Throwable throwable) {
                SqlHelper.attemptClose(rs);
                SqlHelper.attemptClose(pstmt);
                SqlHelper.attemptClose(connect);
                throw throwable;
            }
        }
        SqlHelper.attemptClose(rs);
        SqlHelper.attemptClose(pstmt);
        SqlHelper.attemptClose(connect);
        return (Object[][])results.toArray((T[])new Object[results.size()][]);
    }

    public static Object[] executeQueryUnique(Builder builder, Object ... inParameters) {
        return SqlHelper.executeQueryUnique(builder.toSql(), inParameters);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Object[] executeQueryUnique(String asql, Object ... inParameters) {
        Object[] objectArray;
        Connection connect = SqlHelper.getConnection();
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = connect.prepareStatement(asql);
            if (inParameters.length > 0) {
                for (int i = 0; i < inParameters.length; ++i) {
                    pstmt.setObject(1 + i, inParameters[i]);
                }
            }
            rs = pstmt.executeQuery();
            rs.setFetchSize(1);
            Object[] tmp = null;
            if (rs.next()) {
                ResultSetMetaData rsmd = rs.getMetaData();
                int colLen = rsmd.getColumnCount();
                tmp = new Object[colLen];
                for (int i = 0; i < colLen; ++i) {
                    tmp[i] = rs.getObject(i + 1);
                }
            }
            objectArray = tmp;
        }
        catch (SQLException ex) {
            try {
                LOG.error((Object)"Execute SQL(select) failure!", (Throwable)ex);
                throw new DataAccessException("Execute SQL(select) failure!", ex);
                catch (Throwable ex2) {
                    LOG.error((Object)"Execute SQL(select) unexception error!", ex2);
                    throw new DataAccessException("Execute SQL(select) unexception error!", ex2);
                }
            }
            catch (Throwable throwable) {
                SqlHelper.attemptClose(rs);
                SqlHelper.attemptClose(pstmt);
                SqlHelper.attemptClose(connect);
                throw throwable;
            }
        }
        SqlHelper.attemptClose(rs);
        SqlHelper.attemptClose(pstmt);
        SqlHelper.attemptClose(connect);
        return objectArray;
    }

    public static long count(String table) {
        return SqlHelper.count(table, null);
    }

    public static long count(String table, WhereClause clause) {
        Object[][] result;
        StringBuilder sql = new StringBuilder("select count(*) from ");
        sql.append(SqlHelper.wrapIdent(table.toLowerCase()));
        if (clause != null) {
            sql.append(" where ").append(clause.toSql());
        }
        return (result = SqlHelper.executeQuery(sql.toString(), new Object[0])).length == 0 ? 0L : (Long)result[0][0];
    }

    public static void attemptClose(Connection connect) {
        if (connect == null) {
            return;
        }
        try {
            if (connect.isClosed()) {
                return;
            }
            connect.close();
        }
        catch (AbstractMethodError abstractMethodError) {
        }
        catch (SQLException sqlex) {
            LOG.error((Object)"Close Connection failure!", (Throwable)sqlex);
        }
    }

    public static void attemptClose(Statement stmt) {
        if (stmt == null) {
            return;
        }
        try {
            if (stmt.isClosed()) {
                return;
            }
            stmt.close();
        }
        catch (AbstractMethodError abstractMethodError) {
        }
        catch (SQLException sqlex) {
            LOG.error((Object)"Close Statement failure!", (Throwable)sqlex);
        }
    }

    public static void attemptClose(ResultSet rs) {
        if (rs == null) {
            return;
        }
        try {
            if (rs.isClosed()) {
                return;
            }
            rs.close();
        }
        catch (AbstractMethodError abstractMethodError) {
        }
        catch (SQLException sqlex) {
            LOG.error((Object)"Close ResultSet failure!", (Throwable)sqlex);
        }
    }

    public static void clear(Statement stmt) {
        if (stmt == null) {
            return;
        }
        try {
            if (stmt instanceof PreparedStatement) {
                ((PreparedStatement)stmt).clearParameters();
            }
            stmt.clearBatch();
            stmt.clearWarnings();
        }
        catch (Throwable ex) {
            LOG.warn((Object)"Unable to clear JDBC Statement.");
        }
    }

    public static String wrapIdent(String identifier) {
        return "`" + identifier + '`';
    }

    public static String escapeSql(Object value) {
        if (value == null) {
            return "";
        }
        if (Number.class.isAssignableFrom(value.getClass())) {
            return value.toString();
        }
        return StringUtils.replace((String)value.toString(), (String)"'", (String)"''");
    }

    public static boolean isConstraintViolationException(Exception ex) {
        if (ex instanceof SQLIntegrityConstraintViolationException) {
            return true;
        }
        Throwable cause = ThrowableUtils.getRootCause(ex);
        return cause instanceof SQLIntegrityConstraintViolationException;
    }
}

