/*
 * Decompiled with CFR 0.152.
 */
package cn.devezhao.commons.excel;

import cn.devezhao.commons.excel.Cell;
import cn.devezhao.commons.excel.ExcelReader;
import cn.devezhao.commons.excel.ExcelReaderException;
import cn.devezhao.commons.excel.ExcelReaderFactory;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.openxml4j.opc.PackageAccess;
import org.apache.poi.ss.util.CellReference;
import org.apache.poi.xssf.eventusermodel.ReadOnlySharedStringsTable;
import org.apache.poi.xssf.eventusermodel.XSSFReader;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;

public class XExcelReader
extends ExcelReader {
    private final OPCPackage pkg;
    private final XSSFReader xssfReader;
    private final ReadOnlySharedStringsTable sharedStringsTable;
    private int sheetIndex = 0;
    private XMLStreamReader cellReader;

    public XExcelReader(File excel) {
        try {
            this.pkg = OPCPackage.open((File)excel, (PackageAccess)PackageAccess.READ);
            this.xssfReader = new XSSFReader(this.pkg);
            this.sharedStringsTable = new ReadOnlySharedStringsTable(this.pkg);
        }
        catch (Exception e) {
            this.close();
            throw new ExcelReaderException(e);
        }
    }

    @Override
    public String[] getSheetNames() {
        ArrayList<String> names = new ArrayList<String>();
        try {
            XSSFReader.SheetIterator iter = (XSSFReader.SheetIterator)this.xssfReader.getSheetsData();
            while (iter.hasNext()) {
                InputStream is = iter.next();
                names.add(iter.getSheetName());
                ExcelReaderFactory.close(is);
            }
        }
        catch (Exception e) {
            throw new ExcelReaderException(e);
        }
        return names.toArray(new String[0]);
    }

    @Override
    public void sheetAt(int index) {
        block7: {
            if (this.cellReader != null) {
                ExcelReaderFactory.close(this.cellReader);
                this.cellReader = null;
            }
            try {
                XSSFReader.SheetIterator iter = (XSSFReader.SheetIterator)this.xssfReader.getSheetsData();
                int currentIndex = 0;
                while (iter.hasNext()) {
                    InputStream is = iter.next();
                    if (currentIndex++ == index) {
                        this.cellReader = XMLInputFactory.newInstance().createXMLStreamReader(is);
                        while (this.cellReader.hasNext()) {
                            this.cellReader.next();
                            if (!this.cellReader.isStartElement() || !"sheetData".equals(this.cellReader.getLocalName())) continue;
                            break block7;
                        }
                        break;
                    }
                    ExcelReaderFactory.close(is);
                }
            }
            catch (Exception e) {
                throw new ExcelReaderException(e);
            }
        }
        if (this.cellReader == null) {
            throw new ExcelReaderException("Invalid sheet position: " + index);
        }
        this.sheetIndex = index;
    }

    @Override
    public int getRowCount() {
        this.sheetAt(this.sheetIndex);
        int rowCount = 0;
        try {
            while (this.cellReader.hasNext()) {
                this.cellReader.next();
                if (!this.cellReader.isStartElement() || !"row".equals(this.cellReader.getLocalName())) continue;
                ++rowCount;
            }
        }
        catch (XMLStreamException e) {
            throw new ExcelReaderException(e);
        }
        this.sheetAt(this.sheetIndex);
        return rowCount;
    }

    @Override
    public boolean hasNext() {
        if (this.cellReader == null) {
            this.sheetAt(this.sheetIndex);
        }
        try {
            return this.cellReader.hasNext();
        }
        catch (XMLStreamException e) {
            return false;
        }
    }

    @Override
    public Cell[] next() {
        if (this.cellReader == null) {
            this.sheetAt(this.sheetIndex);
        }
        try {
            do {
                this.cellReader.next();
                if (!this.cellReader.isStartElement() || !"row".equals(this.cellReader.getLocalName())) continue;
                return this.readRow();
            } while (this.cellReader.hasNext());
        }
        catch (XMLStreamException e) {
            throw new ExcelReaderException(e);
        }
        return null;
    }

    private Cell[] readRow() throws XMLStreamException {
        ArrayList<Cell> cellList = new ArrayList<Cell>();
        while (this.cellReader.hasNext()) {
            this.cellReader.next();
            if (this.cellReader.isStartElement()) {
                if (!"c".equals(this.cellReader.getLocalName())) continue;
                CellReference cellReference = new CellReference(this.cellReader.getAttributeValue(null, "r"));
                while (cellList.size() < cellReference.getCol()) {
                    cellList.add(Cell.NULL);
                }
                String cellValue = this.readCellValue(this.cellReader.getAttributeValue(null, "t"));
                cellList.add(this.trimToStringCell(cellValue, -1, -1));
                continue;
            }
            if (!this.cellReader.isEndElement() || !"row".equals(this.cellReader.getLocalName())) continue;
            break;
        }
        return cellList.toArray(new Cell[0]);
    }

    private String readCellValue(String cellType) throws NumberFormatException, XMLStreamException {
        while (this.cellReader.hasNext()) {
            this.cellReader.next();
            if (this.cellReader.isStartElement()) {
                if (!"v".equals(this.cellReader.getLocalName())) continue;
                if ("s".equals(cellType)) {
                    int idx = Integer.parseInt(this.cellReader.getElementText());
                    return new XSSFRichTextString(this.sharedStringsTable.getEntryAt(idx)).toString();
                }
                return this.cellReader.getElementText();
            }
            if (!this.cellReader.isEndElement() || !"c".equals(this.cellReader.getLocalName())) continue;
            break;
        }
        return "";
    }

    @Override
    public void close() {
        super.close();
        ExcelReaderFactory.close(this.cellReader);
        ExcelReaderFactory.close((Closeable)this.pkg);
    }
}

