/*
 * Decompiled with CFR 0.152.
 */
package cn.devezhao.commons;

import cn.devezhao.commons.CodecUtils;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.zip.CRC32;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.lang.StringUtils;

public final class EncryptUtils {
    private static byte[] toMD5(byte[] input) {
        MessageDigest digest;
        try {
            digest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        digest.update(input);
        return digest.digest();
    }

    public static String toMD5Hex(byte[] input) {
        return EncryptUtils.toHexString(EncryptUtils.toMD5(input));
    }

    public static String toMD5Hex(String input) {
        return EncryptUtils.toMD5Hex(input.getBytes(StandardCharsets.UTF_8));
    }

    private static byte[] toSHA(byte[] input, String algorithm) {
        MessageDigest digest;
        try {
            digest = MessageDigest.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        digest.update(input);
        return digest.digest();
    }

    public static String toSHA1Hex(byte[] input) {
        return EncryptUtils.toHexString(EncryptUtils.toSHA(input, "SHA1"));
    }

    public static String toSHA1Hex(String input) {
        return EncryptUtils.toSHA1Hex(input.getBytes(StandardCharsets.UTF_8));
    }

    public static String toSHA256Hex(byte[] input) {
        return EncryptUtils.toHexString(EncryptUtils.toSHA(input, "SHA-256"));
    }

    public static String toSHA256Hex(String input) {
        return EncryptUtils.toSHA256Hex(input.getBytes(StandardCharsets.UTF_8));
    }

    public static String toCRC32Hex(byte[] input) {
        CRC32 crc32 = new CRC32();
        crc32.update(input);
        return Long.toHexString(crc32.getValue());
    }

    @Deprecated
    public static String toCRC32HexPad(byte[] input) {
        return EncryptUtils.toCRC32HexPadding(input);
    }

    public static String toCRC32HexPadding(byte[] input) {
        String crc32 = EncryptUtils.toCRC32Hex(input);
        if (crc32.length() == 8) {
            return crc32;
        }
        return StringUtils.rightPad((String)crc32, (int)8, (char)'0');
    }

    public static String toHexString(byte[] data) {
        StringBuilder sb = new StringBuilder();
        for (byte b : data) {
            sb.append(String.format("%02x", b));
        }
        return sb.toString();
    }

    public static String aesEncrypt(String input, byte[] passwd) {
        try {
            SecretKeySpec key = EncryptUtils.buildAesSecretKey(passwd);
            Cipher cipher = Cipher.getInstance("AES");
            cipher.init(1, key);
            byte[] result = cipher.doFinal(input.getBytes(StandardCharsets.UTF_8));
            return new String(CodecUtils.base64Encode(result));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String aesDecrypt(String input, byte[] passwd) {
        try {
            SecretKeySpec key = EncryptUtils.buildAesSecretKey(passwd);
            Cipher cipher = Cipher.getInstance("AES");
            cipher.init(2, key);
            byte[] result = cipher.doFinal(CodecUtils.base64Decode(input.getBytes(StandardCharsets.UTF_8)));
            return new String(result);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static SecretKeySpec buildAesSecretKey(byte[] passwd) {
        try {
            KeyGenerator kgen = KeyGenerator.getInstance("AES");
            kgen.init(128, new SecureRandom(passwd));
            SecretKey secretKey = kgen.generateKey();
            byte[] enCodeFormat = secretKey.getEncoded();
            return new SecretKeySpec(enCodeFormat, "AES");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private EncryptUtils() {
    }
}

