/*
 * Decompiled with CFR 0.152.
 */
package cn.devezhao.commons;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public class DateFormatUtils {
    public static final Locale DEFAULT_LOCALE = Locale.CHINESE;
    public static final String CN_DATE_FORMAT = "yyyy\u5e74MM\u6708dd\u65e5";
    private static final ThreadLocal<DateFormat> CN_DATE_FORMAT_TL = ThreadLocal.withInitial(() -> new SimpleDateFormat(CN_DATE_FORMAT));
    public static final String CN_TIME_FORMAT = "HH\u65f6mm\u5206ss\u79d2";
    private static final ThreadLocal<DateFormat> CN_TIME_FORMAT_TL = ThreadLocal.withInitial(() -> new SimpleDateFormat(CN_TIME_FORMAT));
    public static final String CN_DATETIME_FORMAT = "yyyy\u5e74MM\u6708dd\u65e5 HH\u65f6mm\u5206ss\u79d2";
    private static final ThreadLocal<DateFormat> CN_DATETIME_FORMAT_TL = ThreadLocal.withInitial(() -> new SimpleDateFormat(CN_DATETIME_FORMAT));
    public static final String UTC_DATE_FORMAT = "yyyy-MM-dd";
    private static final ThreadLocal<DateFormat> UTC_DATE_FORMAT_TL = ThreadLocal.withInitial(() -> new SimpleDateFormat(UTC_DATE_FORMAT));
    public static final String UTC_DATETIME_FORMAT = "yyyy-MM-dd HH:mm:ss";
    private static final ThreadLocal<DateFormat> UTC_DATETIME_FORMAT_TL = ThreadLocal.withInitial(() -> new SimpleDateFormat(UTC_DATETIME_FORMAT));
    public static final String PLAIN_DATE_FORMAT = "yyyyMMdd";
    private static final ThreadLocal<DateFormat> PLAIN_DATE_FORMAT_TL = ThreadLocal.withInitial(() -> new SimpleDateFormat(PLAIN_DATE_FORMAT));
    public static final String PLAIN_DATETIME_FORMAT = "yyyyMMddHHmmss";
    private static final ThreadLocal<DateFormat> PLAIN_DATETIME_FORMAT_TL = ThreadLocal.withInitial(() -> new SimpleDateFormat(PLAIN_DATETIME_FORMAT));
    public static final String UTC_WITH_ZONE_DATETIME_FORMAT = "yyyy-MM-dd HH:mm:ss 'UTC'Z";
    private static final ThreadLocal<DateFormat> UTC_WITH_ZONE_DATETIME_FORMAT_TL = ThreadLocal.withInitial(() -> new SimpleDateFormat(UTC_WITH_ZONE_DATETIME_FORMAT));

    public static DateFormat getCNDateFormat() {
        return CN_DATE_FORMAT_TL.get();
    }

    public static DateFormat getCNTimeFormat() {
        return CN_TIME_FORMAT_TL.get();
    }

    public static DateFormat getCNDateTimeFormat() {
        return CN_DATETIME_FORMAT_TL.get();
    }

    public static DateFormat getUTCDateFormat() {
        return UTC_DATE_FORMAT_TL.get();
    }

    public static DateFormat getUTCDateTimeFormat() {
        return UTC_DATETIME_FORMAT_TL.get();
    }

    public static DateFormat getPlainDateFormat() {
        return PLAIN_DATE_FORMAT_TL.get();
    }

    public static DateFormat getPlainDateTimeFormat() {
        return PLAIN_DATETIME_FORMAT_TL.get();
    }

    public static DateFormat getUTCWithZoneDateTimeFormat() {
        return UTC_WITH_ZONE_DATETIME_FORMAT_TL.get();
    }

    public static DateFormat getDateFormat(String formatted) {
        return new SimpleDateFormat(formatted, DEFAULT_LOCALE);
    }

    public static String format(String formatted, Date date) {
        SimpleDateFormat sdf = new SimpleDateFormat(formatted, DEFAULT_LOCALE);
        return sdf.format(date);
    }
}

